/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.filter;

import com.supermartijn642.trashcans.filter.IFilterManager;
import com.supermartijn642.trashcans.filter.ItemFilter;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class LiquidTrashCanFilters {
    private static final Map<String, IFilterManager> managers = new HashMap<String, IFilterManager>();

    public static void register(IFilterManager manager, String id) {
        managers.put(id, manager);
    }

    public static ItemFilter createFilter(ItemStack stack) {
        for (Map.Entry<String, IFilterManager> entry : managers.entrySet()) {
            ItemFilter filter = entry.getValue().createFilter(stack);
            if (filter == null || !filter.isValid()) continue;
            filter.setId(entry.getKey());
            return filter;
        }
        return null;
    }

    public static CompoundTag write(ItemFilter filter) {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("id", filter.getId());
        compound.m_128365_("filter", (Tag)filter.write());
        return compound;
    }

    public static ItemFilter read(CompoundTag compound) {
        String id = compound.m_128461_("id");
        if (managers.containsKey(id)) {
            ItemFilter filter = managers.get(id).readFilter(compound.m_128469_("filter"));
            filter.setId(id);
            return filter.isValid() ? filter : null;
        }
        return null;
    }
}

