/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.param;

import com.mojang.serialization.Codec;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.transformer.LVTSnapshot;
import org.sinytra.adapter.patch.transformer.param.ParamTransformationUtil;
import org.sinytra.adapter.patch.transformer.param.ParameterTransformer;
import org.sinytra.adapter.patch.util.AdapterUtil;

public record RemoveParameterTransformer(int index) implements ParameterTransformer
{
    public static final Codec<RemoveParameterTransformer> CODEC = Codec.intRange((int)0, (int)255).fieldOf("index").xmap(RemoveParameterTransformer::new, RemoveParameterTransformer::index).codec();

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context, List<Type> parameters, int offset) {
        int target = this.index() + offset;
        int lvtIndex = ParamTransformationUtil.calculateLVTIndex(parameters, !methodContext.isStatic(), target);
        ParamTransformationUtil.extractWrapOperation(methodContext, methodNode, parameters, op -> op.removeParameter(target));
        LVTSnapshot.with(methodNode, () -> {
            LocalVariableNode lvn = methodNode.localVariables.stream().filter(v -> v.index == lvtIndex).findFirst().orElse(null);
            if (lvn != null) {
                methodNode.localVariables.remove(lvn);
                AdapterUtil.replaceLVT(methodNode, idx -> idx == lvtIndex ? -1 : idx);
            }
        });
        methodNode.parameters.remove(target);
        parameters.remove(target);
        return Patch.Result.COMPUTE_FRAMES;
    }

    @Override
    public Codec<? extends ParameterTransformer> codec() {
        return CODEC;
    }
}

