/*
 * Decompiled with CFR 0.152.
 */
package reloc.org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import reloc.org.sat4j.core.Vec;
import reloc.org.sat4j.core.VecInt;
import reloc.org.sat4j.minisat.core.ILits;
import reloc.org.sat4j.pb.ObjectiveFunction;
import reloc.org.sat4j.pb.constraints.pb.IDataStructurePB;
import reloc.org.sat4j.pb.constraints.pb.MapPb;
import reloc.org.sat4j.specs.ContradictionException;
import reloc.org.sat4j.specs.IVec;
import reloc.org.sat4j.specs.IVecInt;

public abstract class Pseudos {
    public static IDataStructurePB niceCheckedParameters(IVecInt ps, IVec<BigInteger> bigCoefs, boolean moreThan, BigInteger bigDeg, ILits voc) {
        assert (ps.size() != 0 && ps.size() == bigCoefs.size());
        int[] lits = new int[ps.size()];
        ps.copyTo(lits);
        BigInteger[] bc = new BigInteger[bigCoefs.size()];
        bigCoefs.copyTo(bc);
        BigInteger bigDegree = Pseudos.niceCheckedParametersForCompetition(lits, bc, moreThan, bigDeg);
        MapPb mpb = new MapPb(voc.nVars() * 2 + 2);
        if (bigDegree.signum() > 0) {
            bigDegree = mpb.cuttingPlane(lits, bc, bigDegree);
        }
        if (bigDegree.signum() > 0) {
            bigDegree = mpb.saturation();
        }
        if (bigDegree.signum() <= 0) {
            return IDataStructurePB.TAUTOLOGY;
        }
        return mpb;
    }

    public static BigInteger niceCheckedParametersForCompetition(int[] lits, BigInteger[] bc, boolean moreThan, BigInteger bigDeg) {
        int i;
        BigInteger bigDegree = bigDeg;
        if (!moreThan) {
            for (i = 0; i < lits.length; ++i) {
                bc[i] = bc[i].negate();
            }
            bigDegree = bigDegree.negate();
        }
        for (i = 0; i < bc.length; ++i) {
            if (bc[i].signum() >= 0) continue;
            lits[i] = lits[i] ^ 1;
            bc[i] = bc[i].negate();
            bigDegree = bigDegree.add(bc[i]);
        }
        for (i = 0; i < bc.length; ++i) {
            if (bc[i].compareTo(bigDegree) <= 0) continue;
            bc[i] = bigDegree;
        }
        return bigDegree;
    }

    public static IDataStructurePB niceParameters(IVecInt ps, IVec<BigInteger> bigCoefs, boolean moreThan, BigInteger bigDeg, ILits voc) throws ContradictionException {
        if (ps.size() == 0) {
            if (moreThan && bigDeg.signum() > 0 || !moreThan && bigDeg.signum() < 0) {
                throw new ContradictionException("Creating Empty clause ?");
            }
            return IDataStructurePB.TAUTOLOGY;
        }
        if (ps.size() != bigCoefs.size()) {
            throw new IllegalArgumentException("Contradiction dans la taille des tableaux ps=" + ps.size() + " coefs=" + bigCoefs.size() + ".");
        }
        return Pseudos.niceCheckedParameters(ps, bigCoefs, moreThan, bigDeg, voc);
    }

    public static BigInteger niceParametersForCompetition(int[] ps, BigInteger[] bigCoefs, boolean moreThan, BigInteger bigDeg) throws ContradictionException {
        if (ps.length == 0) {
            if (moreThan && bigDeg.signum() > 0 || !moreThan && bigDeg.signum() < 0) {
                throw new ContradictionException("Creating Empty clause ?");
            }
            return bigDeg;
        }
        if (ps.length != bigCoefs.length) {
            throw new IllegalArgumentException("Contradiction dans la taille des tableaux ps=" + ps.length + " coefs=" + bigCoefs.length + ".");
        }
        return Pseudos.niceCheckedParametersForCompetition(ps, bigCoefs, moreThan, bigDeg);
    }

    public static IVec<BigInteger> toVecBigInt(IVecInt vec) {
        Vec<BigInteger> bigVec = new Vec<BigInteger>(vec.size());
        for (int i = 0; i < vec.size(); ++i) {
            bigVec.push(BigInteger.valueOf(vec.get(i)));
        }
        return bigVec;
    }

    public static BigInteger toBigInt(int i) {
        return BigInteger.valueOf(i);
    }

    public static ObjectiveFunction normalizeObjective(ObjectiveFunction initial) {
        IVec<BigInteger> initCoeffs = initial.getCoeffs();
        IVecInt initLits = initial.getVars();
        assert (initCoeffs.size() == initLits.size());
        HashMap<Integer, BigInteger> reduced = new HashMap<Integer, BigInteger>();
        for (int i = 0; i < initLits.size(); ++i) {
            int lit = initLits.get(i);
            BigInteger oldCoef = (BigInteger)reduced.get(lit);
            if (oldCoef == null) {
                reduced.put(lit, initCoeffs.get(i));
                continue;
            }
            reduced.put(lit, oldCoef.add(initCoeffs.get(i)));
        }
        assert (reduced.size() <= initLits.size());
        if (reduced.size() < initLits.size()) {
            VecInt newLits = new VecInt(reduced.size());
            Vec<BigInteger> newCoefs = new Vec<BigInteger>(reduced.size());
            for (Map.Entry entry : reduced.entrySet()) {
                newLits.push((Integer)entry.getKey());
                newCoefs.push((BigInteger)entry.getValue());
            }
            return new ObjectiveFunction(newLits, newCoefs);
        }
        return initial;
    }
}

