/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.client.particle;

import com.teamabnormals.neapolitan.core.registry.NeapolitanParticleTypes;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;

@OnlyIn(value=Dist.CLIENT)
public class MilkDripParticle
extends TextureSheetParticle {
    private final Fluid type;
    protected boolean isGlowing;

    MilkDripParticle(ClientLevel p_106051_, double p_106052_, double p_106053_, double p_106054_, Fluid p_106055_) {
        super(p_106051_, p_106052_, p_106053_, p_106054_);
        this.m_107250_(0.01f, 0.01f);
        this.f_107226_ = 0.06f;
        this.type = p_106055_;
    }

    protected Fluid getType() {
        return this.type;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public int m_6355_(float p_106065_) {
        return this.isGlowing ? 240 : super.m_6355_(p_106065_);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.preMoveUpdate();
        if (!this.f_107220_) {
            this.f_107216_ -= (double)this.f_107226_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.postMoveUpdate();
            if (!this.f_107220_) {
                this.f_107215_ *= (double)0.98f;
                this.f_107216_ *= (double)0.98f;
                this.f_107217_ *= (double)0.98f;
                BlockPos blockpos = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
                FluidState fluidstate = this.f_107208_.m_6425_(blockpos);
                if (fluidstate.m_76152_() == this.type && this.f_107213_ < (double)((float)blockpos.m_123342_() + fluidstate.m_76155_((BlockGetter)this.f_107208_, blockpos))) {
                    this.m_107274_();
                }
            }
        }
    }

    protected void preMoveUpdate() {
        if (this.f_107225_-- <= 0) {
            this.m_107274_();
        }
    }

    protected void postMoveUpdate() {
    }

    @OnlyIn(value=Dist.CLIENT)
    static class FallingParticle
    extends MilkDripParticle {
        FallingParticle(ClientLevel p_106132_, double p_106133_, double p_106134_, double p_106135_, Fluid p_106136_) {
            this(p_106132_, p_106133_, p_106134_, p_106135_, p_106136_, (int)(64.0 / (Math.random() * 0.8 + 0.2)));
        }

        FallingParticle(ClientLevel p_172022_, double p_172023_, double p_172024_, double p_172025_, Fluid p_172026_, int p_172027_) {
            super(p_172022_, p_172023_, p_172024_, p_172025_, p_172026_);
            this.f_107225_ = p_172027_;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.f_107218_) {
                this.m_107274_();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class FallAndLandParticle
    extends FallingParticle {
        protected final ParticleOptions landParticle;

        FallAndLandParticle(ClientLevel p_106116_, double p_106117_, double p_106118_, double p_106119_, Fluid p_106120_, ParticleOptions p_106121_) {
            super(p_106116_, p_106117_, p_106118_, p_106119_, p_106120_);
            this.landParticle = p_106121_;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.f_107218_) {
                this.m_107274_();
                this.f_107208_.m_7106_(this.landParticle, this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.0, 0.0);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DripstoneWaterHangProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public DripstoneWaterHangProvider(SpriteSet p_172002_) {
            this.sprite = p_172002_;
        }

        public Particle createParticle(SimpleParticleType p_172013_, ClientLevel p_172014_, double p_172015_, double p_172016_, double p_172017_, double p_172018_, double p_172019_, double p_172020_) {
            DripHangParticle dripparticle = new DripHangParticle(p_172014_, p_172015_, p_172016_, p_172017_, (Fluid)ForgeMod.MILK.get(), (ParticleOptions)NeapolitanParticleTypes.FALLING_DRIPSTONE_MILK.get());
            dripparticle.m_107253_(1.0f, 1.0f, 1.0f);
            dripparticle.m_108335_(this.sprite);
            return dripparticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DripstoneWaterFallProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public DripstoneWaterFallProvider(SpriteSet p_171981_) {
            this.sprite = p_171981_;
        }

        public Particle createParticle(SimpleParticleType p_171992_, ClientLevel p_171993_, double p_171994_, double p_171995_, double p_171996_, double p_171997_, double p_171998_, double p_171999_) {
            DripstoneFallAndLandParticle dripparticle = new DripstoneFallAndLandParticle(p_171993_, p_171994_, p_171995_, p_171996_, (Fluid)ForgeMod.MILK.get(), (ParticleOptions)NeapolitanParticleTypes.MILK_SPLASH.get());
            dripparticle.m_107253_(0.87f, 0.95f, 0.96f);
            dripparticle.m_108335_(this.sprite);
            return dripparticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class DripstoneFallAndLandParticle
    extends FallAndLandParticle {
        DripstoneFallAndLandParticle(ClientLevel p_171930_, double p_171931_, double p_171932_, double p_171933_, Fluid p_171934_, ParticleOptions p_171935_) {
            super(p_171930_, p_171931_, p_171932_, p_171933_, p_171934_, p_171935_);
        }

        @Override
        protected void postMoveUpdate() {
            if (this.f_107218_) {
                this.m_107274_();
                this.f_107208_.m_7106_(this.landParticle, this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.0, 0.0);
                SoundEvent soundevent = this.getType() == Fluids.f_76195_ ? SoundEvents.f_144127_ : SoundEvents.f_144128_;
                float f = Mth.m_216283_((RandomSource)this.f_107223_, (float)0.3f, (float)1.0f);
                this.f_107208_.m_7785_(this.f_107212_, this.f_107213_, this.f_107214_, soundevent, SoundSource.BLOCKS, f, 1.0f, false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class DripHangParticle
    extends MilkDripParticle {
        private final ParticleOptions fallingParticle;

        DripHangParticle(ClientLevel p_106085_, double p_106086_, double p_106087_, double p_106088_, Fluid p_106089_, ParticleOptions p_106090_) {
            super(p_106085_, p_106086_, p_106087_, p_106088_, p_106089_);
            this.fallingParticle = p_106090_;
            this.f_107226_ *= 0.02f;
            this.f_107225_ = 40;
        }

        @Override
        protected void preMoveUpdate() {
            if (this.f_107225_-- <= 0) {
                this.m_107274_();
                this.f_107208_.m_7106_(this.fallingParticle, this.f_107212_, this.f_107213_, this.f_107214_, this.f_107215_, this.f_107216_, this.f_107217_);
            }
        }

        @Override
        protected void postMoveUpdate() {
            this.f_107215_ *= 0.02;
            this.f_107216_ *= 0.02;
            this.f_107217_ *= 0.02;
        }
    }
}

