/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.common.entity.goal;

import com.teamabnormals.neapolitan.common.entity.animal.Chimpanzee;
import com.teamabnormals.neapolitan.common.entity.util.ChimpanzeeAction;
import com.teamabnormals.neapolitan.core.other.tags.NeapolitanBlockTags;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ChimpJumpOnBouncyGoal
extends MoveToBlockGoal {
    private final Chimpanzee chimpanzee;
    private int jumps;

    public ChimpJumpOnBouncyGoal(Chimpanzee chimpanzeeIn, double speed, int length) {
        super((PathfinderMob)chimpanzeeIn, speed, length, 6);
        this.chimpanzee = chimpanzeeIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.chimpanzee.m_20159_()) {
            return false;
        }
        if (!this.chimpanzee.isDoingAction(ChimpanzeeAction.DEFAULT, ChimpanzeeAction.CLIMBING)) {
            return false;
        }
        if (this.chimpanzee.m_6162_() && this.chimpanzee.m_217043_().m_188503_(200) != 0) {
            return false;
        }
        if (!this.chimpanzee.m_6162_() && this.chimpanzee.m_217043_().m_188503_(600) != 0) {
            return false;
        }
        return this.m_25626_();
    }

    public boolean m_8045_() {
        if (this.jumps > 10) {
            return false;
        }
        if (this.chimpanzee.m_20159_()) {
            return false;
        }
        return super.m_8045_();
    }

    public void m_8056_() {
        super.m_8056_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.jumps = 0;
        this.chimpanzee.setDefaultAction();
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.m_25625_() && this.chimpanzee.getAction().canBeInterrupted()) {
            this.chimpanzee.setAction(ChimpanzeeAction.JUMPING);
            if (this.chimpanzee.m_20096_()) {
                this.chimpanzee.m_21569_().m_24901_();
                Vec3 vector3d = this.chimpanzee.m_20184_();
                this.chimpanzee.m_20256_(new Vec3(vector3d.f_82479_ * 0.1, vector3d.f_82480_, vector3d.f_82481_ * 0.1));
                ++this.jumps;
            }
        } else {
            this.chimpanzee.setDefaultAction();
        }
    }

    protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
        return worldIn.m_46859_(pos.m_7494_()) && worldIn.m_46859_(pos.m_7494_().m_7494_()) && worldIn.m_8055_(pos).m_204336_(NeapolitanBlockTags.CHIMPANZEE_JUMPING_BLOCKS) && !this.isBlockBeingJumpedOn((Level)worldIn, pos);
    }

    private boolean isBlockBeingJumpedOn(Level worldIn, BlockPos pos) {
        return !worldIn.m_6443_(Chimpanzee.class, new AABB(pos.m_7494_()), chimpanzee -> chimpanzee != this.chimpanzee && chimpanzee.isDoingAction(ChimpanzeeAction.JUMPING)).isEmpty();
    }
}

