/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.blocks.misc;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class PotBlock
extends Block {
    public static final VoxelShape THIN_SHAPE = Stream.of(Block.m_49796_((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0), Block.m_49796_((double)6.0, (double)11.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0)).reduce(Shapes::m_83110_).get();
    public static final VoxelShape MEDIUM_SHAPE = Stream.of(Block.m_49796_((double)3.0, (double)10.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), Block.m_49796_((double)4.0, (double)9.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0)).reduce(Shapes::m_83110_).get();
    public static final VoxelShape WIDE_SHAPE = Stream.of(Block.m_49796_((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0), Block.m_49796_((double)3.0, (double)5.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0)).reduce(Shapes::m_83110_).get();
    public static final VoxelShape THICK_SHAPE = Stream.of(Block.m_49796_((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0), Block.m_49796_((double)4.0, (double)11.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0)).reduce(Shapes::m_83110_).get();
    private final PotSize size;

    public PotBlock(PotSize size, BlockBehaviour.Properties properties) {
        super(properties);
        this.size = size;
    }

    public PotSize size() {
        return this.size;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch (this.size) {
            default -> throw new IncompatibleClassChangeError();
            case PotSize.THIN -> THIN_SHAPE;
            case PotSize.MEDIUM -> MEDIUM_SHAPE;
            case PotSize.WIDE -> WIDE_SHAPE;
            case PotSize.THICK -> THICK_SHAPE;
        };
    }

    public static enum PotSize {
        THIN,
        MEDIUM,
        WIDE,
        THICK;

    }
}

