/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.common;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.common.Constants;
import net.mehvahdjukaar.jeed.recipes.EffectProviderRecipe;
import net.mehvahdjukaar.jeed.recipes.PotionProviderRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public abstract class EffectWindowEntry {
    private static final Supplier<Map<MobEffect, List<ItemStack>>> STATIC_CACHE = Suppliers.memoize(EffectWindowEntry::buildStaticCache);
    protected final List<FormattedText> description;
    protected final MobEffectInstance effect;

    protected EffectWindowEntry(MobEffectInstance effectInstance, List<FormattedText> description) {
        this.description = description;
        this.effect = effectInstance;
    }

    public List<FormattedText> getDescription() {
        return this.description;
    }

    public MobEffectInstance getEffect() {
        return this.effect;
    }

    private static Map<MobEffect, List<ItemStack>> buildStaticCache() {
        HashMap<MobEffect, List<ItemStack>> effectProvidingItems = new HashMap<MobEffect, List<ItemStack>>();
        for (Block b : BuiltInRegistries.f_256975_) {
            if (!(b instanceof FlowerBlock)) continue;
            FlowerBlock flowerblock = (FlowerBlock)b;
            ItemStack stew = new ItemStack((ItemLike)Items.f_42718_);
            MobEffect effect = flowerblock.m_53521_();
            SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)effect, (int)200);
            effectProvidingItems.computeIfAbsent(effect, i -> new ItemStackList()).add(stew);
        }
        for (Item i2 : BuiltInRegistries.f_257033_) {
            FoodProperties food = i2.m_41473_();
            if (food == null) continue;
            ItemStack foodItem = new ItemStack((ItemLike)i2);
            for (Pair pair : food.m_38749_()) {
                MobEffectInstance first = (MobEffectInstance)pair.getFirst();
                if (first == null) continue;
                effectProvidingItems.computeIfAbsent(first.m_19544_(), s -> new ItemStackList()).add(foodItem);
            }
        }
        for (MobEffect[] array : BeaconBlockEntity.f_58646_) {
            for (MobEffect e : array) {
                effectProvidingItems.computeIfAbsent(e, s -> new ItemStackList()).add(Items.f_42065_.m_7968_());
            }
        }
        return effectProvidingItems;
    }

    public static List<MobEffect> computeEffectProviders(MobEffect effect) {
        ArrayList<MobEffect> list = new ArrayList<MobEffect>();
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            List recipes = world.m_7465_().m_44013_(Jeed.getEffectProviderType());
            for (EffectProviderRecipe recipeHolder : recipes) {
                for (MobEffect e : recipeHolder.getEffects()) {
                    if (e != effect) continue;
                    list.addAll(recipeHolder.effectProviders);
                }
            }
        }
        return list;
    }

    public static List<Fluid> computeFluidProvides(MobEffect effect) {
        ArrayList<Fluid> list = new ArrayList<Fluid>();
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            List recipes = world.m_7465_().m_44013_(Jeed.getEffectProviderType());
            for (EffectProviderRecipe recipeHolder : recipes) {
                for (MobEffect e : recipeHolder.getEffects()) {
                    if (e != effect) continue;
                    list.addAll(recipeHolder.fluidProviders);
                }
            }
        }
        return list;
    }

    public static List<ItemStack> computeItemProviders(MobEffect effect) {
        List<ItemStack> stat;
        ItemStackList list = new ItemStackList();
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            List recipes = world.m_7465_().m_44013_(Jeed.getEffectProviderType());
            for (EffectProviderRecipe p : recipes) {
                for (MobEffect e2 : p.getEffects()) {
                    if (e2 != effect) continue;
                    for (Ingredient i : p.m_7527_()) {
                        list.addAll(List.of(i.m_43908_()));
                    }
                }
            }
            List potionRecipes = world.m_7465_().m_44013_(Jeed.getPotionProviderType());
            for (PotionProviderRecipe p : potionRecipes) {
                List<Object> acceptablePotions = p.getPotions();
                if (acceptablePotions.isEmpty()) {
                    acceptablePotions = BuiltInRegistries.f_256980_.m_123024_().toList();
                }
                for (Potion potion : acceptablePotions) {
                    if (!potion.m_43488_().stream().anyMatch(e -> e.m_19544_() == effect)) continue;
                    for (Ingredient ing : p.m_7527_()) {
                        for (ItemStack stack : ing.m_43908_()) {
                            ItemStack copy = stack.m_41777_();
                            PotionUtils.m_43549_((ItemStack)copy, (Potion)potion);
                            list.add(copy);
                        }
                    }
                }
            }
        }
        if ((stat = STATIC_CACHE.get().get(effect)) != null) {
            list.addAll(stat);
        }
        return list;
    }

    public static List<Ingredient> groupIngredients(List<ItemStack> ingredients) {
        HashMap<Item, Ingredient> map = new HashMap<Item, Ingredient>();
        for (ItemStack stack : ingredients) {
            map.merge(stack.m_41720_(), Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}), EffectWindowEntry::mergeIngredients);
        }
        ArrayList<Map.Entry<Item, Ingredient>> entryList = EffectWindowEntry.sortIngredients(map);
        ArrayList<Ingredient> list = new ArrayList<Ingredient>();
        for (Map.Entry<Item, Ingredient> entry : entryList) {
            list.add(entry.getValue());
        }
        return list;
    }

    private static Ingredient mergeIngredients(Ingredient ingredient, Ingredient ingredient1) {
        return EffectWindowEntry.mergeIngredients(List.of(ingredient, ingredient1));
    }

    public static Ingredient mergeIngredients(List<Ingredient> ingredients) {
        ArrayList<ItemStack> l = new ArrayList<ItemStack>();
        for (Ingredient i : ingredients) {
            l.addAll(Arrays.stream(i.m_43908_()).toList());
        }
        return Ingredient.m_43927_((ItemStack[])l.toArray(new ItemStack[0]));
    }

    @NotNull
    private static ArrayList<Map.Entry<Item, Ingredient>> sortIngredients(Map<Item, Ingredient> map) {
        ArrayList<Map.Entry<Item, Ingredient>> entryList = new ArrayList<Map.Entry<Item, Ingredient>>(map.entrySet());
        entryList.sort((a, b) -> Constants.ID_COMPARATOR.compare(BuiltInRegistries.f_257033_.m_7981_((Object)((Item)a.getKey())), BuiltInRegistries.f_257033_.m_7981_((Object)((Item)b.getKey()))));
        return entryList;
    }

    public static <T, I> List<I> divideIntoSlots(List<T> ingredients, Function<List<T>, I> mapper) {
        ArrayList slotContents = new ArrayList();
        for (int slotId = 0; slotId < ingredients.size(); ++slotId) {
            int ind = slotId % (Constants.SLOTS_PER_ROW * Constants.ROWS);
            if (slotContents.size() <= ind) {
                slotContents.add(new ArrayList());
            }
            ((List)slotContents.get(ind)).add(ingredients.get(slotId));
        }
        return slotContents.stream().map(mapper).toList();
    }

    public static Component getDescription(MobEffect effect) {
        ResourceLocation name = BuiltInRegistries.f_256974_.m_7981_((Object)effect);
        String descriptionKey = "effect." + name.m_135827_() + "." + name.m_135815_() + ".description";
        MutableComponent text = Component.m_237115_((String)descriptionKey);
        if (text.getString().equals(descriptionKey)) {
            text = Component.m_237115_((String)"jeed.description.missing");
        }
        return text;
    }

    public static int getListHeight(List<?> inputs) {
        int listH = 0;
        if (Jeed.hasIngredientList() && !inputs.isEmpty()) {
            listH = Constants.MAX_BOX_HEIGHT;
            if (inputs.size() <= Constants.SLOTS_PER_ROW) {
                listH /= 2;
            }
        }
        return listH;
    }

    private static class ItemStackList
    extends ArrayList<ItemStack> {
        @Override
        public boolean add(ItemStack stack) {
            if (stack.m_41619_()) {
                return false;
            }
            for (ItemStack thisStack : this) {
                if (!ItemStack.m_41728_((ItemStack)thisStack, (ItemStack)stack)) continue;
                return false;
            }
            return super.add(stack);
        }
    }
}

