/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.events;

import com.pyzpre.createbitterballen.index.BlockRegistry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(modid="create_bic_bit")
public class LootTables {
    public static final ResourceLocation FISH = LootTables.register("gameplay/fishing/fish");
    private static final ResourceLocation SUNFLOWER = new ResourceLocation("minecraft", "blocks/sunflower");

    private static ResourceLocation register(String path) {
        return BuiltInLootTables.m_78769_((ResourceLocation)new ResourceLocation("create_bic_bit", path));
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        LootPool pool;
        ResourceLocation name = event.getName();
        if (name.equals((Object)BuiltInLootTables.f_78720_) && (pool = event.getTable().getPool("main")) != null) {
            LootTables.addEntry(pool, LootTables.getInjectEntry(FISH, 25, -1));
        }
        if (event.getName().equals((Object)SUNFLOWER)) {
            StatePropertiesPredicate.Builder lowerHalfCondition = StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.LOWER);
            LootItemBlockStatePropertyCondition.Builder condition = LootItemBlockStatePropertyCondition.m_81769_((Block)Blocks.f_50355_).m_81784_(lowerHalfCondition);
            LootPool sunflowerStemPool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_((LootItemCondition.Builder)condition).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)BlockRegistry.SUNFLOWERSTEM.get()))).m_79082_();
            LootTable table = event.getTable();
            table.addPool(sunflowerStemPool);
        }
    }

    private static LootPoolEntryContainer getInjectEntry(ResourceLocation location, int weight, int quality) {
        return LootTableReference.m_79776_((ResourceLocation)location).m_79707_(weight).m_79711_(quality).m_7512_();
    }

    private static void addEntry(LootPool pool, LootPoolEntryContainer entry) {
        try {
            Field entries = ObfuscationReflectionHelper.findField(LootPool.class, (String)"f_79023_");
            entries.setAccessible(true);
            LootPoolEntryContainer[] lootPoolEntriesArray = (LootPoolEntryContainer[])entries.get(pool);
            ArrayList<LootPoolEntryContainer> newLootEntries = new ArrayList<LootPoolEntryContainer>(List.of(lootPoolEntriesArray));
            if (newLootEntries.stream().anyMatch(e -> e == entry)) {
                throw new RuntimeException("Attempted to add a duplicate entry to pool: " + entry);
            }
            newLootEntries.add(entry);
            LootPoolEntryContainer[] newLootEntriesArray = new LootPoolEntryContainer[newLootEntries.size()];
            newLootEntries.toArray(newLootEntriesArray);
            entries.set(pool, newLootEntriesArray);
        }
        catch (IllegalAccessException e2) {
            e2.printStackTrace();
        }
    }
}

