/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BuntingBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class BuntingBlockTileRenderer
implements BlockEntityRenderer<BuntingBlockTile> {
    private static ModelPart MODEL;
    private static ModelPart FLAG;
    private static ModelPart BOX;

    public BuntingBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        MODEL = context.m_173582_(ClientRegistry.BUNTING_MODEL);
        FLAG = MODEL.m_171324_("flag");
        BOX = MODEL.m_171324_("box");
    }

    public boolean shouldRender(BuntingBlockTile blockEntity, Vec3 cameraPos) {
        return blockEntity.shouldRenderFancy(cameraPos);
    }

    public void render(BuntingBlockTile tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        BlockPos pos = tile.m_58899_();
        long l = tile.m_58904_().m_46467_();
        for (Direction d : Direction.Plane.HORIZONTAL) {
            DyeColor b = tile.getBunting(d);
            if (b == null) continue;
            BuntingBlockTileRenderer.renderBunting(b, d, partialTicks, poseStack, null, bufferIn, combinedLightIn, combinedOverlayIn, pos, l);
        }
        poseStack.m_85849_();
    }

    public static void renderBunting(DyeColor color, Direction dir, float partialTicks, PoseStack poseStack, @Nullable VertexConsumer vertexConsumer, @Nullable MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn, BlockPos pos, long l) {
        if (color != null) {
            VertexConsumer wrapped;
            poseStack.m_85836_();
            Vector3f step = dir.m_253071_().mul(0.25f);
            poseStack.m_252781_(RotHlpr.rot((Direction)dir));
            poseStack.m_85837_(0.0, 0.0, -0.25);
            poseStack.m_85841_(1.0f, -1.0f, -1.0f);
            Material mat = ModMaterials.BUNTING_MATERIAL.get(color);
            if (buffer != null) {
                float h = ((float)Math.floorMod((long)(((float)pos.m_123341_() + step.x) * 7.0f + ((float)pos.m_123342_() + step.y) * 9.0f + ((float)pos.m_123343_() + step.z) * 13.0f) + l, 100L) + partialTicks) / 100.0f;
                int i = dir.m_122421_() == Direction.AxisDirection.POSITIVE ? 1 : -1;
                BuntingBlockTileRenderer.FLAG.f_104205_ = (float)i * 0.01f * Mth.m_14089_((float)((float)Math.PI * 2 * h)) * (float)Math.PI;
                wrapped = mat.m_119194_(buffer, RenderType::m_110452_);
            } else {
                BuntingBlockTileRenderer.FLAG.f_104203_ = 0.0f;
                wrapped = mat.m_119204_().m_118381_(vertexConsumer);
            }
            BuntingBlockTileRenderer.BOX.f_233553_ = 1.0f;
            BuntingBlockTileRenderer.BOX.f_233554_ = 1.1f;
            BuntingBlockTileRenderer.BOX.f_233555_ = 1.1f;
            MODEL.m_104301_(poseStack, wrapped, combinedLightIn, combinedOverlayIn);
            poseStack.m_85849_();
        }
    }

    public static LayerDefinition createMesh() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("flag", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.5f, 0.0f, 0.0f, 7.0f, 11.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        partdefinition.m_171599_("box", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(-4.0f, -1.0f, -1.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)16);
    }
}

