/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.untitledduckmod.common.config.UntitledConfig;
import net.untitledduckmod.common.entity.WaterfowlEntity;
import net.untitledduckmod.common.entity.ai.goal.common.EatGoal;
import net.untitledduckmod.common.entity.ai.goal.common.SwimGoal;
import net.untitledduckmod.common.entity.ai.goal.common.WFollowOwnerGoal;
import net.untitledduckmod.common.entity.ai.goal.common.WFollowParentGoal;
import net.untitledduckmod.common.init.ModEntityTypes;
import net.untitledduckmod.common.init.ModItems;
import net.untitledduckmod.common.init.ModSoundEvents;
import net.untitledduckmod.common.init.ModTags;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.ParticleKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DuckEntity
extends WaterfowlEntity
implements VibrationSystem,
AnimationController.ParticleKeyframeHandler<DuckEntity> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String IS_FROM_SACK_TAG = "isFromSack";
    private static final EntityDataAccessor<Boolean> DANCING = SynchedEntityData.m_135353_(DuckEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final byte ANIMATION_DIVE = 2;
    private static final RawAnimation SWIM_CLEAN_ANIM = RawAnimation.begin().thenPlay("clean_swim").thenPlay("idle_swim");
    private static final RawAnimation DIVE_ANIM = RawAnimation.begin().thenPlay("dive").thenPlay("idle_swim");
    private static final RawAnimation DANCE_ANIM = RawAnimation.begin().thenPlay("dance");
    public static final Ingredient FOOD_INGREDIENT = Ingredient.m_204132_(ModTags.ItemTags.DUCK_FOOD);
    public static final Ingredient BREEDING_INGREDIENT = Ingredient.m_204132_(ModTags.ItemTags.DUCK_BREEDING_FOOD);
    public static final Ingredient TAMING_INGREDIENT = Ingredient.m_204132_(ModTags.ItemTags.DUCK_TAMING_FOOD);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean isFromSack = false;
    @Nullable
    private BlockPos jukeboxPos;
    private VibrationSystem.Data vibrationListenerData;
    private final VibrationSystem.User vibrationCallback;
    private final DynamicGameEventListener<JukeboxEventListener> jukeboxEventHandler;

    public DuckEntity(EntityType<? extends WaterfowlEntity> entityType, Level world) {
        super(entityType, world);
        this.maxVariant = 3;
        this.vibrationCallback = new VibrationCallback();
        this.vibrationListenerData = new VibrationSystem.Data();
        this.jukeboxEventHandler = new DynamicGameEventListener((GameEventListener)new JukeboxEventListener(this.vibrationCallback.m_280010_(), GameEvent.f_238690_.m_157827_()));
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 7.0).m_22268_(Attributes.f_22279_, 0.2).m_22266_(Attributes.f_22286_);
    }

    @Override
    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22286_)).m_22100_(2.0);
    }

    public static boolean checkDuckSpawnRules(EntityType<DuckEntity> duck, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        boolean isValidSurface;
        BlockState downState = world.m_8055_(pos.m_7495_());
        boolean bl = isValidSurface = downState.m_204336_(ModTags.BlockTags.DUCKS_SPAWNABLE_ON) || downState.m_60819_().m_205070_(FluidTags.f_13131_) || downState.m_60713_(Blocks.f_50126_) || downState.m_60713_(Blocks.f_50449_);
        boolean hasEnoughSpace = downState.m_60713_(Blocks.f_50126_) || downState.m_60713_(Blocks.f_50449_) ? world.m_8055_(pos).m_60795_() && world.m_8055_(pos.m_7494_()).m_60795_() : world.m_8055_(pos).m_60795_();
        return isValidSurface && hasEnoughSpace;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DANCING, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_(IS_FROM_SACK_TAG, this.isFromSack);
        DataResult result = VibrationSystem.Data.f_279637_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.vibrationListenerData);
        result.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(nbtElement -> tag.m_128365_("listener", nbtElement));
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setFromSack(tag.m_128471_(IS_FROM_SACK_TAG));
        if (tag.m_128425_("listener", 10)) {
            DataResult result = VibrationSystem.Data.f_279637_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128469_("listener")));
            result.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(listenerData -> {
                this.vibrationListenerData = listenerData;
            });
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            VibrationSystem.Ticker.m_280259_((Level)this.m_9236_(), (VibrationSystem.Data)this.vibrationListenerData, (VibrationSystem.User)this.vibrationCallback);
        }
    }

    public void m_6818_(BlockPos jukeboxPos, boolean playing) {
        if (playing) {
            if (!this.isDancing()) {
                this.jukeboxPos = jukeboxPos;
                this.setDancing(true);
            }
        } else if (jukeboxPos.equals((Object)this.jukeboxPos) || this.jukeboxPos == null) {
            this.jukeboxPos = null;
            this.setDancing(false);
        }
    }

    public boolean isDancing() {
        return (Boolean)this.f_19804_.m_135370_(DANCING);
    }

    public void setDancing(boolean dancing) {
        if (!(this.m_9236_().f_46443_ || !this.m_21515_() || dancing && this.panicked)) {
            if (dancing) {
                this.setAnimation((byte)3);
            } else {
                this.setAnimation((byte)0);
            }
            this.f_19804_.m_135381_(DANCING, (Object)dancing);
        }
    }

    private boolean shouldStopDancing() {
        return this.jukeboxPos == null || !this.jukeboxPos.m_203195_((Position)this.m_20182_(), (double)GameEvent.f_238690_.m_157827_()) || !this.m_9236_().m_8055_(this.jukeboxPos).m_60713_(Blocks.f_50131_) || this.panicked;
    }

    public VibrationSystem.Data m_280002_() {
        return this.vibrationListenerData;
    }

    public VibrationSystem.User m_280445_() {
        return this.vibrationCallback;
    }

    public void m_213651_(BiConsumer<DynamicGameEventListener<?>, ServerLevel> callback) {
        Level world = this.m_9236_();
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            callback.accept(this.jukeboxEventHandler, serverWorld);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new SwimGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.6));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new EatGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_INGREDIENT, false));
        this.f_21345_.m_25352_(5, (Goal)new WFollowParentGoal(this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new WFollowOwnerGoal(this, 1.6, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(6, (Goal)new CleanGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new DiveGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    public boolean isEdibleFood(ItemStack stack) {
        return !stack.m_41619_() && FOOD_INGREDIENT.test(stack);
    }

    public boolean m_6898_(ItemStack stack) {
        if (this.m_21824_()) {
            return TAMING_INGREDIENT.test(stack) || BREEDING_INGREDIENT.test(stack);
        }
        return BREEDING_INGREDIENT.test(stack);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && this.isDancing() && this.shouldStopDancing() && this.f_19797_ % 20 == 0) {
            this.setDancing(false);
            this.jukeboxPos = null;
        }
    }

    @Override
    protected void handlePanicAnimation() {
        if (!this.panicked && this.m_21188_() != null || this.m_6060_()) {
            this.setAnimation((byte)4);
            this.panicked = true;
        } else if (this.panicked && this.m_21188_() == null && !this.m_6060_()) {
            this.setAnimation((byte)0);
            this.panicked = false;
        }
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stackInHand = player.m_21120_(hand);
        if (stackInHand.m_41720_() == ModItems.EMPTY_DUCK_SACK.get()) {
            CompoundTag duckData = new CompoundTag();
            if (this.m_20086_(duckData)) {
                if (!player.m_150110_().f_35937_) {
                    stackInHand.m_41774_(1);
                }
                ItemStack duckSack = new ItemStack((ItemLike)ModItems.DUCK_SACK.get());
                CompoundTag sackData = new CompoundTag();
                sackData.m_128365_("EntityTag", (Tag)duckData);
                duckSack.m_41751_(sackData);
                if (stackInHand.m_41619_()) {
                    player.m_21008_(hand, duckSack);
                } else if (!player.m_36356_(duckSack)) {
                    player.m_36176_(duckSack, false);
                }
                this.m_9236_().m_5594_(null, this.m_20183_(), ModSoundEvents.DUCK_SACK_USE.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            } else {
                LOGGER.error("Could not save duck data to duck sack!");
            }
            this.m_146870_();
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Override
    protected boolean isTamableItem(ItemStack stack) {
        return TAMING_INGREDIENT.test(stack);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        DuckEntity duckEntity = (DuckEntity)ModEntityTypes.getDuck().m_20615_((Level)world);
        if (duckEntity != null && entity instanceof DuckEntity) {
            DuckEntity duck = (DuckEntity)entity;
            if (this.f_19796_.m_188499_()) {
                duckEntity.setVariant(this.getVariant());
            } else {
                duckEntity.setVariant(duck.getVariant());
            }
            if (this.m_21824_()) {
                duckEntity.m_21816_(this.m_21805_());
                duckEntity.m_7105_(true);
            }
        }
        return duckEntity;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate);
        controller.setParticleKeyframeHandler((AnimationController.ParticleKeyframeHandler)this);
        controllerRegistrar.add(new AnimationController[]{controller});
    }

    @Override
    protected SoundEvent getLayEggSound() {
        return ModSoundEvents.DUCK_LAY_EGG.get();
    }

    @Override
    public Item getEggItem() {
        return ModItems.DUCK_EGG.get();
    }

    private <P extends GeoAnimatable> PlayState predicate(AnimationState<P> event) {
        float limbSwingAmount = event.getLimbSwingAmount();
        boolean isMoving = !(limbSwingAmount > -0.05f) || !(limbSwingAmount < 0.05f);
        boolean inWater = this.m_20069_();
        AnimationController controller = event.getController();
        if (this.isFlapping) {
            controller.setAnimation(FLY_ANIM);
            return PlayState.CONTINUE;
        }
        if (this.m_21825_()) {
            controller.setAnimation(SIT_ANIM);
            return PlayState.CONTINUE;
        }
        byte currentAnimation = this.getAnimation();
        switch (currentAnimation) {
            case 1: {
                controller.setAnimation(inWater ? SWIM_CLEAN_ANIM : CLEAN_ANIM);
                break;
            }
            case 2: {
                controller.setAnimation(DIVE_ANIM);
                break;
            }
            case 3: {
                controller.setAnimation(DANCE_ANIM);
                break;
            }
            case 4: {
                controller.setAnimation(PANIC_ANIM);
                break;
            }
            case 5: {
                controller.setAnimation(EAT_ANIM);
                break;
            }
            default: {
                if (inWater) {
                    controller.setAnimation(isMoving ? SWIM_ANIM : SWIM_IDLE_ANIM);
                    break;
                }
                controller.setAnimation(isMoving ? WALK_ANIM : IDLE_ANIM);
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_8032_() {
        if (this.m_6162_()) {
            this.m_5496_(ModSoundEvents.DUCKLING_AMBIENT.get(), 0.3f, this.m_6100_());
            return;
        }
        this.m_5496_(ModSoundEvents.DUCK_AMBIENT.get(), 0.1f, this.m_6100_());
    }

    protected void m_6677_(DamageSource source) {
        if (this.m_6162_()) {
            this.m_5496_(ModSoundEvents.DUCKLING_HURT.get(), 0.3f, this.m_6100_() + 0.25f);
            return;
        }
        this.m_5496_(ModSoundEvents.DUCK_HURT.get(), 0.1f, this.m_6100_() + 0.5f);
    }

    @Nullable
    protected SoundEvent m_5592_() {
        if (this.m_6162_()) {
            return ModSoundEvents.DUCKLING_DEATH.get();
        }
        return ModSoundEvents.DUCK_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(ModSoundEvents.DUCK_STEP.get(), 0.15f, 1.0f);
    }

    public void handle(ParticleKeyframeEvent particleKeyframeEvent) {
        ItemStack stack = this.m_21205_();
        if (stack == ItemStack.f_41583_) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            Vec3 vel = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vel = vel.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
            vel = vel.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
            Vec3 rotationVec = Vec3.m_82498_((float)0.0f, (float)this.f_20883_);
            Vec3 pos = new Vec3(this.m_20185_() + rotationVec.f_82479_ / 2.0, this.m_20188_() - 0.2, this.m_20189_() + rotationVec.f_82481_ / 2.0);
            this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), pos.f_82479_, pos.f_82480_, pos.f_82481_, vel.f_82479_, vel.f_82480_ + 0.05, vel.f_82481_);
        }
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.isFromSack;
    }

    public boolean isFromSack() {
        return this.isFromSack;
    }

    public void setFromSack(boolean fromSack) {
        this.isFromSack = fromSack;
    }

    public ItemStack m_255207_(ItemStack equipment) {
        EquipmentSlot equipmentSlot = EquipmentSlot.MAINHAND;
        ItemStack itemStack = this.m_21205_();
        if (this.m_7252_(equipment)) {
            ItemEntity itemEntity;
            if (!itemStack.m_41619_() && (itemEntity = this.m_19983_(itemStack)) != null) {
                itemEntity.m_32010_(40);
            }
            this.m_21468_(equipmentSlot, equipment);
            return equipment;
        }
        return ItemStack.f_41583_;
    }

    protected void m_7581_(ItemEntity item) {
        if (this.m_21824_() && !this.m_21205_().m_41619_() && item.m_19749_() != null && !item.m_19749_().m_20148_().equals(this.m_21805_())) {
            return;
        }
        super.m_7581_(item);
    }

    public boolean m_7252_(ItemStack stack) {
        ItemStack mainHandStack = this.m_21205_();
        if (mainHandStack.m_41619_()) {
            return this.m_6898_(stack) || this.isTamableItem(stack);
        }
        if (this.m_21824_() && !mainHandStack.m_41619_()) {
            return this.m_6898_(stack);
        }
        return this.isTamableItem(mainHandStack) && this.m_6898_(stack);
    }

    public boolean m_21531_() {
        if (this.m_6162_()) {
            return false;
        }
        return !this.m_21205_().m_41619_() || this.isHungry();
    }

    public void fishing() {
        MinecraftServer server = this.m_9236_().m_7654_();
        if (!this.m_9236_().f_46443_ && server != null) {
            LootParams lootBuilder = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81463_, (Object)Items.f_42523_.m_7968_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287239_((float)this.m_21133_(Attributes.f_22286_)).m_287235_(LootContextParamSets.f_81414_);
            LootTable lootTable = server.m_278653_().m_278676_(BuiltInLootTables.f_78720_);
            ObjectArrayList list = lootTable.m_287195_(lootBuilder);
            for (ItemStack stack : list) {
                if (!this.m_21824_() && !this.isTamableItem(stack)) continue;
                this.m_21008_(InteractionHand.MAIN_HAND, stack);
                this.m_21468_(EquipmentSlot.MAINHAND, stack);
                break;
            }
        }
    }

    @Override
    public boolean tamedFollowOwner() {
        return !UntitledConfig.duckTamedNotFollow();
    }

    private class VibrationCallback
    implements VibrationSystem.User {
        private final PositionSource positionSource;

        private VibrationCallback() {
            this.positionSource = new EntityPositionSource((Entity)DuckEntity.this, DuckEntity.this.m_20192_());
        }

        public int m_280351_() {
            return 10;
        }

        public PositionSource m_280010_() {
            return this.positionSource;
        }

        public boolean m_280080_(ServerLevel world, BlockPos pos, GameEvent event, GameEvent.Context emitter) {
            return !DuckEntity.this.m_21525_();
        }

        public void m_280271_(ServerLevel world, BlockPos pos, GameEvent event, @Nullable Entity sourceEntity, @Nullable Entity entity, float distance) {
        }
    }

    private class JukeboxEventListener
    implements GameEventListener {
        private final PositionSource positionSource;
        private final int range;

        public JukeboxEventListener(PositionSource positionSource, int range) {
            this.positionSource = positionSource;
            this.range = range;
        }

        public PositionSource m_142460_() {
            return this.positionSource;
        }

        public int m_142078_() {
            return this.range;
        }

        public boolean m_214068_(ServerLevel world, GameEvent event, GameEvent.Context emitter, Vec3 emitterPos) {
            if (event == GameEvent.f_238690_) {
                DuckEntity.this.m_6818_(BlockPos.m_274446_((Position)emitterPos), true);
                return true;
            }
            if (event == GameEvent.f_238649_) {
                DuckEntity.this.m_6818_(BlockPos.m_274446_((Position)emitterPos), false);
                return true;
            }
            return false;
        }
    }

    static class CleanGoal
    extends Goal {
        private static final int ANIMATION_LENGTH = 32;
        private final DuckEntity duck;
        private int cleanTime;
        private int nextCleanTime;

        public CleanGoal(DuckEntity duck) {
            this.duck = duck;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nextCleanTime = duck.f_19797_ + (200 + duck.m_217043_().m_188503_(10) * 20);
        }

        public boolean m_8036_() {
            if (this.nextCleanTime > this.duck.f_19797_ || this.duck.m_21216_() >= 100 || this.duck.getAnimation() != 0) {
                return false;
            }
            return this.duck.m_217043_().m_188503_(40) == 0;
        }

        public void m_8056_() {
            this.cleanTime = 32;
            this.duck.setAnimation((byte)1);
            this.nextCleanTime = this.duck.f_19797_ + (200 + this.duck.m_217043_().m_188503_(10) * 20);
        }

        public void m_8041_() {
            this.duck.setAnimation((byte)0);
        }

        public boolean m_8045_() {
            return this.cleanTime >= 0;
        }

        public void m_8037_() {
            --this.cleanTime;
        }
    }

    static class DiveGoal
    extends Goal {
        private static final int ANIMATION_LENGTH = 32;
        private final DuckEntity duck;
        private int diveTime;
        private int nextDiveTime;

        public DiveGoal(DuckEntity duck) {
            this.duck = duck;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nextDiveTime = duck.f_19797_ + (160 + duck.m_217043_().m_188503_(10) * 20);
        }

        public boolean m_8036_() {
            if (this.nextDiveTime > this.duck.f_19797_ || this.duck.m_21216_() >= 100 || !this.duck.m_20069_() || this.duck.getAnimation() != 0) {
                return false;
            }
            return this.duck.m_217043_().m_188503_(40) == 0 && this.duck.m_21205_().m_41619_();
        }

        public void m_8056_() {
            this.diveTime = 32;
            this.duck.setAnimation((byte)2);
            this.nextDiveTime = this.duck.f_19797_ + (160 + this.duck.m_217043_().m_188503_(10) * 20);
        }

        public void m_8041_() {
            this.duck.setAnimation((byte)0);
        }

        public boolean m_8045_() {
            return this.diveTime >= 0;
        }

        public void m_8037_() {
            --this.diveTime;
            if (this.diveTime == 22) {
                if (this.duck.m_217043_().m_188500_() < UntitledConfig.duckFishingChange()) {
                    this.duck.fishing();
                }
                this.duck.m_5496_(SoundEvents.f_11917_, 1.0f, 1.0f);
            }
        }
    }
}

