/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.client.gui.KegScreen;
import umpaz.brewinandchewin.client.utility.BnCFluidItemDisplays;
import umpaz.brewinandchewin.common.BnCConfiguration;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.common.block.entity.container.KegStackedContents;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.mixin.client.RecipeBookComponentAccessor;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.common.utility.BnCTextUtils;

public class KegRecipeBookComponent
extends RecipeBookComponent {
    private final RecipeManager recipeManager;
    protected static final ResourceLocation RECIPE_BOOK_BUTTONS = BrewinAndChewin.asResource("textures/gui/recipe_book_buttons.png");
    private static final Component FILTER_NAME = Component.m_237115_((String)"brewinandchewin.container.recipe_book.fermentable");

    public KegRecipeBookComponent(RecipeManager recipeManager) {
        this.recipeManager = recipeManager;
    }

    public void m_181404_() {
        RecipeBookMenu recipeBookMenu = this.f_100271_;
        if (recipeBookMenu instanceof KegMenu) {
            KegMenu kegMenu = (KegMenu)recipeBookMenu;
            ((RecipeBookComponentAccessor)((Object)this)).brewinandchewin$setStackedContents(new KegStackedContents(kegMenu, this.recipeManager));
        }
        super.m_181404_();
    }

    protected void m_5674_() {
        this.f_100270_.m_94624_(0, 0, 28, 18, RECIPE_BOOK_BUTTONS);
    }

    public void hide() {
        this.m_100369_(false);
    }

    @Nullable
    public Recipe<?> getGhostRecipe() {
        return this.f_100269_.m_100159_();
    }

    @Nonnull
    protected Component m_5815_() {
        return FILTER_NAME;
    }

    public void m_280545_(GuiGraphics gui, int renderX, int renderY, int mouseX, int mouseY) {
        RecipeBookMenu recipeBookMenu;
        super.m_280545_(gui, renderX, renderY, mouseX, mouseY);
        if (this.m_100385_() && (recipeBookMenu = this.f_100271_) instanceof KegMenu) {
            KegMenu kegMenu = (KegMenu)recipeBookMenu;
            Recipe recipe = this.f_100269_.m_100159_();
            if (recipe instanceof KegFermentingRecipe) {
                FluidStack fluidStack;
                KegFermentingRecipe fermentingRecipe = (KegFermentingRecipe)recipe;
                if (!KegBlockEntity.isValidTemp(kegMenu.getKegTemperature(), fermentingRecipe.getTemperature())) {
                    this.renderTemperatureTooltip(gui, renderX, renderY, mouseX, mouseY);
                }
                if ((fluidStack = fermentingRecipe.getFluidIngredient()) == null) {
                    return;
                }
                if (!kegMenu.kegTank.getFluid().getFluid().m_6212_(fluidStack.getRawFluid())) {
                    this.renderTankTooltip(gui, renderX, renderY, mouseX, mouseY, fluidStack);
                }
            }
        }
    }

    public void m_280128_(GuiGraphics gui, int leftPos, int topPos, boolean singleItem, float partialTick) {
        this.f_100269_.m_280269_(gui, this.f_100272_, leftPos, topPos, singleItem, partialTick);
        if (this.f_100269_.m_100159_() == null) {
            return;
        }
        RecipeBookMenu recipeBookMenu = this.f_100271_;
        if (recipeBookMenu instanceof KegMenu) {
            KegMenu kegMenu = (KegMenu)recipeBookMenu;
            Recipe recipe = this.f_100269_.m_100159_();
            if (recipe instanceof KegFermentingRecipe) {
                FluidStack fluidStack;
                KegFermentingRecipe fermentingRecipe = (KegFermentingRecipe)recipe;
                if (!KegBlockEntity.isValidTemp(kegMenu.getKegTemperature(), fermentingRecipe.getTemperature())) {
                    RenderSystem.enableBlend();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
                    int temp = fermentingRecipe.getTemperature();
                    int minX = leftPos + 52;
                    int maxX = minX + 8;
                    if (temp < 3) {
                        gui.m_280218_(KegScreen.BACKGROUND_TEXTURE, leftPos + KegScreen.CHILLY_BAR.x(), topPos + KegScreen.CHILLY_BAR.y(), 184, 0, KegScreen.CHILLY_BAR.width(), KegScreen.CHILLY_BAR.height());
                        minX = leftPos + KegScreen.CHILLY_BAR.x();
                    }
                    if (temp == 1) {
                        gui.m_280218_(KegScreen.BACKGROUND_TEXTURE, leftPos + KegScreen.COLD_BAR.x(), topPos + KegScreen.COLD_BAR.y(), 176, 0, KegScreen.COLD_BAR.width(), KegScreen.COLD_BAR.height());
                        minX = leftPos + KegScreen.COLD_BAR.x();
                    }
                    if (temp > 3) {
                        gui.m_280218_(KegScreen.BACKGROUND_TEXTURE, leftPos + KegScreen.WARM_BAR.x(), topPos + KegScreen.WARM_BAR.y(), 201, 0, KegScreen.WARM_BAR.width(), KegScreen.WARM_BAR.height());
                        maxX = leftPos + KegScreen.WARM_BAR.x() + KegScreen.WARM_BAR.width();
                    }
                    if (temp == 5) {
                        gui.m_280218_(KegScreen.BACKGROUND_TEXTURE, leftPos + KegScreen.HOT_BAR.x(), topPos + KegScreen.HOT_BAR.y(), 210, 0, KegScreen.HOT_BAR.width(), KegScreen.HOT_BAR.height());
                        maxX = leftPos + KegScreen.HOT_BAR.x() + KegScreen.HOT_BAR.width();
                    }
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.disableBlend();
                    gui.m_280509_(minX, topPos + 55, maxX, topPos + 58, 0x30FF0000);
                }
                if ((fluidStack = fermentingRecipe.getFluidIngredient()) == null && !kegMenu.kegTank.isEmpty() || fluidStack != null && !kegMenu.kegTank.getFluid().getFluid().m_6212_(fluidStack.getRawFluid())) {
                    IClientFluidTypeExtensions fluidTypeExtensions;
                    ResourceLocation stillTexture;
                    if (fluidStack != null && ((Boolean)BnCConfiguration.RENDER_FLUID_IN_KEG.get()).booleanValue() && (stillTexture = (fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid())).getStillTexture(fluidStack)) != null) {
                        int y2;
                        int y1;
                        TextureAtlasSprite sprite = (TextureAtlasSprite)this.f_100272_.m_91258_(InventoryMenu.f_39692_).apply(stillTexture);
                        int tintColor = fluidTypeExtensions.getTintColor(fluidStack);
                        float alpha = (float)(tintColor >> 24 & 0xFF) / 255.0f / 3.0f;
                        float red = (float)(tintColor >> 16 & 0xFF) / 255.0f;
                        float green = (float)(tintColor >> 8 & 0xFF) / 255.0f;
                        float blue = (float)(tintColor & 0xFF) / 255.0f;
                        float capacity = (float)fermentingRecipe.getFluidIngredient().getAmount() / (float)kegMenu.kegTank.getCapacity();
                        if (capacity > 0.57f) {
                            y1 = topPos + 19 + (int)(12.0f * (1.0f - (capacity - 0.57f) / 0.43f));
                            y2 = topPos + 19 + 12;
                            float topCapacity = (capacity - 0.57f) / 0.43f;
                            float vDistance = sprite.m_118412_() - sprite.m_118411_();
                            float v0 = sprite.m_118411_() + 0.25f * vDistance + 0.75f * vDistance * (1.0f - topCapacity);
                            gui.m_280479_(sprite.m_247685_(), leftPos + 120, leftPos + 120 + 16, y1, y2, 0, sprite.m_118409_(), sprite.m_118410_(), v0, sprite.m_118412_(), red, green, blue, alpha);
                            gui.m_280479_(sprite.m_247685_(), leftPos + 120 + 16, leftPos + 120 + 16 + 8, y1, y2, 0, sprite.m_118409_(), sprite.m_118409_() + 0.5f * (sprite.m_118410_() - sprite.m_118409_()), v0, sprite.m_118412_(), red, green, blue, alpha);
                        }
                        y1 = topPos + 31 + (int)(16.0f * (1.0f - Math.min(1.0f, capacity / 0.57f)));
                        y2 = topPos + 31 + 16;
                        float vDistance = sprite.m_118412_() - sprite.m_118411_();
                        float v0 = sprite.m_118411_() + vDistance * (1.0f - Math.min(1.0f, capacity / 0.57f));
                        gui.m_280479_(sprite.m_247685_(), leftPos + 120, leftPos + 120 + 16, y1, y2, 0, sprite.m_118409_(), sprite.m_118410_(), v0, sprite.m_118412_(), red, green, blue, alpha);
                        gui.m_280479_(sprite.m_247685_(), leftPos + 120 + 16, leftPos + 120 + 16 + 8, y1, y2, 0, sprite.m_118409_(), sprite.m_118409_() + 0.5f * (sprite.m_118410_() - sprite.m_118409_()), v0, sprite.m_118412_(), red, green, blue, alpha);
                    }
                    gui.m_280509_(leftPos + 120, topPos + 19, leftPos + 120 + 16 + 8, topPos + 31 + 16, 0x30FF0000);
                    if (fluidStack != null) {
                        ItemStack itemDisplay = BnCFluidItemDisplays.getFluidItemDisplay(Minecraft.m_91087_().f_91073_.m_9598_(), fluidStack).m_41777_();
                        int pourCount = Math.min(fermentingRecipe.getFluidIngredient().getAmount(), kegMenu.kegTank.getCapacity()) / 250;
                        itemDisplay.m_41764_(pourCount);
                        if (!itemDisplay.m_41619_()) {
                            int itemX = leftPos + 124;
                            int itemY = topPos + 23;
                            gui.m_280480_(itemDisplay, itemX, itemY);
                            gui.m_285944_(RenderType.m_285811_(), itemX, itemY, itemX + 16, itemY + 16, 0x30FFFFFF);
                            gui.m_280370_(this.f_100272_.f_91062_, itemDisplay, itemX, itemY);
                        }
                    }
                }
            }
        }
    }

    private void renderTankTooltip(GuiGraphics gui, int renderX, int renderY, int mouseX, int mouseY, FluidStack stack) {
        RecipeBookMenu recipeBookMenu;
        if (this.isHovering(108, 19, 24, 28, mouseX - renderX, mouseY - renderY) && (recipeBookMenu = this.f_100271_) instanceof KegMenu) {
            KegMenu kegMenu = (KegMenu)recipeBookMenu;
            if (!kegMenu.kegTank.isEmpty()) {
                gui.m_280557_(this.f_100272_.f_91062_, stack.getDisplayName(), mouseX, mouseY);
            }
        }
    }

    private void renderTemperatureTooltip(GuiGraphics gui, int renderX, int renderY, int mouseX, int mouseY) {
        Recipe<?> recipe;
        if (this.isHovering(34, 54, 43, 5, mouseX - renderX, mouseY - renderY) && (recipe = this.f_100271_) instanceof KegMenu) {
            KegMenu kegMenu = (KegMenu)recipe;
            recipe = this.getGhostRecipe();
            if (recipe instanceof KegFermentingRecipe) {
                KegFermentingRecipe fermentingRecipe = (KegFermentingRecipe)recipe;
                if (!KegBlockEntity.isValidTemp(kegMenu.getKegTemperature(), fermentingRecipe.getTemperature())) {
                    MutableComponent key = switch (fermentingRecipe.getTemperature()) {
                        case 1 -> BnCTextUtils.getTranslation("container.keg.cold", new Object[0]);
                        case 2 -> BnCTextUtils.getTranslation("container.keg.chilly", new Object[0]);
                        case 4 -> BnCTextUtils.getTranslation("container.keg.warm", new Object[0]);
                        case 5 -> BnCTextUtils.getTranslation("container.keg.hot", new Object[0]);
                        default -> BnCTextUtils.getTranslation("container.keg.normal", new Object[0]);
                    };
                    gui.m_280666_(this.f_100272_.f_91062_, List.of(Component.m_237110_((String)"brewinandchewin.container.keg.temperature_requirement", (Object[])new Object[]{key})), mouseX, mouseY);
                }
            }
        }
    }

    private boolean isHovering(int x, int y, int xWidth, int yWidth, int mouseX, int mouseY) {
        int maxX = x + xWidth;
        int maxY = y + yWidth;
        return mouseX >= x && mouseX <= maxX && mouseY >= y && mouseY <= maxY;
    }

    public void m_7173_(Recipe<?> recipe, List<Slot> slots) {
        KegFermentingRecipe fermentingRecipe;
        ItemStack resultStack = recipe.m_8043_(this.f_100272_.f_91073_.m_9598_()).m_41777_();
        this.f_100269_.m_100147_(recipe);
        if (slots.get(5).m_7993_().m_41619_()) {
            this.f_100269_.m_100143_(Ingredient.m_43927_((ItemStack[])new ItemStack[]{resultStack}), slots.get((int)5).f_40220_, slots.get((int)5).f_40221_);
        }
        if (recipe instanceof KegFermentingRecipe && (fermentingRecipe = (KegFermentingRecipe)recipe).getResultFluid() != null) {
            Optional<KegPouringRecipe> pouringRecipe = this.recipeManager.m_44013_((RecipeType)BnCRecipeTypes.KEG_POURING.get()).stream().filter(kegPouringRecipe -> kegPouringRecipe.getRawFluid().m_6212_(fermentingRecipe.getResultFluid())).findFirst();
            pouringRecipe.ifPresent(kegPouringRecipe -> this.f_100269_.m_100143_(Ingredient.m_43927_((ItemStack[])new ItemStack[]{kegPouringRecipe.getContainer()}), ((Slot)slots.get((int)4)).f_40220_, ((Slot)slots.get((int)4)).f_40221_));
        }
        this.m_135408_(this.f_100271_.m_6635_(), this.f_100271_.m_6656_(), this.f_100271_.m_6636_(), recipe, recipe.m_7527_().iterator(), 0);
    }
}

