/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.capability;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.network.BnCNetworkHandler;
import umpaz.brewinandchewin.common.network.clientbound.SyncNumbedHeartsClientboundPacket;

public class TipsyNumbedHeartsCapability
implements ICapabilitySerializable<CompoundTag> {
    public static final ResourceLocation ID = BrewinAndChewin.asResource("tipsy_numbed_hearts");
    public static final Capability<TipsyNumbedHeartsCapability> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<TipsyNumbedHeartsCapability>(){});
    private final LazyOptional<TipsyNumbedHeartsCapability> thisOptional = LazyOptional.of(() -> this);
    private final LivingEntity provider;
    private float numbedHealth = 0.0f;
    private int ticksUntilDamage = 0;

    public TipsyNumbedHeartsCapability(LivingEntity provider) {
        this.provider = provider;
    }

    public float getNumbedHealth() {
        return this.numbedHealth;
    }

    public void setNumbedHealth(float value) {
        this.numbedHealth = value;
    }

    public int getTicksUntilDamage() {
        return this.ticksUntilDamage;
    }

    public void setTicksUntilDamage(int value) {
        this.ticksUntilDamage = value;
    }

    public void setFrom(TipsyNumbedHeartsCapability cap) {
        if (cap == null) {
            return;
        }
        this.numbedHealth = cap.numbedHealth;
        this.ticksUntilDamage = cap.ticksUntilDamage;
    }

    public void syncToPlayer(ServerPlayer player) {
        if (this.provider.m_9236_().m_5776_()) {
            return;
        }
        BnCNetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncNumbedHeartsClientboundPacket(this.provider.m_19879_(), this.numbedHealth, this.ticksUntilDamage));
    }

    public void sync() {
        if (this.provider.m_9236_().m_5776_()) {
            return;
        }
        BnCNetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.provider), (Object)new SyncNumbedHeartsClientboundPacket(this.provider.m_19879_(), this.numbedHealth, this.ticksUntilDamage));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return INSTANCE.orEmpty(cap, this.thisOptional);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("numbed_health", this.numbedHealth);
        tag.m_128405_("ticks_until_damage", this.ticksUntilDamage);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.numbedHealth = nbt.m_128457_("numbed_health");
        this.ticksUntilDamage = nbt.m_128451_("ticks_until_damage");
    }
}

