/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.block;

import com.google.common.collect.Maps;
import com.teamabnormals.endergetic.core.other.EEEvents;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CorrockPlantBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final Map<ResourceLocation, Supplier<Block>> CONVERSIONS = (Map)Util.m_137469_((Object)Maps.newHashMap(), conversions -> {
        conversions.put(BuiltinDimensionTypes.f_223538_.m_135782_(), EEBlocks.OVERWORLD_CORROCK);
        conversions.put(BuiltinDimensionTypes.f_223539_.m_135782_(), EEBlocks.NETHER_CORROCK);
        conversions.put(BuiltinDimensionTypes.f_223540_.m_135782_(), EEBlocks.END_CORROCK);
    });
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);
    public final boolean petrified;

    public CorrockPlantBlock(BlockBehaviour.Properties properties, boolean petrified) {
        super(properties);
        this.petrified = petrified;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        return SoundType.f_56753_;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        Block conversionBlock = this.getConversionBlock((LevelAccessor)level);
        if (!this.petrified && conversionBlock != this) {
            level.m_46597_(pos, conversionBlock.m_49966_());
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
            if (!this.petrified) {
                return EEEvents.convertCorrockBlock(stateIn);
            }
        }
        if (this.shouldConvert(worldIn)) {
            worldIn.m_186460_(currentPos, (Block)this, 60 + worldIn.m_213780_().m_188503_(40));
        }
        return stateIn;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        return worldIn.m_8055_(blockpos).m_60783_((BlockGetter)worldIn, blockpos, Direction.UP);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (this.shouldConvert((LevelAccessor)context.m_43725_())) {
            context.m_43725_().m_186460_(context.m_8083_(), (Block)this, 60 + context.m_43725_().m_213780_().m_188503_(40));
        }
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76186_() >= 8));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    protected Block getConversionBlock(LevelAccessor level) {
        return (Block)((Supplier)CONVERSIONS.getOrDefault(((Registry)level.m_9598_().m_6632_(Registries.f_256787_).get()).m_7981_((Object)level.m_6042_()), (Supplier<Block>)EEBlocks.OVERWORLD_CORROCK)).get();
    }

    private boolean shouldConvert(LevelAccessor level) {
        return !this.petrified && this.getConversionBlock(level) != this;
    }
}

