/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.block.entity;

import com.teamabnormals.blueprint.core.endimator.TimedEndimation;
import com.teamabnormals.blueprint.core.util.MathUtil;
import com.teamabnormals.endergetic.api.util.StringUtils;
import com.teamabnormals.endergetic.common.block.poise.BolloomBudBlock;
import com.teamabnormals.endergetic.common.entity.bolloom.BolloomFruit;
import com.teamabnormals.endergetic.common.entity.puffbug.PuffBug;
import com.teamabnormals.endergetic.core.registry.EEBlockEntityTypes;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class BolloomBudTileEntity
extends BlockEntity {
    public final TimedEndimation pedalAnimation = new TimedEndimation(20, 20);
    private EnumMap<BudSide, SideData> sideData = (EnumMap)Util.m_137469_(new EnumMap(BudSide.class), side -> {
        side.put(BudSide.NORTH, new SideData());
        side.put(BudSide.EAST, new SideData());
        side.put(BudSide.SOUTH, new SideData());
        side.put(BudSide.WEST, new SideData());
    });
    private int maxFruitHeight = 7;
    private UUID teleportingBug;

    public BolloomBudTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EEBlockEntityTypes.BOLLOOM_BUD.get(), pos, state);
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BolloomBudTileEntity bud) {
        Random rand = new Random();
        bud.sideData.forEach((side, sideData) -> {
            if (sideData.growTimer > 0 && sideData.growing) {
                --sideData.growTimer;
            }
            if (sideData.growing && sideData.growTimer <= 0) {
                if (!bud.f_58857_.m_5776_() && ((Boolean)bud.m_58900_().m_61143_((Property)BolloomBudBlock.OPENED)).booleanValue()) {
                    int height = rand.nextInt(bud.maxFruitHeight) + 1;
                    BolloomFruit fruit = new BolloomFruit(bud.f_58857_, bud.f_58858_, bud.f_58858_.m_6630_(height - 1), height, side.direction);
                    bud.f_58857_.m_7967_((Entity)fruit);
                    sideData.fruitUUID = fruit.m_20148_();
                    bud.m_6596_();
                }
                sideData.growing = false;
                sideData.growTimer = 0;
            }
        });
        if (((Boolean)bud.m_58900_().m_61143_((Property)BolloomBudBlock.OPENED)).booleanValue() && !bud.f_58857_.m_5776_() && bud.shouldShutBud() && rand.nextInt(200) == 0) {
            bud.f_58857_.m_7731_(bud.f_58858_, (BlockState)bud.m_58900_().m_61124_((Property)BolloomBudBlock.OPENED, (Comparable)Boolean.valueOf(false)), 2);
            bud.resetGrowing();
        }
        bud.pedalAnimation.tick();
        if (bud.f_58857_.isAreaLoaded(bud.f_58858_, 1)) {
            boolean opened = (Boolean)bud.m_58900_().m_61143_((Property)BolloomBudBlock.OPENED);
            if (bud.pedalAnimation.isDecrementing() != opened) {
                bud.pedalAnimation.setDecrementing(opened);
            }
        }
        if (!bud.f_58857_.f_46443_ && bud.teleportingBug != null) {
            Entity entity = ((ServerLevel)bud.f_58857_).m_8791_(bud.teleportingBug);
            if (entity != null && !entity.m_6084_()) {
                bud.teleportingBug = null;
            } else if (entity == null) {
                bud.teleportingBug = null;
            }
        }
    }

    public void startGrowing(RandomSource rand, int maxHeight, boolean instant) {
        boolean didOneGrow = false;
        this.maxFruitHeight = maxHeight;
        if (instant) {
            this.pedalAnimation.setTick(0);
        }
        for (Map.Entry<BudSide, SideData> data : this.sideData.entrySet()) {
            if (!rand.m_188499_()) continue;
            data.getValue().growing = true;
            data.getValue().growTimer = instant ? 0 : rand.m_188503_(220) + 60;
            didOneGrow = true;
        }
        if (!didOneGrow) {
            SideData sideData = this.sideData.get((Object)BudSide.random(rand));
            sideData.growing = true;
            sideData.growTimer = instant ? 0 : rand.m_188503_(220) + 60;
        }
    }

    public void resetGrowing() {
        this.sideData.forEach((side, sideData) -> {
            sideData.fruitUUID = null;
            sideData.growing = false;
            sideData.growTimer = 0;
        });
        this.maxFruitHeight = 7;
    }

    public void setTeleportingBug(@Nullable PuffBug puffbug) {
        this.teleportingBug = puffbug != null ? puffbug.m_20148_() : null;
    }

    public boolean hasTeleportingBug() {
        return this.teleportingBug != null;
    }

    public boolean canBeOpened() {
        Block block = (Block)EEBlocks.BOLLOOM_BUD.get();
        for (Direction directions : Direction.values()) {
            if (this.f_58857_.m_8055_(this.f_58858_.m_5484_(directions, 2)).m_60734_() != block) continue;
            return false;
        }
        BlockPos north = this.f_58858_.m_121945_(Direction.NORTH);
        BlockPos south = this.f_58858_.m_121945_(Direction.SOUTH);
        if (this.f_58857_.m_8055_(north.m_122029_()).m_60734_() == block || this.f_58857_.m_8055_(south.m_122029_()).m_60734_() == block || this.f_58857_.m_8055_(north.m_122024_()).m_60734_() == block || this.f_58857_.m_8055_(south.m_122024_()).m_60734_() == block) {
            return false;
        }
        for (BudSide sides : BudSide.values()) {
            BlockPos sidePos = sides.offsetPosition(this.f_58858_);
            if (this.f_58857_.m_6425_(sidePos).m_76178_() && this.f_58857_.m_8055_(sidePos).m_60812_((BlockGetter)this.f_58857_, sidePos).m_83281_()) continue;
            return false;
        }
        return (Boolean)this.m_58900_().m_61143_((Property)BolloomBudBlock.OPENED) == false && this.calculateFruitMaxHeight() >= 3;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.maxFruitHeight = tag.m_128441_("MaxFruitHeight") ? Mth.m_14045_((int)tag.m_128451_("MaxFruitHeight"), (int)1, (int)7) : 7;
        this.sideData.forEach((side, sideData) -> {
            String sideName = StringUtils.capitaliseFirstLetter(side.direction.toString());
            String sideUUID = tag.m_128425_(sideName + "FruitUUID", 8) ? tag.m_128461_(sideName + "FruitUUID") : "";
            sideData.fruitUUID = !sideUUID.isEmpty() ? UUID.fromString(sideUUID) : null;
            sideData.growing = tag.m_128471_("Is" + sideName + "Growing");
            sideData.growTimer = tag.m_128451_(sideName + "GrowTime");
        });
        this.pedalAnimation.read(tag);
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (compound.m_128441_("MaxFruitHeight")) {
            compound.m_128405_("MaxFruitHeight", this.maxFruitHeight);
        }
        this.sideData.forEach((side, sideData) -> {
            String sideName = StringUtils.capitaliseFirstLetter(side.direction.toString());
            if (sideData.fruitUUID == null) {
                compound.m_128359_(sideName + "FruitUUID", "");
            } else {
                compound.m_128359_(sideName + "FruitUUID", sideData.fruitUUID.toString());
            }
            compound.m_128379_("Is" + sideName + "Growing", sideData.growing);
            compound.m_128405_(sideName + "GrowTime", sideData.growTimer);
        });
        this.pedalAnimation.write(compound);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public boolean m_6326_() {
        return true;
    }

    private boolean shouldShutBud() {
        boolean hasAFruit = false;
        for (Map.Entry<BudSide, SideData> data : this.sideData.entrySet()) {
            if (!data.getValue().hasFruit(this.f_58857_)) continue;
            hasAFruit = true;
        }
        return !hasAFruit;
    }

    public int calculateFruitMaxHeight() {
        int[] maxHeights = new int[4];
        for (BudSide sides : BudSide.values()) {
            int y = 1;
            while (y < 7 && this.f_58857_.m_46859_(sides.offsetPosition(this.f_58858_.m_6630_(y)))) {
                maxHeights[sides.id] = y++;
            }
        }
        return MathUtil.getLowestValueInIntArray((int[])maxHeights);
    }

    public static enum BudSide {
        NORTH(Direction.NORTH, 0),
        EAST(Direction.EAST, 1),
        SOUTH(Direction.SOUTH, 2),
        WEST(Direction.WEST, 3);

        private final Direction direction;
        public final int id;

        private BudSide(Direction direction, int id) {
            this.direction = direction;
            this.id = id;
        }

        public BlockPos offsetPosition(BlockPos pos) {
            return pos.m_121945_(this.direction);
        }

        public static BudSide random(RandomSource rand) {
            return BudSide.values()[rand.m_188503_(BudSide.values().length)];
        }
    }

    static class SideData {
        @Nullable
        private UUID fruitUUID;
        private int growTimer;
        private boolean growing;

        SideData() {
        }

        public BolloomFruit getFruit(Level world) {
            Entity entity;
            if (!world.m_5776_() && this.fruitUUID != null && (entity = ((ServerLevel)world).m_8791_(this.fruitUUID)) instanceof BolloomFruit) {
                return (BolloomFruit)entity;
            }
            return null;
        }

        public boolean hasFruit(Level world) {
            if (this.growing) {
                return true;
            }
            BolloomFruit fruit = this.getFruit(world);
            return fruit != null && fruit.m_6084_() && !fruit.isUntied();
        }
    }
}

