/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.teamabnormals.endergetic.common.entity.puffbug.PuffBug;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import com.teamabnormals.endergetic.core.registry.EEEntityTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class PuffBugHiveFeature
extends Feature<NoneFeatureConfiguration> {
    public PuffBugHiveFeature(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        BlockPos hivePos = pos.m_7495_();
        if (level.m_8055_(pos.m_7494_()).m_60734_() == EEBlocks.POISE_STEM.get() || level.m_8055_(pos.m_7494_()).m_60734_() == EEBlocks.GLOWING_POISE_STEM.get()) {
            if (level.m_8055_(pos).m_247087_() && level.m_8055_(pos).m_247087_()) {
                level.m_7731_(pos, ((Block)EEBlocks.HIVE_HANGER.get()).m_49966_(), 2);
                level.m_7731_(hivePos, ((Block)EEBlocks.PUFFBUG_HIVE.get()).m_49966_(), 2);
                PuffBugHiveFeature.spawnPuffBugs(level, hivePos, context.m_225041_());
                return true;
            }
        } else if (level.m_8055_(pos.m_7494_()).m_60734_() == EEBlocks.POISE_CLUSTER.get() && level.m_151558_() > 90 && level.m_8055_(pos).m_247087_() && level.m_8055_(pos).m_247087_()) {
            level.m_7731_(pos, ((Block)EEBlocks.HIVE_HANGER.get()).m_49966_(), 2);
            level.m_7731_(hivePos, ((Block)EEBlocks.PUFFBUG_HIVE.get()).m_49966_(), 2);
            PuffBugHiveFeature.spawnPuffBugs(level, hivePos, context.m_225041_());
            return true;
        }
        return false;
    }

    private static void spawnPuffBugs(WorldGenLevel level, BlockPos pos, RandomSource rand) {
        if (!level.m_6018_().m_46469_().m_46207_(GameRules.f_46134_)) {
            return;
        }
        int maxPuffBugs = rand.m_188503_(4) + 2;
        List<Direction> openSides = PuffBugHiveFeature.getOpenSides((LevelAccessor)level, pos);
        for (Direction openSide : openSides) {
            BlockPos offset = pos.m_121945_(openSide);
            PuffBug puffbug = (PuffBug)((EntityType)EEEntityTypes.PUFF_BUG.get()).m_20615_((Level)level.m_6018_());
            if (puffbug != null) {
                puffbug.m_7678_((float)offset.m_123341_() + 0.5f, (float)offset.m_123342_() + 0.5f, (float)offset.m_123343_() + 0.5f, 0.0f, 0.0f);
                puffbug.m_6518_((ServerLevelAccessor)level, level.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
                puffbug.setHivePos(pos);
                level.m_7967_((Entity)puffbug);
            }
            if (maxPuffBugs-- > 0) continue;
            break;
        }
    }

    private static List<Direction> getOpenSides(LevelAccessor level, BlockPos pos) {
        ArrayList openDirections = Lists.newArrayList();
        for (Direction directions : Direction.values()) {
            BlockPos offsetPos;
            if (directions == Direction.UP || !level.m_46859_(offsetPos = pos.m_121945_(directions)) || !level.m_46859_(offsetPos.m_7494_())) continue;
            openDirections.add(directions);
        }
        return openDirections;
    }
}

