/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.block;

import dev.xkmc.cuisinedelight.content.item.CuisineSkilletItem;
import dev.xkmc.cuisinedelight.content.logic.CookingData;
import dev.xkmc.cuisinedelight.init.registrate.CDItems;
import dev.xkmc.l2library.base.tile.BaseBlockEntity;
import dev.xkmc.l2serial.serialization.SerialClass;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;

@SerialClass
public class CuisineSkilletBlockEntity
extends BaseBlockEntity
implements HeatableBlockEntity {
    @SerialClass.SerialField(toClient=true)
    public ItemStack baseItem = CDItems.SKILLET.asStack();
    @Nonnull
    @SerialClass.SerialField(toClient=true)
    public CookingData cookingData = new CookingData();
    @SerialClass.SerialField(toClient=true)
    private int stirTimer = 0;

    public CuisineSkilletBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (this.stirTimer > 0) {
            --this.stirTimer;
        }
    }

    public boolean isCooking() {
        return this.cookingData.contents.size() > 0;
    }

    public NonNullList<ItemStack> getItems() {
        return NonNullList.m_122779_();
    }

    public void setSkilletItem(ItemStack stack) {
        this.baseItem = stack.m_41777_();
        CookingData data = CuisineSkilletItem.getData(stack);
        if (data != null) {
            this.cookingData = data;
        }
        CuisineSkilletItem.setData(this.baseItem, null);
        this.sync();
    }

    public ItemStack toItemStack() {
        ItemStack ans = this.baseItem.m_41777_();
        if (this.cookingData.contents.size() > 0) {
            CuisineSkilletItem.setData(ans, this.cookingData);
        }
        return ans;
    }

    public boolean canCook() {
        return this.baseItem.getEnchantmentLevel(Enchantments.f_44981_) > 0 || this.f_58857_ != null && this.isHeated(this.f_58857_, this.m_58899_());
    }

    public boolean slowCook() {
        return this.baseItem.getEnchantmentLevel(Enchantments.f_44981_) == 1 && this.f_58857_ != null && !this.isHeated(this.f_58857_, this.m_58899_());
    }

    public float getStirPercent(float pTick) {
        return Math.max(0.0f, (float)this.stirTimer - pTick) / 20.0f;
    }

    public void stir(long gameTime, int reduce) {
        this.cookingData.stir(gameTime, reduce);
        this.stirTimer = 20;
        this.sync();
    }
}

