/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.model;

import com.faboslav.friendsandfoes.common.client.render.entity.animation.KeyframeAnimation;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.animator.context.KeyframeAnimationContext;
import com.faboslav.friendsandfoes.common.client.render.entity.model.AnimatedEntityModel;
import com.faboslav.friendsandfoes.common.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.common.entity.animation.AnimatedEntity;
import com.faboslav.friendsandfoes.common.entity.pose.CopperGolemEntityPose;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.AnimationState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class CopperGolemEntityModel<T extends CopperGolemEntity>
extends AnimatedEntityModel<T> {
    private static final String MODEL_PART_BODY = "body";
    private static final String MODEL_PART_LEFT_ARM = "leftArm";
    private static final String MODEL_PART_RIGHT_ARM = "rightArm";
    private static final String MODEL_PART_LEFT_LEG = "leftLeg";
    private static final String MODEL_PART_RIGHT_LEG = "rightLeg";
    private static final String MODEL_PART_HEAD = "head";
    private static final String MODEL_PART_NOSE = "nose";
    private static final String MODEL_PART_ROD = "rod";
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart nose;
    private final ModelPart rod;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public CopperGolemEntityModel(ModelPart root) {
        super(root);
        this.body = this.root.m_171324_(MODEL_PART_BODY);
        this.head = this.body.m_171324_(MODEL_PART_HEAD);
        this.nose = this.head.m_171324_(MODEL_PART_NOSE);
        this.rod = this.head.m_171324_(MODEL_PART_ROD);
        this.leftArm = this.body.m_171324_(MODEL_PART_LEFT_ARM);
        this.rightArm = this.body.m_171324_(MODEL_PART_RIGHT_ARM);
        this.leftLeg = this.root.m_171324_(MODEL_PART_LEFT_LEG);
        this.rightLeg = this.root.m_171324_(MODEL_PART_RIGHT_LEG);
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition root = modelData.m_171576_();
        root.m_171599_(MODEL_PART_BODY, CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(-4.0f, -5.0f, -2.0f, 8.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)0.0f));
        PartDefinition body = root.m_171597_(MODEL_PART_BODY);
        body.m_171599_(MODEL_PART_HEAD, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-4.0f, -5.0f, -4.0f, 8.0f, 5.0f, 8.0f, new CubeDeformation(0.001f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition head = body.m_171597_(MODEL_PART_HEAD);
        head.m_171599_(MODEL_PART_ROD, CubeListBuilder.m_171558_().m_171514_(56, 10).m_171488_(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(40, 9).m_171488_(-2.0f, -7.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        head.m_171599_(MODEL_PART_NOSE, CubeListBuilder.m_171558_().m_171514_(56, 15).m_171488_(-1.0f, -1.0f, -2.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-4.0f));
        body.m_171599_(MODEL_PART_LEFT_ARM, CubeListBuilder.m_171558_().m_171514_(10, 17).m_171488_(0.0f, -1.0f, -1.5f, 2.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)-5.0f, (float)0.0f));
        body.m_171599_(MODEL_PART_RIGHT_ARM, CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(-2.0f, -1.0f, -1.5f, 2.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)-5.0f, (float)0.0f));
        root.m_171599_(MODEL_PART_LEFT_LEG, CubeListBuilder.m_171558_().m_171514_(34, 17).m_171488_(-2.0f, 0.0f, -1.5f, 4.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)19.0f, (float)0.0f));
        root.m_171599_(MODEL_PART_RIGHT_LEG, CubeListBuilder.m_171558_().m_171514_(20, 17).m_171488_(-2.0f, 0.0f, -1.5f, 4.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)19.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void setAngles(T copperGolem, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        if (((CopperGolemEntity)copperGolem).isOxidized()) {
            animationProgress = ((CopperGolemEntity)copperGolem).f_19797_;
        }
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.setHeadAngle(headYaw);
        if (((CopperGolemEntity)copperGolem).isOxidized()) {
            this.updateStatueKeyframeAnimation((CopperGolemEntity)copperGolem);
        }
        this.updateMovementKeyframeAnimations((AnimatedEntity)copperGolem, limbAngle, limbDistance, 2.5f * ((CopperGolemEntity)copperGolem).getAnimationSpeedModifier(), 3.5f * ((CopperGolemEntity)copperGolem).getAnimationSpeedModifier());
        this.updateKeyframeAnimations((AnimatedEntity)copperGolem, animationProgress);
    }

    private void setHeadAngle(float yaw) {
        this.head.f_104204_ = yaw * ((float)Math.PI / 180);
    }

    private void updateStatueKeyframeAnimation(CopperGolemEntity copperGolem) {
        if (copperGolem.isInPose(CopperGolemEntityPose.IDLE)) {
            return;
        }
        KeyframeAnimation keyframeAnimation = copperGolem.getKeyframeAnimationByPose();
        if (keyframeAnimation == null) {
            return;
        }
        int initialTick = copperGolem.f_19797_ - copperGolem.getCurrentKeyframeAnimationTick();
        int currentTick = copperGolem.f_19797_;
        AnimationContextTracker animationContextTracker = copperGolem.getAnimationContextTracker();
        KeyframeAnimationContext keyframeAnimationContext = animationContextTracker.get(keyframeAnimation);
        keyframeAnimationContext.setInitialTick(initialTick);
        keyframeAnimationContext.setCurrentTick(currentTick);
        AnimationState animationState = new AnimationState();
        keyframeAnimationContext.setAnimationState(animationState);
        animationState.m_216977_(initialTick);
    }
}

