/*
 * Decompiled with CFR 0.152.
 */
package umpaz.farmersrespite.common.block.entity;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import umpaz.farmersrespite.common.block.KettleBlock;
import umpaz.farmersrespite.common.block.entity.container.KettleMenu;
import umpaz.farmersrespite.common.block.entity.inventory.KettleItemHandler;
import umpaz.farmersrespite.common.crafting.KettlePouringRecipe;
import umpaz.farmersrespite.common.crafting.KettleRecipe;
import umpaz.farmersrespite.common.registry.FRBlockEntityTypes;
import umpaz.farmersrespite.common.registry.FRItems;
import umpaz.farmersrespite.common.registry.FRRecipeTypes;
import umpaz.farmersrespite.common.registry.FRSounds;
import umpaz.farmersrespite.common.utility.FRTextUtils;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.mixin.accessor.RecipeManagerAccessor;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class KettleBlockEntity
extends SyncedBlockEntity
implements MenuProvider,
HeatableBlockEntity,
Nameable,
RecipeHolder {
    public static final int DRINK_DISPLAY_SLOT = 2;
    public static final int CONTAINER_SLOT = 3;
    public static final int OUTPUT_SLOT = 4;
    public static final int INVENTORY_SIZE = 5;
    public static boolean WHISTLE = false;
    private final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> new KettleItemHandler((IItemHandler)this.inventory, Direction.UP));
    private final LazyOptional<IItemHandler> outputHandler = LazyOptional.of(() -> new KettleItemHandler((IItemHandler)this.inventory, Direction.DOWN));
    private final FluidTank fluidTank;
    private final LazyOptional<FluidTank> fluidTankHandler;
    private int brewTime;
    private int brewTimeTotal;
    private ItemStack drinkContainerStack = ItemStack.f_41583_;
    private Component customName;
    protected final ContainerData kettleData = this.createIntArray();
    private final Object2IntOpenHashMap<ResourceLocation> usedRecipeTracker = new Object2IntOpenHashMap();
    private ResourceLocation lastRecipeID;
    private boolean checkNewRecipe = true;

    public KettleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FRBlockEntityTypes.KETTLE.get(), pos, state);
        this.fluidTank = this.createFluidTank();
        this.fluidTankHandler = LazyOptional.of(() -> this.fluidTank);
    }

    public static FluidStack getMealFromItem(ItemStack kettleStack) {
        if (!kettleStack.m_150930_((Item)FRItems.KETTLE.get())) {
            return FluidStack.EMPTY;
        }
        CompoundTag compound = kettleStack.m_41737_("BlockEntityTag");
        if (compound != null && compound.m_128441_("FluidTank")) {
            return FluidStack.loadFluidStackFromNBT((CompoundTag)compound.m_128469_("FluidTank"));
        }
        return FluidStack.EMPTY;
    }

    public static ItemStack getContainerFromItem(ItemStack kettleStack) {
        if (!kettleStack.m_150930_((Item)FRItems.KETTLE.get())) {
            return ItemStack.f_41583_;
        }
        CompoundTag compound = kettleStack.m_41737_("BlockEntityTag");
        if (compound != null) {
            return ItemStack.m_41712_((CompoundTag)compound.m_128469_("Container"));
        }
        return ItemStack.f_41583_;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.brewTime = compound.m_128451_("BrewTime");
        this.fluidTank.readFromNBT(compound.m_128469_("FluidTank"));
        this.brewTimeTotal = compound.m_128451_("BrewTimeTotal");
        this.drinkContainerStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Container"));
        if (compound.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"));
        }
        CompoundTag compoundRecipes = compound.m_128469_("RecipesUsed");
        for (String key : compoundRecipes.m_128431_()) {
            this.usedRecipeTracker.put((Object)new ResourceLocation(key), compoundRecipes.m_128451_(key));
        }
    }

    public ItemStack fluidExtract(KettleBlockEntity kettle, ItemStack slotIn, ItemStack slotOut) {
        Item container = slotIn.m_41720_();
        ItemStack output = ItemStack.f_41583_;
        Optional<KettlePouringRecipe> recipe = kettle.getPouringRecipe(container, kettle.fluidTank.getFluid());
        boolean changed = false;
        if (recipe.isPresent() && (kettle.fluidTank.isEmpty() || kettle.fluidTank.getFluid().getFluid().m_6212_(recipe.get().getFluid()))) {
            if (container.equals(recipe.get().getContainer().m_41720_()) && recipe.get().getAmount() <= kettle.fluidTank.getFluidAmount()) {
                while (kettle.fluidTank.getFluidAmount() >= recipe.get().getAmount() && (output.m_41619_() && slotOut.m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)slotOut, (ItemStack)recipe.get().getOutput().m_255036_(output.m_41613_() + 1))) && slotOut.m_41613_() + 1 <= slotOut.m_41741_() && slotIn.m_41613_() != 0 && !slotIn.m_41619_() && slotIn.m_41613_() >= recipe.get().getOutput().m_41613_()) {
                    kettle.fluidTank.drain(new FluidStack(kettle.fluidTank.getFluid(), recipe.get().getAmount()), IFluidHandler.FluidAction.EXECUTE);
                    slotIn.m_41774_(recipe.get().getContainer().m_41613_());
                    if (output.m_41619_()) {
                        output = recipe.get().getOutput().m_41777_();
                    } else {
                        output.m_41769_(recipe.get().getOutput().m_41613_());
                    }
                    changed = true;
                }
                if (changed) {
                    if (kettle.f_58857_.m_5776_()) {
                        kettle.f_58857_.m_245747_(kettle.m_58899_(), SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    }
                    this.m_6596_();
                }
            } else if (container.equals(recipe.get().getOutput().m_41720_()) && kettle.fluidTank.getFluidAmount() + recipe.get().getAmount() <= kettle.fluidTank.getCapacity()) {
                while (kettle.fluidTank.getFluidAmount() + recipe.get().getAmount() <= kettle.fluidTank.getCapacity() && slotIn.m_41613_() != 0 && !slotIn.m_41619_() && slotIn.m_41613_() >= recipe.get().getContainer().m_41613_() && (output.m_41619_() && slotOut.m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)slotOut, (ItemStack)recipe.get().getContainer().m_255036_(output.m_41613_() + 1))) && slotOut.m_41613_() + 1 <= slotOut.m_41741_()) {
                    kettle.fluidTank.fill(new FluidStack(recipe.get().getFluid(), recipe.get().getAmount()), IFluidHandler.FluidAction.EXECUTE);
                    slotIn.m_41774_(recipe.get().getOutput().m_41613_());
                    if (output.m_41619_()) {
                        output = recipe.get().getContainer().m_41777_();
                    } else {
                        output.m_41769_(recipe.get().getContainer().m_41613_());
                    }
                    changed = true;
                }
                if (changed) {
                    if (kettle.f_58857_.m_5776_()) {
                        kettle.f_58857_.m_245747_(kettle.m_58899_(), SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    }
                    this.m_6596_();
                }
            }
        }
        LazyOptional fluidHandler = slotIn.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
        IFluidHandlerItem iFluidItemHandler = (IFluidHandlerItem)fluidHandler.orElse(null);
        if (fluidHandler.isPresent() && !slotIn.m_41619_()) {
            if (kettle.fluidTank.getFluid().isFluidEqual(iFluidItemHandler.getFluidInTank(0)) || kettle.fluidTank.getFluid().isEmpty()) {
                int amountToDrain = kettle.fluidTank.getCapacity() - kettle.fluidTank.getFluidAmount();
                int amount = iFluidItemHandler.drain(amountToDrain, IFluidHandler.FluidAction.SIMULATE).getAmount();
                if (amount > 0) {
                    kettle.fluidTank.fill(iFluidItemHandler.drain(amountToDrain, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                    if (amount <= amountToDrain) {
                        slotIn.m_41764_(0);
                        if (output.m_41619_()) {
                            output = iFluidItemHandler.getContainer().m_41777_();
                        } else {
                            output.m_41769_(iFluidItemHandler.getContainer().m_41613_());
                        }
                        this.m_6596_();
                    }
                }
            } else if (!kettle.fluidTank.getFluid().isEmpty() && iFluidItemHandler.isFluidValid(0, kettle.fluidTank.getFluid())) {
                int amountToDrain = kettle.fluidTank.getFluidAmount();
                int amount = iFluidItemHandler.fill(new FluidStack(kettle.fluidTank.getFluid(), amountToDrain), IFluidHandler.FluidAction.SIMULATE);
                if (amount > 0) {
                    iFluidItemHandler.fill(new FluidStack(kettle.fluidTank.getFluid(), amountToDrain), IFluidHandler.FluidAction.EXECUTE);
                    kettle.fluidTank.drain(amountToDrain, IFluidHandler.FluidAction.EXECUTE);
                    if (amount <= amountToDrain) {
                        slotIn.m_41764_(0);
                        if (output.m_41619_()) {
                            output = iFluidItemHandler.getContainer().m_41777_();
                        } else {
                            output.m_41769_(iFluidItemHandler.getContainer().m_41613_());
                        }
                        this.m_6596_();
                    }
                }
            }
        }
        return output;
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("BrewTime", this.brewTime);
        compound.m_128405_("BrewTimeTotal", this.brewTimeTotal);
        compound.m_128365_("Container", (Tag)this.drinkContainerStack.serializeNBT());
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        compound.m_128365_("FluidTank", (Tag)this.fluidTank.writeToNBT(new CompoundTag()));
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        CompoundTag compoundRecipes = new CompoundTag();
        this.usedRecipeTracker.forEach((recipeId, craftedAmount) -> compoundRecipes.m_128405_(recipeId.toString(), craftedAmount.intValue()));
        compound.m_128365_("RecipesUsed", (Tag)compoundRecipes);
    }

    private CompoundTag writeItems(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Container", (Tag)this.drinkContainerStack.serializeNBT());
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128365_("FluidTank", (Tag)this.fluidTank.writeToNBT(new CompoundTag()));
        return compound;
    }

    public CompoundTag writeMeal(CompoundTag compound) {
        if (this.getOutput().isEmpty()) {
            return compound;
        }
        ItemStackHandler drops = new ItemStackHandler(5);
        for (int i = 0; i < 5; ++i) {
            drops.setStackInSlot(i, i == 2 ? this.inventory.getStackInSlot(i) : ItemStack.f_41583_);
        }
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        compound.m_128365_("Container", (Tag)this.drinkContainerStack.serializeNBT());
        compound.m_128365_("Inventory", (Tag)drops.serializeNBT());
        if (!this.fluidTank.isEmpty()) {
            compound.m_128365_("FluidTank", (Tag)this.fluidTank.writeToNBT(new CompoundTag()));
        }
        return compound;
    }

    public static void brewingTick(Level level, BlockPos pos, BlockState state, KettleBlockEntity kettle) {
        boolean isHeated = kettle.isHeated(level, pos);
        boolean didInventoryChange = false;
        if (isHeated && kettle.hasInput()) {
            Optional<KettleRecipe> recipe = kettle.getMatchingRecipe(new RecipeWrapper((IItemHandlerModifiable)kettle.inventory));
            if (recipe.isPresent() && kettle.canBrew(recipe.get(), kettle)) {
                didInventoryChange = kettle.processBrewing(recipe.get(), kettle);
            } else {
                kettle.brewTime = 0;
            }
        } else if (kettle.brewTime > 0) {
            kettle.brewTime = Mth.m_14045_((int)(kettle.brewTime - 2), (int)0, (int)kettle.brewTimeTotal);
        }
        ItemStack out = kettle.fluidExtract(kettle, kettle.inventory.getStackInSlot(3), kettle.inventory.getStackInSlot(4));
        if (!out.m_41619_()) {
            kettle.inventory.insertItem(4, out, false);
            didInventoryChange = true;
        }
        if (didInventoryChange) {
            kettle.inventoryChanged();
        }
    }

    public Optional<KettlePouringRecipe> getPouringRecipe(Item slot, FluidStack fluid) {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        Optional<KettlePouringRecipe> recipe = this.f_58857_.m_7465_().m_44013_((RecipeType)FRRecipeTypes.KETTLE_POURING.get()).stream().filter(r -> !(r.getContainer().m_41720_() != slot && r.getOutput().m_41720_() != slot || !fluid.isEmpty() && !r.getFluid().m_6212_(fluid.getFluid()))).findFirst();
        if (recipe.isPresent()) {
            this.lastRecipeID = recipe.get().m_6423_();
            return recipe;
        }
        return Optional.empty();
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, KettleBlockEntity kettle) {
        boolean i = (Boolean)state.m_61143_((Property)KettleBlock.LID);
        FluidStack mealStack = kettle.getOutput();
        if (kettle.isHeated(level, pos) && i && !mealStack.isEmpty()) {
            double d7;
            Direction direction = (Direction)state.m_61143_((Property)KettleBlock.FACING);
            Direction.Axis direction$axis = direction.m_122434_();
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = (double)pos.m_123342_() + 0.5;
            double d2 = (double)pos.m_123343_() + 0.5;
            double d4 = 0.0;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : d4;
            double d6 = 0.0;
            double d = d7 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : d4;
            if (level.f_46441_.m_188503_(5) == 0) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123806_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            }
            if (WHISTLE) {
                KettleBlockEntity.whistleNoise(level, pos, state, kettle);
                WHISTLE = false;
            }
        }
    }

    public static void whistleNoise(Level level, BlockPos pos, BlockState state, KettleBlockEntity kettle) {
        boolean i = (Boolean)state.m_61143_((Property)KettleBlock.LID);
        if (kettle.isHeated() && i) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.5;
            float pitch = RandomSource.m_216327_().m_188501_() * 0.2f + 0.9f;
            level.m_7785_(x, y, z, (SoundEvent)FRSounds.BLOCK_KETTLE_WHISTLE.get(), SoundSource.BLOCKS, 0.25f, pitch, false);
        }
    }

    private Optional<KettleRecipe> getMatchingRecipe(RecipeWrapper inventoryWrapper) {
        Object recipe;
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        if (this.lastRecipeID != null && (recipe = (Recipe)((RecipeManagerAccessor)this.f_58857_.m_7465_()).getRecipeMap((RecipeType)FRRecipeTypes.BREWING.get()).get(this.lastRecipeID)) instanceof KettleRecipe) {
            KettleRecipe kettleRecipe = (KettleRecipe)recipe;
            if (recipe.m_5818_((Container)inventoryWrapper, this.f_58857_) && kettleRecipe.getFluidIn().isFluidEqual(this.fluidTank.getFluid())) {
                return Optional.of((KettleRecipe)recipe);
            }
        }
        if (this.checkNewRecipe && ((Optional)(recipe = this.f_58857_.m_7465_().m_44013_((RecipeType)FRRecipeTypes.BREWING.get()).stream().filter(a -> a.matches(inventoryWrapper, this.f_58857_) && a.getFluidIn().getFluid().m_6212_(this.fluidTank.getFluid().getFluid())).findFirst())).isPresent()) {
            this.lastRecipeID = ((KettleRecipe)((Optional)recipe).get()).m_6423_();
            return recipe;
        }
        this.checkNewRecipe = false;
        return Optional.empty();
    }

    public ItemStack getContainer() {
        return this.drinkContainerStack;
    }

    private boolean hasInput() {
        for (int i = 0; i < 2; ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    protected boolean canBrew(KettleRecipe recipe, KettleBlockEntity kettle) {
        if (!this.hasInput()) {
            return false;
        }
        if (this.f_58857_ == null) {
            return false;
        }
        FluidStack resultStack = recipe.getFluidOut();
        if (resultStack.isEmpty()) {
            return false;
        }
        if (!kettle.fluidTank.getFluid().getFluid().m_6212_(recipe.getFluidIn().getFluid())) {
            return false;
        }
        if (kettle.fluidTank.getFluidAmount() % recipe.getFluidIn().getAmount() != 0) {
            return false;
        }
        return FluidStack.areFluidStackTagsEqual((FluidStack)this.fluidTank.getFluid(), (FluidStack)resultStack);
    }

    private boolean processBrewing(KettleRecipe recipe, KettleBlockEntity kettle) {
        if (this.f_58857_ == null) {
            return false;
        }
        ++this.brewTime;
        this.brewTimeTotal = recipe.getBrewTime();
        if (this.brewTime < this.brewTimeTotal) {
            return false;
        }
        this.brewTime = 0;
        if (recipe.getFluidOut() != null) {
            kettle.fluidTank.setFluid(new FluidStack(recipe.getFluidOut(), kettle.fluidTank.getFluidAmount()));
            if (kettle.f_58857_.m_5776_()) {
                kettle.f_58857_.m_245747_(kettle.m_58899_(), SoundEvents.f_11772_, SoundSource.BLOCKS, 1.0f, 0.8f, true);
            }
            WHISTLE = true;
        }
        kettle.m_6029_(recipe);
        for (int i = 0; i < 2; ++i) {
            ItemStack slotStack = this.inventory.getStackInSlot(i);
            if (slotStack.hasCraftingRemainingItem()) {
                Direction direction = ((Direction)this.m_58900_().m_61143_((Property)KettleBlock.FACING)).m_122428_();
                double x = (double)this.f_58858_.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.25;
                double y = (double)this.f_58858_.m_123342_() + 0.7;
                double z = (double)this.f_58858_.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.25;
                ItemUtils.spawnItemEntity((Level)this.f_58857_, (ItemStack)this.inventory.getStackInSlot(i).getCraftingRemainingItem(), (double)x, (double)y, (double)z, (double)((float)direction.m_122429_() * 0.08f), (double)0.25, (double)((float)direction.m_122431_() * 0.08f));
            }
            if (slotStack.m_41619_()) continue;
            slotStack.m_41774_(1);
        }
        return true;
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation recipeID = recipe.m_6423_();
            this.usedRecipeTracker.addTo((Object)recipeID, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_58395_(Player player, List<ItemStack> items) {
        List<Recipe<?>> usedRecipes = this.getUsedRecipesAndPopExperience(player.m_9236_(), player.m_20182_());
        player.m_7281_(usedRecipes);
        this.usedRecipeTracker.clear();
    }

    public List<Recipe<?>> getUsedRecipesAndPopExperience(Level level, Vec3 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.usedRecipeTracker.object2IntEntrySet()) {
            level.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                KettleBlockEntity.splitAndSpawnExperience((ServerLevel)level, pos, entry.getIntValue(), ((KettleRecipe)recipe).getExperience());
            });
        }
        return list;
    }

    private static void splitAndSpawnExperience(ServerLevel level, Vec3 pos, int craftedAmount, float experience) {
        int expTotal = Mth.m_14143_((float)((float)craftedAmount * experience));
        float expFraction = Mth.m_14187_((float)((float)craftedAmount * experience));
        if (expFraction != 0.0f && Math.random() < (double)expFraction) {
            ++expTotal;
        }
        ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)pos, (int)expTotal);
    }

    public boolean isHeated() {
        if (this.f_58857_ == null) {
            return false;
        }
        return this.isHeated(this.f_58857_, this.f_58858_);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public FluidStack getOutput() {
        return this.fluidTank.getFluid();
    }

    public NonNullList<ItemStack> getDroppableInventory() {
        NonNullList drops = NonNullList.m_122779_();
        for (int i = 0; i < 5; ++i) {
            if (i == 2) continue;
            drops.add((Object)this.inventory.getStackInSlot(i));
        }
        return drops;
    }

    private void moveMealToOutput() {
        ItemStack mealStack = this.inventory.getStackInSlot(2);
        ItemStack outputStack = this.inventory.getStackInSlot(4);
        int mealCount = Math.min(mealStack.m_41613_(), mealStack.m_41741_() - outputStack.m_41613_());
        if (outputStack.m_41619_()) {
            this.inventory.setStackInSlot(4, mealStack.m_41620_(mealCount));
        } else if (outputStack.m_41720_() == mealStack.m_41720_()) {
            mealStack.m_41774_(mealCount);
            outputStack.m_41769_(mealCount);
        }
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : FRTextUtils.getTranslation("container.kettle", new Object[0]);
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    public AbstractContainerMenu m_7208_(int id, Inventory player, Player entity) {
        return new KettleMenu(id, player, this, this.kettleData);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)ForgeCapabilities.ITEM_HANDLER)) {
            if (side == null || side.equals((Object)Direction.UP)) {
                return this.inputHandler.cast();
            }
            return this.outputHandler.cast();
        }
        if (cap.equals((Object)ForgeCapabilities.FLUID_HANDLER)) {
            return this.fluidTankHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.inputHandler.invalidate();
        this.outputHandler.invalidate();
        this.fluidTankHandler.invalidate();
    }

    public CompoundTag m_5995_() {
        return this.writeItems(new CompoundTag());
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(5){

            protected void onContentsChanged(int slot) {
                if (slot >= 0 && slot < 2) {
                    KettleBlockEntity.this.checkNewRecipe = true;
                }
                KettleBlockEntity.this.inventoryChanged();
            }
        };
    }

    private FluidTank createFluidTank() {
        return new FluidTank(1000){

            protected void onContentsChanged() {
                super.onContentsChanged();
                KettleBlockEntity.this.m_6596_();
                KettleBlockEntity.this.inventoryChanged();
            }
        };
    }

    private ContainerData createIntArray() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> KettleBlockEntity.this.brewTime;
                    case 1 -> KettleBlockEntity.this.brewTimeTotal;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        KettleBlockEntity.this.brewTime = value;
                        break;
                    }
                    case 1: {
                        KettleBlockEntity.this.brewTimeTotal = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }
}

