/*
 * Decompiled with CFR 0.152.
 */
package umpaz.farmersrespite.data.worldgen.features;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import umpaz.farmersrespite.common.block.CoffeeBushBlock;
import umpaz.farmersrespite.common.block.CoffeeBushTopBlock;
import umpaz.farmersrespite.common.block.CoffeeStemBlock;
import umpaz.farmersrespite.common.registry.FRBlocks;

public class CoffeeBushFeature
extends Feature<NoneFeatureConfiguration> {
    public static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    public CoffeeBushFeature(Codec<NoneFeatureConfiguration> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        RandomSource rand = level.m_213780_();
        BlockState coffeeBushBottom = ((Block)FRBlocks.COFFEE_BUSH.get()).m_49966_();
        BlockState coffeeBushTop = (BlockState)((Block)FRBlocks.COFFEE_BUSH.get()).m_49966_().m_61124_(CoffeeBushBlock.HALF, (Comparable)DoubleBlockHalf.UPPER);
        BlockState coffeeStem = ((Block)FRBlocks.COFFEE_STEM.get()).m_49966_();
        BlockState coffeeBushTopBottom = ((Block)FRBlocks.COFFEE_BUSH_TOP.get()).m_49966_();
        BlockState coffeeBushTopTop = (BlockState)((Block)FRBlocks.COFFEE_BUSH_TOP.get()).m_49966_().m_61124_(CoffeeBushTopBlock.HALF, (Comparable)DoubleBlockHalf.UPPER);
        HashMap<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
        int i = 0;
        if (rand.m_188503_(4) > 2) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    if (Math.abs(x) >= 2 && Math.abs(z) >= 2) continue;
                    for (int y = -3; y <= 3; ++y) {
                        BlockPos blockpos = pos.m_7918_(x, y, z);
                        BlockPos below = blockpos.m_7495_();
                        BlockState belowState = level.m_8055_(below);
                        if (!CoffeeBushFeature.canGrowCoffee(belowState)) continue;
                        BlockPos above = blockpos.m_7494_();
                        BlockPos evenMoreAbove = blockpos.m_6630_(2);
                        if (!level.m_46859_(blockpos) || level.m_151570_(above) || !level.m_46859_(above)) continue;
                        if (rand.m_188503_(5) < 3) {
                            blocks.put(blockpos, coffeeBushBottom);
                            blocks.put(above, coffeeBushTop);
                        } else if (level.m_46859_(evenMoreAbove)) {
                            blocks.put(blockpos, (BlockState)((BlockState)coffeeStem.m_61124_((Property)CoffeeStemBlock.FACING, (Comparable)DIRECTIONS[rand.m_188503_(4)])).m_61124_((Property)CoffeeStemBlock.AGE, (Comparable)Integer.valueOf(rand.m_188503_(3))));
                            blocks.put(above, coffeeBushTopBottom);
                            blocks.put(evenMoreAbove, coffeeBushTopTop);
                        }
                        ++i;
                    }
                }
            }
        }
        for (Map.Entry entry : blocks.entrySet()) {
            BlockPos entryPos = (BlockPos)entry.getKey();
            BlockState entryState = (BlockState)entry.getValue();
            level.m_7731_(entryPos, entryState, 19);
        }
        return i > 0;
    }

    public static boolean canGrowCoffee(BlockState state) {
        return state.m_60713_(Blocks.f_50137_) || state.m_60713_(Blocks.f_50138_) || state.m_60713_(Blocks.f_152597_) || state.m_60713_(Blocks.f_50450_);
    }
}

