/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.render;

import com.goby56.wakes.config.WakesConfig;
import com.goby56.wakes.config.enums.Resolution;
import com.goby56.wakes.duck.ProducesWake;
import com.goby56.wakes.particle.custom.SplashPlaneParticle;
import com.goby56.wakes.render.WakeTexture;
import com.goby56.wakes.render.enums.RenderType;
import com.goby56.wakes.simulation.WakeHandler;
import com.goby56.wakes.utils.WakesUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.jdiemke.triangulation.DelaunayTriangulator;
import io.github.jdiemke.triangulation.NotEnoughPointsException;
import io.github.jdiemke.triangulation.Triangle2D;
import io.github.jdiemke.triangulation.Vector2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_7833;
import org.joml.Matrix4f;

public class SplashPlaneRenderer
implements WorldRenderEvents.AfterTranslucent {
    private static ArrayList<Vector2D> points;
    private static List<Triangle2D> triangles;
    private static ArrayList<class_243> vertices;
    private static ArrayList<class_243> normals;
    public static Map<Resolution, WakeTexture> wakeTextures;
    private static final double SQRT_8;

    private static void initTextures() {
        wakeTextures = Map.of(Resolution.EIGHT, new WakeTexture(Resolution.EIGHT.res, false), Resolution.SIXTEEN, new WakeTexture(Resolution.SIXTEEN.res, false), Resolution.THIRTYTWO, new WakeTexture(Resolution.THIRTYTWO.res, false));
    }

    public void afterTranslucent(WorldRenderContext context) {
        if (WakeHandler.getInstance().isEmpty()) {
            return;
        }
        WakeHandler wakeHandler = WakeHandler.getInstance().get();
        for (SplashPlaneParticle particle : wakeHandler.getVisible(context.frustum(), SplashPlaneParticle.class)) {
            if (!particle.isRenderReady) continue;
            SplashPlaneRenderer.render(particle.owner, particle, context, context.matrixStack());
        }
    }

    public static <T extends class_1297> void render(T entity, SplashPlaneParticle splashPlane, WorldRenderContext context, class_4587 matrices) {
        if (wakeTextures == null) {
            SplashPlaneRenderer.initTextures();
        }
        if (WakesConfig.disableMod || !WakesUtils.getEffectRuleFromSource(entity).renderPlanes) {
            return;
        }
        RenderSystem.setShader(RenderType.getProgram());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        matrices.method_22903();
        splashPlane.translateMatrix(context, matrices);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(splashPlane.lerpedYaw + 180.0f));
        float velocity = (float)Math.floor(((ProducesWake)entity).wakes$getHorizontalVelocity() * 20.0) / 20.0f;
        float progress = Math.min(1.0f, velocity / WakesConfig.maxSplashPlaneVelocity);
        float scalar = (float)((double)WakesConfig.splashPlaneScale * Math.sqrt(entity.method_17681() * Math.max(1.0f, progress) + 1.0f) / 3.0);
        matrices.method_22905(scalar, scalar, scalar);
        Matrix4f matrix = matrices.method_23760().method_23761();
        wakeTextures.get((Object)WakeHandler.resolution).loadTexture(splashPlane.imgPtr);
        SplashPlaneRenderer.renderSurface(matrix);
        matrices.method_22909();
    }

    private static void renderSurface(Matrix4f matrix) {
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27379, class_290.field_1580);
        int light = 0xF000F0;
        for (int s = -1; s < 2; ++s) {
            if (s == 0) continue;
            for (int i = 0; i < vertices.size(); ++i) {
                class_243 vertex = vertices.get(i);
                class_243 normal = normals.get(i);
                builder.method_22918(matrix, (float)((double)s * (vertex.field_1352 * (double)WakesConfig.splashPlaneWidth + (double)WakesConfig.splashPlaneGap)), (float)(vertex.field_1350 * (double)WakesConfig.splashPlaneHeight), (float)(vertex.field_1351 * (double)WakesConfig.splashPlaneDepth)).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913((float)vertex.field_1352, (float)vertex.field_1351).method_22922(class_4608.field_21444).method_22916(light).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350).method_1344();
            }
        }
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        class_289.method_1348().method_1350();
        RenderSystem.enableCull();
    }

    private static double upperBound(double x) {
        return -2.0 * x * x + SQRT_8 * x;
    }

    private static double lowerBound(double x) {
        return (SQRT_8 - 2.0) * x * x;
    }

    private static double height(double x, double y) {
        return 4.0 * (x * (SQRT_8 - x) - y - x * x) / SQRT_8;
    }

    private static class_243 normal(double x, double y) {
        double nx = SQRT_8 / (4.0 * (4.0 * x + y - SQRT_8));
        double ny = SQRT_8 / (4.0 * (2.0 * x * x - SQRT_8 + 1.0));
        return class_243.method_1030((float)((float)Math.tan(nx)), (float)((float)Math.tan(ny)));
    }

    private static void distributePoints() {
        int res = WakesConfig.splashPlaneResolution;
        points = new ArrayList();
        for (float i = 0.0f; i < (float)res; i += 1.0f) {
            double x = i / (float)(res - 1);
            double h = SplashPlaneRenderer.upperBound(x) - SplashPlaneRenderer.lowerBound(x);
            int n_points = (int)Math.max(1.0, Math.floor(h * (double)res));
            for (float j = 0.0f; j < (float)(n_points + 1); j += 1.0f) {
                float y = (float)((double)(j / (float)n_points) * h + SplashPlaneRenderer.lowerBound(x));
                points.add(new Vector2D(x, (double)y));
            }
        }
    }

    private static void generateMesh() {
        vertices = new ArrayList();
        normals = new ArrayList();
        try {
            DelaunayTriangulator delaunay = new DelaunayTriangulator(points);
            delaunay.triangulate();
            triangles = delaunay.getTriangles();
        }
        catch (NotEnoughPointsException e) {
            e.printStackTrace();
        }
        for (Triangle2D tri : triangles) {
            for (Vector2D vec : new Vector2D[]{tri.a, tri.b, tri.c}) {
                double x = vec.x;
                double y = vec.y;
                vertices.add(new class_243(x, y, SplashPlaneRenderer.height(x, y)));
                normals.add(SplashPlaneRenderer.normal(x, y));
            }
        }
    }

    public static void initSplashPlane() {
        SplashPlaneRenderer.distributePoints();
        SplashPlaneRenderer.generateMesh();
    }

    static {
        wakeTextures = null;
        SQRT_8 = Math.sqrt(8.0);
    }
}

