/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.render;

import com.goby56.wakes.config.WakesConfig;
import com.goby56.wakes.config.enums.Resolution;
import com.goby56.wakes.debug.WakesDebugInfo;
import com.goby56.wakes.render.WakeTexture;
import com.goby56.wakes.simulation.Brick;
import com.goby56.wakes.simulation.WakeHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Map;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4184;
import net.minecraft.class_4608;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class WakeRenderer
implements WorldRenderEvents.AfterTranslucent {
    public static Map<Resolution, WakeTexture> wakeTextures = null;

    private void initTextures() {
        wakeTextures = Map.of(Resolution.EIGHT, new WakeTexture(Resolution.EIGHT.res, true), Resolution.SIXTEEN, new WakeTexture(Resolution.SIXTEEN.res, true), Resolution.THIRTYTWO, new WakeTexture(Resolution.THIRTYTWO.res, true));
    }

    public void afterTranslucent(WorldRenderContext context) {
        WakeHandler wakeHandler;
        if (WakesConfig.disableMod) {
            WakesDebugInfo.quadsRendered = 0;
            return;
        }
        if (wakeTextures == null) {
            this.initTextures();
        }
        if ((wakeHandler = (WakeHandler)WakeHandler.getInstance().orElse(null)) == null || WakeHandler.resolutionResetScheduled) {
            return;
        }
        ArrayList<Brick> bricks = wakeHandler.getVisible(context.frustum(), Brick.class);
        Matrix4f matrix = context.matrixStack().method_23760().method_23761();
        RenderSystem.enableBlend();
        context.lightmapTextureManager().method_3316();
        Resolution resolution = WakeHandler.resolution;
        int n = 0;
        long tRendering = System.nanoTime();
        for (Brick brick : bricks) {
            this.render(matrix, context.camera(), brick, wakeTextures.get((Object)resolution));
            ++n;
        }
        WakesDebugInfo.renderingTime.add(System.nanoTime() - tRendering);
        WakesDebugInfo.quadsRendered = n;
    }

    private void render(Matrix4f matrix, class_4184 camera, Brick brick, WakeTexture texture) {
        if (!brick.hasPopulatedPixels) {
            return;
        }
        texture.loadTexture(brick.imgPtr);
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1580);
        Vector3f pos = brick.pos.method_1019(camera.method_19326().method_22882()).method_46409().add(0.0f, 0.8888889f, 0.0f);
        int light = 0xF000F0;
        builder.method_22918(matrix, pos.x, pos.y, pos.z).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        builder.method_22918(matrix, pos.x, pos.y, pos.z + (float)brick.dim).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        builder.method_22918(matrix, pos.x + (float)brick.dim, pos.y, pos.z + (float)brick.dim).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        builder.method_22918(matrix, pos.x + (float)brick.dim, pos.y, pos.z).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        RenderSystem.enableBlend();
        class_289.method_1348().method_1350();
    }
}

