/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.simulation;

import com.goby56.wakes.config.WakesConfig;
import com.goby56.wakes.debug.WakesDebugInfo;
import com.goby56.wakes.simulation.WakeHandler;
import com.goby56.wakes.simulation.WakeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.class_765;
import org.lwjgl.system.MemoryUtil;

public class Brick {
    private final WakeNode[][] nodes;
    public final int capacity;
    public final int dim;
    public int occupied = 0;
    public final class_243 pos;
    public Brick NORTH;
    public Brick EAST;
    public Brick SOUTH;
    public Brick WEST;
    public long imgPtr = -1L;
    public int texRes;
    public boolean hasPopulatedPixels = false;

    public Brick(int x, float y, int z, int width) {
        this.dim = width;
        this.capacity = this.dim * this.dim;
        this.nodes = new WakeNode[this.dim][this.dim];
        this.pos = new class_243((double)x, (double)y, (double)z);
        this.initTexture(WakeHandler.resolution.res);
    }

    public void initTexture(int res) {
        long size = 4L * (long)this.dim * (long)this.dim * (long)res * (long)res;
        this.imgPtr = this.imgPtr == -1L ? MemoryUtil.nmemAlloc((long)size) : MemoryUtil.nmemRealloc((long)this.imgPtr, (long)size);
        this.texRes = res;
        this.hasPopulatedPixels = false;
    }

    public void deallocTexture() {
        MemoryUtil.nmemFree((long)this.imgPtr);
    }

    public boolean tick(WakeHandler wakeHandler) {
        long tNode = System.nanoTime();
        for (int z = 0; z < this.dim; ++z) {
            for (int x = 0; x < this.dim; ++x) {
                if (this.get(x, z) == null || this.get(x, z).tick(wakeHandler)) continue;
                this.clear(x, z);
            }
        }
        WakesDebugInfo.nodeLogicTime += (double)(System.nanoTime() - tNode);
        long tTexturing = System.nanoTime();
        this.populatePixels();
        WakesDebugInfo.texturingTime += (double)(System.nanoTime() - tTexturing);
        WakesDebugInfo.nodeCount += this.occupied;
        return this.occupied != 0;
    }

    public void query(class_4604 frustum, ArrayList<WakeNode> output) {
        for (int z = 0; z < this.dim; ++z) {
            for (int x = 0; x < this.dim; ++x) {
                class_238 b;
                WakeNode node = this.get(x, z);
                if (node == null || !frustum.method_23093(b = node.toBox())) continue;
                output.add(node);
            }
        }
    }

    public WakeNode get(int x, int z) {
        if (x >= 0 && x < this.dim) {
            if (z < 0 && this.NORTH != null) {
                return this.NORTH.nodes[Math.floorMod(z, this.dim)][x];
            }
            if (z >= this.dim && this.SOUTH != null) {
                return this.SOUTH.nodes[Math.floorMod(z, this.dim)][x];
            }
            if (z >= 0 && z < this.dim) {
                return this.nodes[z][x];
            }
        }
        if (z >= 0 && z < this.dim) {
            if (x < 0 && this.WEST != null) {
                return this.WEST.nodes[z][Math.floorMod(x, this.dim)];
            }
            if (x >= this.dim && this.EAST != null) {
                return this.EAST.nodes[z][Math.floorMod(x, this.dim)];
            }
        }
        return null;
    }

    public void insert(WakeNode node) {
        int x = Math.floorMod(node.x, this.dim);
        int z = Math.floorMod(node.z, this.dim);
        if (this.nodes[z][x] != null) {
            this.nodes[z][x].revive(node);
            return;
        }
        this.set(x, z, node);
        for (WakeNode neighbor : this.getAdjacentNodes(x, z)) {
            neighbor.updateAdjacency(node);
        }
    }

    protected void set(int x, int z, WakeNode node) {
        boolean wasNull = this.nodes[z][x] == null;
        this.nodes[z][x] = node;
        if (node == null) {
            if (!wasNull) {
                --this.occupied;
            }
        } else if (wasNull) {
            ++this.occupied;
        }
    }

    public void clear(int x, int z) {
        this.set(x, z, null);
    }

    private List<WakeNode> getAdjacentNodes(int x, int z) {
        return Stream.of(this.get(x, z + 1), this.get(x + 1, z), this.get(x, z - 1), this.get(x - 1, z)).filter(Objects::nonNull).toList();
    }

    public void updateAdjacency(Brick brick) {
        if (brick.pos.field_1352 == this.pos.field_1352 && brick.pos.field_1350 == this.pos.field_1350 - (double)this.dim) {
            this.NORTH = brick;
            brick.SOUTH = this;
            return;
        }
        if (brick.pos.field_1352 == this.pos.field_1352 + (double)this.dim && brick.pos.field_1350 == this.pos.field_1350) {
            this.EAST = brick;
            brick.WEST = this;
            return;
        }
        if (brick.pos.field_1352 == this.pos.field_1352 && brick.pos.field_1350 == this.pos.field_1350 + (double)this.dim) {
            this.SOUTH = brick;
            brick.NORTH = this;
            return;
        }
        if (brick.pos.field_1352 == this.pos.field_1352 - (double)this.dim && brick.pos.field_1350 == this.pos.field_1350) {
            this.WEST = brick;
            brick.EAST = this;
        }
    }

    public void populatePixels() {
        class_638 world = class_310.method_1551().field_1687;
        for (int z = 0; z < this.dim; ++z) {
            for (int x = 0; x < this.dim; ++x) {
                WakeNode node = this.get(x, z);
                int lightCol = 0xF000F0;
                int fluidColor = 0;
                float opacity = 0.0f;
                if (node != null) {
                    fluidColor = class_1163.method_4961((class_1920)world, (class_2338)node.blockPos());
                    int lightCoordinate = class_761.method_23794((class_1920)world, (class_2338)node.blockPos());
                    lightCol = class_310.method_1551().field_1773.method_22974().field_4133.method_4315(class_765.method_24186((int)lightCoordinate), class_765.method_24187((int)lightCoordinate));
                    opacity = (float)((-Math.pow(node.t, 2.0) + 1.0) * (double)WakesConfig.wakeOpacity);
                }
                long nodeOffset = (long)this.texRes * 4L * ((long)z * (long)this.dim * (long)this.texRes + (long)x);
                for (int r = 0; r < this.texRes; ++r) {
                    for (int c = 0; c < this.texRes; ++c) {
                        int color = 0;
                        if (node != null) {
                            color = node.simulationNode.getPixelColor(c, r, fluidColor, lightCol, opacity);
                        }
                        long pixelOffset = 4L * ((long)r * (long)this.dim * (long)this.texRes + (long)c);
                        MemoryUtil.memPutInt((long)(this.imgPtr + nodeOffset + pixelOffset), (int)color);
                    }
                }
            }
        }
        this.hasPopulatedPixels = true;
    }
}

