/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.simulation;

import com.goby56.wakes.config.WakesConfig;
import com.goby56.wakes.config.enums.Resolution;
import com.goby56.wakes.particle.custom.SplashPlaneParticle;
import com.goby56.wakes.simulation.QuadTree;
import com.goby56.wakes.simulation.QueueSet;
import com.goby56.wakes.simulation.WakeNode;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_4604;

public class WakeHandler {
    private static WakeHandler INSTANCE;
    public class_1937 world;
    private QuadTree[] trees;
    private QueueSet<WakeNode>[] toBeInserted;
    private final int minY;
    private final int maxY;
    private ArrayList<SplashPlaneParticle> splashPlanes;
    public static Resolution resolution;
    public static boolean resolutionResetScheduled;

    private WakeHandler(class_1937 world) {
        this.world = world;
        this.minY = world.method_31607();
        this.maxY = world.method_31600();
        int worldHeight = this.maxY - this.minY;
        this.trees = new QuadTree[worldHeight];
        this.toBeInserted = new QueueSet[worldHeight];
        for (int i = 0; i < worldHeight; ++i) {
            this.toBeInserted[i] = new QueueSet();
        }
        this.splashPlanes = new ArrayList();
    }

    public static Optional<WakeHandler> getInstance() {
        if (INSTANCE == null) {
            if (class_310.method_1551().field_1687 == null) {
                return Optional.empty();
            }
            INSTANCE = new WakeHandler((class_1937)class_310.method_1551().field_1687);
        }
        return Optional.of(INSTANCE);
    }

    public static void init(class_1937 world) {
        INSTANCE = new WakeHandler(world);
    }

    public static void kill() {
        INSTANCE = null;
    }

    public void tick() {
        int i;
        if (WakesConfig.wakeResolution.res != WakeHandler.resolution.res) {
            WakeHandler.scheduleResolutionChange(WakesConfig.wakeResolution);
        }
        for (i = 0; i < this.maxY - this.minY; ++i) {
            QueueSet<WakeNode> pendingNodes = this.toBeInserted[i];
            if (resolutionResetScheduled) {
                if (pendingNodes == null) continue;
                pendingNodes.clear();
                continue;
            }
            QuadTree tree = this.trees[i];
            if (tree == null) continue;
            tree.tick(this);
            while (pendingNodes.peek() != null) {
                tree.insert((WakeNode)pendingNodes.poll());
            }
        }
        for (i = this.splashPlanes.size() - 1; i >= 0; --i) {
            if (this.splashPlanes.get(i).method_3086()) continue;
            this.splashPlanes.remove(i);
        }
        if (resolutionResetScheduled) {
            this.changeResolution();
        }
    }

    public void recolorWakes() {
        for (int i = 0; i < this.maxY - this.minY; ++i) {
            QuadTree tree = this.trees[i];
            if (tree == null) continue;
            tree.recolorWakes();
        }
        for (SplashPlaneParticle splashPlane : this.splashPlanes) {
            if (splashPlane == null) continue;
            splashPlane.populatePixels();
        }
    }

    public void registerSplashPlane(SplashPlaneParticle splashPlane) {
        this.splashPlanes.add(splashPlane);
    }

    public void insert(WakeNode node) {
        if (resolutionResetScheduled) {
            return;
        }
        int i = this.getArrayIndex(node.y);
        if (i < 0) {
            return;
        }
        if (this.trees[i] == null) {
            this.trees[i] = new QuadTree(node.y);
        }
        if (node.validPos(this.world)) {
            this.toBeInserted[i].add(node);
        }
    }

    public <T> ArrayList<T> getVisible(class_4604 frustum, Class<T> type) {
        ArrayList<T> visibleObjects = new ArrayList<T>();
        if (type.equals(SplashPlaneParticle.class)) {
            for (SplashPlaneParticle particle : this.splashPlanes) {
                if (!frustum.method_23093(particle.method_3064())) continue;
                visibleObjects.add(type.cast((Object)particle));
            }
        } else {
            for (int i = 0; i < this.maxY - this.minY; ++i) {
                if (this.trees[i] == null) continue;
                this.trees[i].query(frustum, visibleObjects, type);
            }
        }
        return visibleObjects;
    }

    private int getArrayIndex(int y) {
        if (y < this.minY || y >= this.maxY) {
            return -1;
        }
        return y - this.minY;
    }

    public static void scheduleResolutionChange(Resolution newRes) {
        resolutionResetScheduled = true;
    }

    private void changeResolution() {
        this.reset();
        resolution = WakesConfig.wakeResolution;
        resolutionResetScheduled = false;
    }

    private void reset() {
        for (int i = 0; i < this.maxY - this.minY; ++i) {
            QuadTree tree = this.trees[i];
            if (tree != null) {
                tree.prune();
            }
            this.toBeInserted[i].clear();
        }
    }

    static {
        resolution = WakesConfig.wakeResolution;
        resolutionResetScheduled = false;
    }
}

