/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.crafter;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.crafter.ConnectedInputHandler;
import com.simibubi.create.content.kinetics.crafter.CrafterHelper;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.Pointing;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class MechanicalCrafterBlock
extends HorizontalKineticBlock
implements IBE<MechanicalCrafterBlockEntity>,
ICogWheel {
    public static final EnumProperty<Pointing> POINTING = EnumProperty.m_61587_((String)"pointing", Pointing.class);

    public MechanicalCrafterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(POINTING, (Comparable)Pointing.UP));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{POINTING}));
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122434_();
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction face = context.m_43719_();
        BlockPos placedOnPos = context.m_8083_().m_121945_(face.m_122424_());
        BlockState blockState = context.m_43725_().m_8055_(placedOnPos);
        if (blockState.m_60734_() != this || context.m_43723_() != null && context.m_43723_().m_6144_()) {
            BlockState stateForPlacement = super.m_5573_(context);
            Direction direction = (Direction)stateForPlacement.m_61143_(HORIZONTAL_FACING);
            if (direction != face) {
                stateForPlacement = (BlockState)stateForPlacement.m_61124_(POINTING, (Comparable)MechanicalCrafterBlock.pointingFromFacing(face, direction));
            }
            return stateForPlacement;
        }
        Direction otherFacing = (Direction)blockState.m_61143_(HORIZONTAL_FACING);
        Pointing pointing = MechanicalCrafterBlock.pointingFromFacing(face, otherFacing);
        return (BlockState)((BlockState)this.m_49966_().m_61124_(HORIZONTAL_FACING, (Comparable)otherFacing)).m_61124_(POINTING, (Comparable)pointing);
    }

    @Override
    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        MechanicalCrafterBlockEntity crafter;
        if (state.m_60734_() == newState.m_60734_() && MechanicalCrafterBlock.getTargetDirection(state) != MechanicalCrafterBlock.getTargetDirection(newState) && (crafter = CrafterHelper.getCrafter((BlockAndTintGetter)worldIn, pos)) != null) {
            crafter.blockChanged();
        }
        if (state.m_155947_() && !state.m_60713_(newState.m_60734_())) {
            crafter = CrafterHelper.getCrafter((BlockAndTintGetter)worldIn, pos);
            if (crafter != null) {
                if (crafter.covered) {
                    Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)AllItems.CRAFTER_SLOT_COVER.asStack());
                }
                if (!isMoving) {
                    crafter.ejectWholeGrid();
                }
            }
            for (Direction direction : Iterate.directions) {
                if (direction.m_122434_() == ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122434_()) continue;
                BlockPos otherPos = pos.m_121945_(direction);
                ConnectedInputHandler.ConnectedInput thisInput = CrafterHelper.getInput((BlockAndTintGetter)worldIn, pos);
                ConnectedInputHandler.ConnectedInput otherInput = CrafterHelper.getInput((BlockAndTintGetter)worldIn, otherPos);
                if (thisInput == null || otherInput == null || !pos.m_121955_((Vec3i)thisInput.data.get(0)).equals((Object)otherPos.m_121955_((Vec3i)otherInput.data.get(0)))) continue;
                ConnectedInputHandler.toggleConnection(worldIn, pos, otherPos);
            }
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public static Pointing pointingFromFacing(Direction pointingFace, Direction blockFacing) {
        Pointing pointing;
        boolean positive = blockFacing.m_122421_() == Direction.AxisDirection.POSITIVE;
        Pointing pointing2 = pointing = pointingFace == Direction.DOWN ? Pointing.UP : Pointing.DOWN;
        if (pointingFace == Direction.EAST) {
            Pointing pointing3 = pointing = positive ? Pointing.LEFT : Pointing.RIGHT;
        }
        if (pointingFace == Direction.WEST) {
            Pointing pointing4 = pointing = positive ? Pointing.RIGHT : Pointing.LEFT;
        }
        if (pointingFace == Direction.NORTH) {
            Pointing pointing5 = pointing = positive ? Pointing.LEFT : Pointing.RIGHT;
        }
        if (pointingFace == Direction.SOUTH) {
            pointing = positive ? Pointing.RIGHT : Pointing.LEFT;
        }
        return pointing;
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (context.m_43719_() == state.m_61143_(HORIZONTAL_FACING)) {
            if (!context.m_43725_().f_46443_) {
                KineticBlockEntity.switchToBlockState(context.m_43725_(), context.m_8083_(), (BlockState)state.m_61122_(POINTING));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (!(blockEntity instanceof MechanicalCrafterBlockEntity)) {
            return InteractionResult.PASS;
        }
        MechanicalCrafterBlockEntity crafter = (MechanicalCrafterBlockEntity)blockEntity;
        ItemStack heldItem = player.m_21120_(handIn);
        if (AllBlocks.MECHANICAL_ARM.isIn(heldItem)) {
            return InteractionResult.PASS;
        }
        boolean isHand = heldItem.m_41619_() && handIn == InteractionHand.MAIN_HAND;
        boolean wrenched = AllItems.WRENCH.isIn(heldItem);
        if (hit.m_82434_() == state.m_61143_(HORIZONTAL_FACING)) {
            if (crafter.phase != MechanicalCrafterBlockEntity.Phase.IDLE && !wrenched) {
                crafter.ejectWholeGrid();
                return InteractionResult.SUCCESS;
            }
            if (crafter.phase == MechanicalCrafterBlockEntity.Phase.IDLE && !isHand && !wrenched) {
                if (worldIn.f_46443_) {
                    return InteractionResult.SUCCESS;
                }
                if (AllItems.CRAFTER_SLOT_COVER.isIn(heldItem)) {
                    if (crafter.covered) {
                        return InteractionResult.PASS;
                    }
                    if (!crafter.inventory.m_7983_()) {
                        return InteractionResult.PASS;
                    }
                    crafter.covered = true;
                    crafter.m_6596_();
                    crafter.sendData();
                    if (!player.m_7500_()) {
                        heldItem.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                LazyOptional capability = crafter.getCapability(ForgeCapabilities.ITEM_HANDLER);
                if (!capability.isPresent()) {
                    return InteractionResult.PASS;
                }
                ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)capability.orElse((Object)new ItemStackHandler())), (ItemStack)heldItem.m_41777_(), (boolean)false);
                if (remainder.m_41613_() != heldItem.m_41613_()) {
                    player.m_21008_(handIn, remainder);
                }
                return InteractionResult.SUCCESS;
            }
            ItemStack inSlot = crafter.getInventory().m_8020_(0);
            if (inSlot.m_41619_()) {
                if (crafter.covered && !wrenched) {
                    if (worldIn.f_46443_) {
                        return InteractionResult.SUCCESS;
                    }
                    crafter.covered = false;
                    crafter.m_6596_();
                    crafter.sendData();
                    if (!player.m_7500_()) {
                        player.m_150109_().m_150079_(AllItems.CRAFTER_SLOT_COVER.asStack());
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            if (!isHand && !ItemHandlerHelper.canItemStacksStack((ItemStack)heldItem, (ItemStack)inSlot)) {
                return InteractionResult.PASS;
            }
            if (worldIn.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            player.m_150109_().m_150079_(inSlot);
            crafter.getInventory().setStackInSlot(0, ItemStack.f_41583_);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        InvManipulationBehaviour behaviour = BlockEntityBehaviour.get((BlockGetter)worldIn, pos, InvManipulationBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.onNeighborChanged(fromPos);
        }
    }

    @Override
    public float getParticleTargetRadius() {
        return 0.85f;
    }

    @Override
    public float getParticleInitialRadius() {
        return 0.75f;
    }

    public static Direction getTargetDirection(BlockState state) {
        if (!AllBlocks.MECHANICAL_CRAFTER.has(state)) {
            return Direction.UP;
        }
        Direction facing = (Direction)state.m_61143_(HORIZONTAL_FACING);
        Pointing point = (Pointing)state.m_61143_(POINTING);
        Vec3 targetVec = new Vec3(0.0, 1.0, 0.0);
        targetVec = VecHelper.rotate((Vec3)targetVec, (double)(-point.getXRotation()), (Direction.Axis)Direction.Axis.Z);
        targetVec = VecHelper.rotate((Vec3)targetVec, (double)AngleHelper.horizontalAngle((Direction)facing), (Direction.Axis)Direction.Axis.Y);
        return Direction.m_122366_((double)targetVec.f_82479_, (double)targetVec.f_82480_, (double)targetVec.f_82481_);
    }

    public static boolean isValidTarget(Level world, BlockPos targetPos, BlockState crafterState) {
        BlockState targetState = world.m_8055_(targetPos);
        if (!world.m_46749_(targetPos)) {
            return false;
        }
        if (!AllBlocks.MECHANICAL_CRAFTER.has(targetState)) {
            return false;
        }
        if (crafterState.m_61143_(HORIZONTAL_FACING) != targetState.m_61143_(HORIZONTAL_FACING)) {
            return false;
        }
        return Math.abs(((Pointing)crafterState.m_61143_(POINTING)).getXRotation() - ((Pointing)targetState.m_61143_(POINTING)).getXRotation()) != 180;
    }

    @Override
    public Class<MechanicalCrafterBlockEntity> getBlockEntityClass() {
        return MechanicalCrafterBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends MechanicalCrafterBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.MECHANICAL_CRAFTER.get();
    }
}

