/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.worldgen.features;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.ordana.spelunkery.worldgen.feature_configs.HugeForkingMushroomFeatureConfig;
import java.util.HashSet;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class HugeForkingMushroomFeature
extends Feature<HugeForkingMushroomFeatureConfig> {
    public HugeForkingMushroomFeature(Codec<HugeForkingMushroomFeatureConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<HugeForkingMushroomFeatureConfig> context) {
        WorldGenLevel level = context.m_159774_();
        RandomSource random = level.m_213780_();
        BlockPos blockPos = context.m_159777_();
        HugeForkingMushroomFeatureConfig config = (HugeForkingMushroomFeatureConfig)context.m_159778_();
        HashSet set = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> blockSetter = (blockPosx, blockState) -> {
            set.add(blockPosx.m_7949_());
            level.m_7731_(blockPosx, blockState, 19);
        };
        BiConsumer<BlockPos, BlockState> blockSetter2 = (blockPosx, blockState) -> {
            set.add(blockPosx.m_7949_());
            level.m_7731_(blockPosx, (BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)PipeBlock.f_55148_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PipeBlock.f_55150_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PipeBlock.f_55149_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PipeBlock.f_55151_, (Comparable)Boolean.valueOf(false)), 19);
        };
        int radius = random.m_188503_(2) + config.height;
        this.placeBranches((LevelSimulatedReader)level, blockSetter, random, config, blockPos);
        return true;
    }

    protected void placeCap(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, HugeForkingMushroomFeatureConfig config, BlockPos pos) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        if (config.largeCap) {
            for (Direction dir : Direction.values()) {
                if (dir == Direction.DOWN) continue;
                blockSetter.accept(mutableBlockPos.m_121945_(dir), config.foliageProvider.m_213972_(random, (BlockPos)mutableBlockPos));
            }
            blockSetter.accept(mutableBlockPos.m_121945_(Direction.NORTH).m_121945_(Direction.EAST), config.foliageProvider.m_213972_(random, (BlockPos)mutableBlockPos));
            blockSetter.accept(mutableBlockPos.m_121945_(Direction.SOUTH).m_121945_(Direction.EAST), config.foliageProvider.m_213972_(random, (BlockPos)mutableBlockPos));
            blockSetter.accept(mutableBlockPos.m_121945_(Direction.NORTH).m_121945_(Direction.WEST), config.foliageProvider.m_213972_(random, (BlockPos)mutableBlockPos));
            blockSetter.accept(mutableBlockPos.m_121945_(Direction.SOUTH).m_121945_(Direction.WEST), config.foliageProvider.m_213972_(random, (BlockPos)mutableBlockPos));
            mutableBlockPos.m_122173_(Direction.UP);
            for (Direction dir : Direction.values()) {
                if (dir == Direction.DOWN || dir == Direction.UP) continue;
                blockSetter.accept(mutableBlockPos.m_121945_(dir), config.foliageProvider.m_213972_(random, (BlockPos)mutableBlockPos));
            }
        } else {
            for (int i = 0; i < config.capHeight; ++i) {
                for (Direction dir : Direction.values()) {
                    if (dir == Direction.DOWN) continue;
                    blockSetter.accept(mutableBlockPos.m_121945_(dir), config.foliageProvider.m_213972_(random, (BlockPos)mutableBlockPos));
                }
                mutableBlockPos.m_122173_(Direction.UP);
            }
            mutableBlockPos.m_122173_(Direction.DOWN);
            if (config.lightProvider != null) {
                blockSetter.accept((BlockPos)mutableBlockPos, config.lightProvider.m_213972_(random, (BlockPos)mutableBlockPos));
            }
        }
    }

    protected void placeBranches(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, HugeForkingMushroomFeatureConfig config, BlockPos pos) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        BlockState state = config.stemProvider.m_213972_(random, pos);
        Direction dirf = Direction.Plane.HORIZONTAL.m_235690_(random);
        Direction dir2 = dirf.m_122427_();
        Direction dir3 = dir2.m_122427_();
        if (random.m_188499_() && config.centerHeight > 0) {
            for (int i = 0; i < config.centerHeight; ++i) {
                blockSetter.accept((BlockPos)mutableBlockPos, state);
                mutableBlockPos.m_122173_(Direction.UP);
            }
            if (random.m_188499_()) {
                blockSetter.accept((BlockPos)mutableBlockPos, state);
                mutableBlockPos.m_122173_(Direction.UP);
                blockSetter.accept((BlockPos)mutableBlockPos, state);
            }
            blockSetter.accept((BlockPos)mutableBlockPos, state);
            this.placeCap(level, blockSetter, random, config, (BlockPos)mutableBlockPos);
            mutableBlockPos.m_122190_((Vec3i)pos);
        }
        for (Direction dir : Direction.Plane.HORIZONTAL.m_235694_(random)) {
            blockSetter.accept(mutableBlockPos.m_121945_(dir).m_121945_(Direction.UP), state);
            if (random.m_188499_()) {
                blockSetter.accept((BlockPos)mutableBlockPos, state);
                mutableBlockPos.m_122173_(Direction.UP);
                blockSetter.accept((BlockPos)mutableBlockPos, state);
            }
            if (random.m_188499_()) {
                for (i = 0; i < config.height; ++i) {
                    blockSetter.accept((BlockPos)mutableBlockPos, state);
                    mutableBlockPos.m_122173_(Direction.UP).m_122173_(dir);
                    blockSetter.accept((BlockPos)mutableBlockPos, state);
                    mutableBlockPos.m_122173_(Direction.UP);
                    blockSetter.accept((BlockPos)mutableBlockPos, state);
                }
                if (random.m_188499_()) {
                    mutableBlockPos.m_122173_(Direction.UP);
                    blockSetter.accept((BlockPos)mutableBlockPos, state);
                }
                this.placeCap(level, blockSetter, random, config, (BlockPos)mutableBlockPos);
            } else {
                for (i = 0; i < config.height; ++i) {
                    blockSetter.accept((BlockPos)mutableBlockPos, state);
                    mutableBlockPos.m_122173_(Direction.UP).m_122173_(dir);
                    blockSetter.accept((BlockPos)mutableBlockPos, state);
                    mutableBlockPos.m_122173_(Direction.UP).m_122173_(dir);
                }
                if (random.m_188499_()) {
                    blockSetter.accept((BlockPos)mutableBlockPos, state);
                    mutableBlockPos.m_122173_(Direction.UP);
                    blockSetter.accept((BlockPos)mutableBlockPos, state);
                }
            }
            blockSetter.accept((BlockPos)mutableBlockPos, state);
            this.placeCap(level, blockSetter, random, config, (BlockPos)mutableBlockPos);
            mutableBlockPos.m_122190_((Vec3i)pos);
            if (!((double)random.m_188501_() >= 0.5)) continue;
            break;
        }
    }

    protected boolean shouldSkipLocation(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        return localX == range && localZ == range && range > 0;
    }

    protected boolean shouldSkipLocationSignedOg(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        int j;
        int i;
        if (large) {
            i = Math.min(Math.abs(localX), Math.abs(localX - 1));
            j = Math.min(Math.abs(localZ), Math.abs(localZ - 1));
        } else {
            i = Math.abs(localX);
            j = Math.abs(localZ);
        }
        return this.shouldSkipLocation(random, i, localY, j, range, large);
    }
}

