/*
 * Decompiled with CFR 0.152.
 */
package appeng.block;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.block.AEBaseBlock;
import appeng.block.IOwnerAwareBlockEntity;
import appeng.block.networking.CableBusBlock;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.AEBaseInvBlockEntity;
import appeng.items.tools.MemoryCardItem;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class AEBaseEntityBlock<T extends AEBaseBlockEntity>
extends AEBaseBlock
implements EntityBlock {
    private Class<T> blockEntityClass;
    private BlockEntityType<T> blockEntityType;
    @Nullable
    private BlockEntityTicker<T> serverTicker;
    @Nullable
    private BlockEntityTicker<T> clientTicker;

    public AEBaseEntityBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public void setBlockEntity(Class<T> blockEntityClass, BlockEntityType<T> blockEntityType, BlockEntityTicker<T> clientTicker, BlockEntityTicker<T> serverTicker) {
        this.blockEntityClass = blockEntityClass;
        this.blockEntityType = blockEntityType;
        this.serverTicker = serverTicker;
        this.clientTicker = clientTicker;
    }

    @Nullable
    public T getBlockEntity(BlockGetter level, int x, int y, int z) {
        return this.getBlockEntity(level, new BlockPos(x, y, z));
    }

    @Nullable
    public T getBlockEntity(BlockGetter level, BlockPos pos) {
        BlockEntity te = level.m_7702_(pos);
        if (this.blockEntityClass != null && this.blockEntityClass.isInstance(te)) {
            return (T)((AEBaseBlockEntity)this.blockEntityClass.cast(te));
        }
        return null;
    }

    public BlockEntityType<T> getBlockEntityType() {
        return this.blockEntityType;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.blockEntityType.m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.m_5776_() ? this.clientTicker : this.serverTicker;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        T be;
        if (!level.m_5776_() && !newState.m_60713_(state.m_60734_()) && (be = this.getBlockEntity((BlockGetter)level, pos)) != null) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            ((AEBaseBlockEntity)be).addAdditionalDrops(level, pos, drops);
            Platform.spawnDrops(level, pos, drops);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public boolean m_7278_(BlockState state) {
        return AEBaseInvBlockEntity.class.isAssignableFrom(this.blockEntityClass);
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        AEBaseInvBlockEntity invBlockEntity;
        T te = this.getBlockEntity((BlockGetter)level, pos);
        if (te instanceof AEBaseInvBlockEntity && !(invBlockEntity = (AEBaseInvBlockEntity)te).getInternalInventory().isEmpty()) {
            return invBlockEntity.getInternalInventory().getRedstoneSignal();
        }
        return 0;
    }

    public boolean m_8133_(BlockState state, Level level, BlockPos pos, int eventID, int eventParam) {
        super.m_8133_(state, level, pos, eventID, eventParam);
        BlockEntity blockEntity = level.m_7702_(pos);
        return blockEntity != null ? blockEntity.m_7531_(eventID, eventParam) : false;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack is) {
        Component hoverName;
        ComponentContents componentContents;
        Player player;
        T blockEntity = this.getBlockEntity((BlockGetter)level, pos);
        if (blockEntity == null) {
            return;
        }
        if (blockEntity instanceof IOwnerAwareBlockEntity) {
            IOwnerAwareBlockEntity ownerAware = (IOwnerAwareBlockEntity)blockEntity;
            if (placer instanceof Player) {
                player = (Player)placer;
                ownerAware.setOwner(player);
            }
        }
        if ((componentContents = (hoverName = is.m_41786_()).m_214077_()) instanceof LiteralContents) {
            LiteralContents text = (LiteralContents)componentContents;
            ((AEBaseBlockEntity)blockEntity).setName(text.f_237368_());
        }
        if (is.m_41782_()) {
            player = null;
            if (placer instanceof Player) {
                player = (Player)placer;
            }
            ((AEBaseBlockEntity)blockEntity).importSettings(SettingsFrom.DISMANTLE_ITEM, is.m_41783_(), player);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem;
        Item item;
        if (player != null && !player.m_21120_(hand).m_41619_() && (item = (heldItem = player.m_21120_(hand)).m_41720_()) instanceof IMemoryCard) {
            IMemoryCard memoryCard = (IMemoryCard)item;
            if (!(this instanceof CableBusBlock)) {
                T blockEntity = this.getBlockEntity((BlockGetter)level, pos);
                if (blockEntity == null) {
                    return InteractionResult.FAIL;
                }
                String name = this.m_7705_();
                if (InteractionUtil.isInAlternateUseMode(player)) {
                    CompoundTag data = new CompoundTag();
                    ((AEBaseBlockEntity)blockEntity).exportSettings(SettingsFrom.MEMORY_CARD, data, player);
                    if (!data.m_128456_()) {
                        memoryCard.setMemoryCardContents(heldItem, name, data);
                        memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
                    }
                } else {
                    String savedName = memoryCard.getSettingsName(heldItem);
                    CompoundTag data = memoryCard.getData(heldItem);
                    if (this.m_7705_().equals(savedName)) {
                        ((AEBaseBlockEntity)blockEntity).importSettings(SettingsFrom.MEMORY_CARD, data, player);
                        memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                    } else {
                        MemoryCardItem.importGenericSettingsAndNotify(blockEntity, data, player);
                    }
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        return this.onActivated(level, pos, player, hand, player.m_21120_(hand), hit);
    }

    public InteractionResult onActivated(Level level, BlockPos pos, Player player, InteractionHand hand, @Nullable ItemStack heldItem, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    public final BlockState getBlockEntityBlockState(BlockState current, BlockEntity te) {
        if (current.m_60734_() != this || !this.blockEntityClass.isInstance(te)) {
            return current;
        }
        return this.updateBlockStateFromBlockEntity(current, (AEBaseBlockEntity)this.blockEntityClass.cast(te));
    }

    protected BlockState updateBlockStateFromBlockEntity(BlockState currentState, T be) {
        return currentState;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List drops = super.m_49635_(state, builder);
        for (ItemStack drop : drops) {
            BlockItem blockItem;
            Item item = drop.m_41720_();
            if (!(item instanceof BlockItem) || (blockItem = (BlockItem)item).m_40614_() != this) continue;
            LootParams lootContext = builder.m_287286_(LootContextParams.f_81461_, (Object)state).m_287235_(LootContextParamSets.f_81421_);
            BlockEntity be = (BlockEntity)lootContext.m_287267_(LootContextParams.f_81462_);
            if (!(be instanceof AEBaseBlockEntity)) break;
            AEBaseBlockEntity aeBaseBlockEntity = (AEBaseBlockEntity)be;
            Entity looter = (Entity)lootContext.m_287267_(LootContextParams.f_81455_);
            Player player = null;
            if (looter instanceof Player) {
                player = (Player)looter;
            }
            if (drop.m_41782_()) {
                aeBaseBlockEntity.exportSettings(SettingsFrom.DISMANTLE_ITEM, drop.m_41783_(), player);
                break;
            }
            CompoundTag tag = new CompoundTag();
            aeBaseBlockEntity.exportSettings(SettingsFrom.DISMANTLE_ITEM, tag, player);
            if (tag.m_128456_()) break;
            drop.m_41751_(tag);
            break;
        }
        return drops;
    }
}

