/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook;

import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.core.localization.GuiText;
import appeng.parts.BusCollisionHelper;
import guideme.color.ColorValue;
import guideme.color.SymbolicColor;
import guideme.scene.ImplicitAnnotationStrategy;
import guideme.scene.annotation.InWorldBoxAnnotation;
import guideme.scene.annotation.SceneAnnotation;
import guideme.scene.level.GuidebookLevel;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class PartAnnotationStrategy
implements ImplicitAnnotationStrategy {
    @Nullable
    public SceneAnnotation getAnnotation(GuidebookLevel level, BlockState blockState, BlockHitResult blockHitResult) {
        BlockPos pos = blockHitResult.m_82425_();
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof IPartHost)) {
            return null;
        }
        IPartHost partHost = (IPartHost)be;
        SelectedPart partResult = partHost.selectPartWorld(blockHitResult.m_82450_());
        if (partResult != null) {
            IPart part = partResult.part;
            IFacadePart facade = partResult.facade;
            AABB aabb = null;
            MutableComponent description = Component.m_237119_();
            if (part != null) {
                aabb = this.getAABB(partResult.side, partResult.part::getBoxes);
                description = partResult.part.getPartItem().m_5456_().m_41466_();
            } else if (facade != null) {
                aabb = this.getAABB(partResult.side, bch -> partResult.facade.getBoxes((IPartCollisionHelper)bch, false));
                description = GuiText.Facade.text(partResult.facade.getItem().m_41466_());
            }
            if (aabb != null) {
                InWorldBoxAnnotation annotation = new InWorldBoxAnnotation(new Vector3f((float)pos.m_123341_() + (float)aabb.f_82288_, (float)pos.m_123342_() + (float)aabb.f_82289_, (float)pos.m_123343_() + (float)aabb.f_82290_), new Vector3f((float)pos.m_123341_() + (float)aabb.f_82291_, (float)pos.m_123342_() + (float)aabb.f_82292_, (float)pos.m_123343_() + (float)aabb.f_82293_), (ColorValue)SymbolicColor.IN_WORLD_BLOCK_HIGHLIGHT);
                annotation.setTooltipContent((Component)description);
                return annotation;
            }
        }
        return null;
    }

    @Nullable
    private AABB getAABB(Direction side, Consumer<IPartCollisionHelper> collisionHelper) {
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        BusCollisionHelper bch = new BusCollisionHelper(boxes, side, true);
        collisionHelper.accept(bch);
        if (boxes.isEmpty()) {
            return null;
        }
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        double maxZ = Double.MIN_VALUE;
        for (AABB box : boxes) {
            minX = Math.min(minX, box.f_82288_);
            minY = Math.min(minY, box.f_82289_);
            minZ = Math.min(minZ, box.f_82290_);
            maxX = Math.max(maxX, box.f_82291_);
            maxY = Math.max(maxY, box.f_82292_);
            maxZ = Math.max(maxZ, box.f_82293_);
        }
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

