/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.emi;

import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.integration.modules.emi.AppEngRecipeCategory;
import appeng.integration.modules.emi.EmiText;
import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipe;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

class EmiInscriberRecipe
extends BasicEmiRecipe {
    public static final EmiRecipeCategory CATEGORY = new AppEngRecipeCategory("inscriber", (EmiRenderable)EmiStack.of(AEBlocks.INSCRIBER), EmiText.CATEGORY_INSCRIBER);
    private final InscriberRecipe recipe;

    public EmiInscriberRecipe(InscriberRecipe recipe) {
        super(CATEGORY, recipe.m_6423_(), 97, 64);
        this.recipe = recipe;
        if (!recipe.getTopOptional().m_43947_()) {
            EmiIngredient top = EmiIngredient.of((Ingredient)recipe.getTopOptional());
            if (recipe.getProcessType() == InscriberProcessType.INSCRIBE) {
                top.getEmiStacks().forEach(s -> s.setRemainder(s));
            }
            this.inputs.add(top);
        }
        if (!recipe.getBottomOptional().m_43947_()) {
            EmiIngredient bottom = EmiIngredient.of((Ingredient)recipe.getBottomOptional());
            if (recipe.getProcessType() == InscriberProcessType.INSCRIBE) {
                bottom.getEmiStacks().forEach(s -> s.setRemainder(s));
            }
            this.inputs.add(bottom);
        }
        this.inputs.add(EmiIngredient.of((Ingredient)recipe.getMiddleInput()));
        this.outputs.add(EmiStack.of((ItemStack)recipe.getResultItem()));
    }

    public void addWidgets(WidgetHolder widgets) {
        ResourceLocation background = AppEng.makeId("textures/guis/inscriber.png");
        widgets.addTexture(background, 0, 0, 97, 64, 44, 15);
        widgets.addAnimatedTexture(background, 91, 24, 6, 18, 135, 177, 2000, false, true, false);
        widgets.addSlot(EmiIngredient.of((Ingredient)this.recipe.getTopOptional()), 0, 0).drawBack(false);
        widgets.addSlot(EmiIngredient.of((Ingredient)this.recipe.getMiddleInput()), 18, 23).drawBack(false);
        widgets.addSlot(EmiIngredient.of((Ingredient)this.recipe.getBottomOptional()), 0, 46).drawBack(false);
        widgets.addSlot((EmiIngredient)EmiStack.of((ItemStack)this.recipe.getResultItem()), 68, 24).recipeContext((EmiRecipe)this).drawBack(false);
    }
}

