/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jeirei;

import appeng.api.util.AEColor;
import appeng.core.AEConfig;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.items.parts.FacadeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class ItemPredicates {
    private ItemPredicates() {
    }

    public static boolean shouldBeHidden(ItemStack stack) {
        if (ItemPredicates.isInternal(stack)) {
            return true;
        }
        if (!AEConfig.instance().isDebugToolsEnabled() && ItemPredicates.isDeveloperTool(stack)) {
            return true;
        }
        if (!AEConfig.instance().isEnableFacadesInJEI() && ItemPredicates.isFacade(stack)) {
            return true;
        }
        return AEConfig.instance().isDisableColoredCableRecipesInJEI() && ItemPredicates.isColoredCable(stack);
    }

    private static boolean isInternal(ItemStack stack) {
        return AEItems.WRAPPED_GENERIC_STACK.isSameAs(stack) || ItemPredicates.isBrokenFacade(stack) || AEBlocks.CABLE_BUS.isSameAs(stack) || AEBlocks.MATRIX_FRAME.isSameAs(stack) || AEBlocks.PAINT.isSameAs(stack);
    }

    private static boolean isBrokenFacade(ItemStack stack) {
        FacadeItem i;
        Item item = stack.m_41720_();
        return item instanceof FacadeItem && (i = (FacadeItem)item).getTextureItem(stack).equals(ItemStack.f_41583_);
    }

    private static boolean isFacade(ItemStack stack) {
        return stack.m_41720_() instanceof FacadeItem;
    }

    private static boolean isDeveloperTool(ItemStack stack) {
        return AEBlocks.DEBUG_CUBE_GEN.isSameAs(stack) || AEBlocks.DEBUG_ENERGY_GEN.isSameAs(stack) || AEBlocks.DEBUG_ITEM_GEN.isSameAs(stack) || AEBlocks.DEBUG_PHANTOM_NODE.isSameAs(stack) || AEItems.DEBUG_CARD.isSameAs(stack) || AEItems.DEBUG_ERASER.isSameAs(stack) || AEItems.DEBUG_METEORITE_PLACER.isSameAs(stack) || AEItems.DEBUG_REPLICATOR_CARD.isSameAs(stack);
    }

    private static boolean isColoredCable(ItemStack stack) {
        for (AEColor color : AEColor.values()) {
            if (color == AEColor.TRANSPARENT || stack.m_41720_() != AEParts.COVERED_CABLE.item(color) && stack.m_41720_() != AEParts.COVERED_DENSE_CABLE.item(color) && stack.m_41720_() != AEParts.GLASS_CABLE.item(color) && stack.m_41720_() != AEParts.SMART_CABLE.item(color) && stack.m_41720_() != AEParts.SMART_DENSE_CABLE.item(color)) continue;
            return true;
        }
        return false;
    }
}

