/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testplots;

import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEParts;
import appeng.parts.AEBasePart;
import appeng.server.testplots.P2PPlotHelper;
import appeng.server.testplots.PosAndSide;
import appeng.server.testplots.TestPlot;
import appeng.server.testworld.CableBuilder;
import appeng.server.testworld.PlotBuilder;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ItemP2PTestPlots {
    @TestPlot(value="p2p_items")
    public static void item(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        P2PPlotHelper.placeTunnel(plot, AEParts.ITEM_P2P_TUNNEL);
        plot.hopper(origin.m_122024_().m_122024_(), Direction.EAST, new ItemStack((ItemLike)Items.f_41829_));
        BlockPos chestPos = origin.m_122029_().m_122029_();
        plot.chest(chestPos, new ItemStack[0]);
        plot.test(helper -> helper.m_177361_(() -> helper.m_177242_(chestPos, Items.f_41829_)));
    }

    @TestPlot(value="p2p_recursive_item")
    public static void recursiveItemP2P(PlotBuilder plot) {
        BlockPos origin = BlockPos.f_121853_;
        plot.block(origin, AEBlocks.DEBUG_ITEM_GEN);
        plot.creativeEnergyCell(origin.m_122019_().m_7494_().m_7494_());
        BlockPos curPos = origin.m_122019_();
        for (int i = 0; i < 10; ++i) {
            ItemP2PTestPlots.placeSubnet(plot, curPos);
            curPos = curPos.m_122020_(6);
        }
        plot.test(GameTestHelper::m_177412_);
    }

    private static void placeSubnet(PlotBuilder plot, BlockPos origin) {
        ArrayList<PosAndSide> outputTunnels = new ArrayList<PosAndSide>();
        for (int i = 0; i < 6; ++i) {
            boolean last;
            BlockPos p = origin.m_5484_(Direction.SOUTH, i);
            CableBuilder cb = plot.cable(p);
            cb.part(Direction.DOWN, AEParts.ITEM_P2P_TUNNEL);
            outputTunnels.add(PosAndSide.down(p));
            boolean first = i == 0;
            boolean bl = last = i + 1 >= 6;
            if (first) {
                cb.part(Direction.NORTH, AEParts.ITEM_P2P_TUNNEL);
            } else if (last) {
                cb.part(Direction.SOUTH, AEParts.ITEM_P2P_TUNNEL);
                outputTunnels.add(PosAndSide.south(p));
            }
            if (first || last) {
                cb.part(Direction.UP, AEParts.QUARTZ_FIBER);
            }
            plot.hopper(p.m_7495_(), Direction.DOWN);
            plot.block(p.m_7495_().m_7495_(), AEBlocks.CONDENSER);
        }
        plot.cable(origin.m_7494_());
        plot.cable(origin.m_122020_(5).m_7494_());
        plot.afterGridInitAt(origin, (grid, gridNode) -> {
            BlockPos absOrigin = ((AEBasePart)gridNode.getOwner()).getBlockEntity().m_58899_();
            BlockPos relativeOffset = absOrigin.m_7918_(-origin.m_123341_(), -origin.m_123342_(), -origin.m_123343_());
            P2PPlotHelper.linkTunnels(grid, PosAndSide.north(origin.m_121955_((Vec3i)relativeOffset)), outputTunnels.stream().map(p -> p.offset((Vec3i)relativeOffset)).toList());
        });
    }
}

