/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.block;

import com.soytutta.mynethersdelight.common.registry.MNDBlocks;
import com.soytutta.mynethersdelight.common.registry.MNDItems;
import com.soytutta.mynethersdelight.common.tag.MNDTags;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;
import vectorwing.farmersdelight.common.tag.ForgeTags;

public class PowderyCaneBlock
extends BushBlock
implements IPlantable,
BonemealableBlock {
    public static final BooleanProperty LIT = BooleanProperty.m_61465_((String)"lit");
    public static final BooleanProperty BASE = BooleanProperty.m_61465_((String)"base");
    public static final BooleanProperty LEAVE = BooleanProperty.m_61465_((String)"leave");
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)2);
    public static final IntegerProperty PRESSURE = IntegerProperty.m_61631_((String)"pressure", (int)0, (int)2);
    private static final VoxelShape SHAPE = Block.m_49796_((double)6.5, (double)0.0, (double)6.5, (double)10.5, (double)16.0, (double)10.5);

    public PowderyCaneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEAVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BASE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PRESSURE, (Comparable)Integer.valueOf(0))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIT, BASE, LEAVE, AGE, PRESSURE});
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)MNDItems.BULLET_PEPPER.get());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Vec3 vec3 = state.m_60824_(worldIn, pos);
        return SHAPE.m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockBelow = level.m_8055_(pos.m_7495_());
        return blockBelow.m_204336_(MNDTags.POWDERY_CANNON_PLANTABLE_ON) || blockBelow.m_204336_(MNDTags.POWDERY_CANE);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState offsetState, LevelAccessor level, BlockPos pos, BlockPos offsetPos) {
        if ((Integer)state.m_61143_((Property)PRESSURE) > 0) {
            level.m_186460_(pos, (Block)this, 1);
        }
        BlockState blockAbove = level.m_8055_(pos.m_7494_());
        BlockState blockBelow = level.m_8055_(pos.m_7495_());
        if (blockBelow.m_204336_(MNDTags.POWDERY_CANNON_PLANTABLE_ON)) {
            state = (BlockState)state.m_61124_((Property)BASE, (Comparable)Boolean.valueOf(true));
        } else if (!blockAbove.m_60713_(MNDBlocks.BULLET_PEPPER.get()) && !blockAbove.m_60713_(Blocks.f_50016_)) {
            state = (BlockState)state.m_61124_((Property)LEAVE, (Comparable)Boolean.valueOf(false));
        } else if (blockBelow.m_60713_(MNDBlocks.POWDERY_CANE.get()) && !((Boolean)state.m_61143_((Property)BASE)).booleanValue() && !((Boolean)state.m_61143_((Property)LEAVE)).booleanValue()) {
            state = (BlockState)state.m_61124_((Property)LEAVE, (Comparable)Boolean.valueOf(new Random().nextInt(100) < 85));
        }
        return super.m_7417_(state, direction, offsetState, level, pos, offsetPos);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.f_46443_) {
            return;
        }
        BlockPos posAbove = pos.m_7494_();
        BlockState stateAbove = level.m_8055_(posAbove);
        int age = (Integer)state.m_61143_((Property)AGE);
        int pressure = (Integer)state.m_61143_((Property)PRESSURE);
        boolean isLit = (Boolean)state.m_61143_((Property)LIT);
        if (!state.m_60710_((LevelReader)level, pos)) {
            if (isLit) {
                this.explodeAndReset((Level)level, pos, state, age);
            }
            level.m_46961_(pos, true);
        }
        if (pressure > 0) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)PRESSURE, (Comparable)Integer.valueOf(pressure - 1)), 2);
        }
        if (stateAbove.m_61138_((Property)PRESSURE) && (Integer)stateAbove.m_61143_((Property)PRESSURE) < 2 && (stateAbove.m_204336_(MNDTags.POWDERY_CANE) || stateAbove.m_60713_(MNDBlocks.BULLET_PEPPER.get()))) {
            level.m_7731_(posAbove, (BlockState)stateAbove.m_61124_((Property)PRESSURE, (Comparable)Integer.valueOf((Integer)stateAbove.m_61143_((Property)PRESSURE) + 1)), 2);
        }
        if (pressure == 2 && isLit) {
            this.explodeAndReset((Level)level, pos, state, age);
        }
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int age = (Integer)state.m_61143_((Property)AGE);
        BlockState blockBelow = world.m_8055_(pos.m_7495_());
        if (age < 2 && ForgeHooks.onCropsGrowPre((Level)world, (BlockPos)pos, (BlockState)state, (random.m_188503_(3) == 0 ? 1 : 0) != 0) && (blockBelow.m_60713_(MNDBlocks.RESURGENT_SOIL.get()) || blockBelow.m_60713_(MNDBlocks.POWDERY_CANNON.get()))) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            ForgeHooks.onCropsGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
        } else if (world.m_46859_(pos.m_7494_())) {
            world.m_46597_(pos.m_7494_(), MNDBlocks.BULLET_PEPPER.get().m_49966_());
        } else if (age == 2) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!(entity instanceof LivingEntity) || entity.m_6095_() == EntityType.f_20507_ || entity.m_6095_() == EntityType.f_20550_ || entity.m_6047_()) {
            return;
        }
        entity.m_6469_(level.m_269111_().m_269325_(), 1.0f);
        entity.m_7601_(state, new Vec3(0.8, 0.75, 0.8));
        if (!level.f_46443_ && (Integer)state.m_61143_((Property)PRESSURE) < 2) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)PRESSURE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)PRESSURE) + 1)), 2);
        }
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            this.plantPepper(level, pos);
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        ItemStack heldItem;
        if (!level.f_46443_ && (Integer)state.m_61143_((Property)PRESSURE) < 2 && !player.m_6047_()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)PRESSURE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)PRESSURE) + 1)), 2);
        }
        if (!(!((Boolean)state.m_61143_((Property)LIT)).booleanValue() || (heldItem = player.m_21120_(InteractionHand.MAIN_HAND)).m_204117_(ForgeTags.TOOLS_KNIVES) && heldItem.m_204117_(Tags.Items.SHEARS))) {
            int age = state.m_61138_((Property)AGE) ? (Integer)state.m_61143_((Property)AGE) : 0;
            this.explodeAndReset(level, pos, state, age);
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_7592_(Level level, BlockPos pos, Explosion explosion) {
        BlockState state = level.m_8055_(pos);
        if (!level.f_46443_ && state.m_61138_((Property)LIT) && ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            int age = state.m_61138_((Property)AGE) ? (Integer)state.m_61143_((Property)AGE) : 0;
            this.explodeAndReset(level, pos, state, age);
        }
    }

    private void plantPepper(Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.m_121945_(direction);
            BlockState neighborState = level.m_8055_(neighborPos);
            BlockState belowNeighborState = level.m_8055_(neighborPos.m_7495_());
            if (!neighborState.m_60795_() || !belowNeighborState.m_204336_(MNDTags.POWDERY_CANNON_PLANTABLE_ON) || !((double)level.f_46441_.m_188501_() < 0.25)) continue;
            level.m_7731_(neighborPos, MNDBlocks.BULLET_PEPPER.get().m_49966_(), 3);
            break;
        }
    }

    private void explodeAndReset(Level level, BlockPos pos, BlockState state, int age) {
        level.m_5594_(null, pos, SoundEvents.f_11837_, SoundSource.BLOCKS, 0.5f, 0.25f);
        level.m_255391_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1.25f, false, Level.ExplosionInteraction.NONE);
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
        if (state.m_61138_((Property)AGE) && age > 0) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age - 1)), 3);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult context) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_204117_(ForgeTags.TOOLS_KNIVES) || heldItem.m_204117_(Tags.Items.SHEARS)) {
            int age = (Integer)state.m_61143_((Property)AGE);
            if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                if (age > 0) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age - 1)), 3);
                }
                int j = 2 + level.f_46441_.m_188503_(3);
                PowderyCaneBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)MNDItems.BULLET_PEPPER.get(), j));
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.FALSE), 2);
                heldItem.m_41622_(1, (LivingEntity)player, action -> action.m_21190_(hand));
                level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            } else if (((Boolean)state.m_61143_((Property)LEAVE)).booleanValue()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)LEAVE, (Comparable)Boolean.FALSE), 2);
                heldItem.m_41622_(1, (LivingEntity)player, action -> action.m_21190_(hand));
                level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, context);
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return false;
    }

    public boolean m_7357_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull PathComputationType path) {
        return false;
    }

    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return BlockPathTypes.DAMAGE_OTHER;
    }

    public BlockPathTypes getAdjacentBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, BlockPathTypes originalType) {
        return BlockPathTypes.DANGER_OTHER;
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClientSide) {
        return false;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return false;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
    }
}

