/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.wrappers;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.lavabucket.hourglass.Hourglass;
import net.lavabucket.hourglass.time.SleepStatus;
import net.lavabucket.hourglass.wrappers.ServerPlayerWrapper;
import net.lavabucket.hourglass.wrappers.Wrapper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerLevelWrapper
extends Wrapper<ServerLevel> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Class<ServerLevel> levelClass = ServerLevel.class;
    private static final Class<ServerLevelData> levelDataClass = ServerLevelData.class;
    private static final Class<DerivedLevelData> derivedLevelDataClass = DerivedLevelData.class;
    public final ServerLevelData levelData = levelDataClass.cast(((ServerLevel)this.get()).m_6106_());

    public ServerLevelWrapper(LevelAccessor level) {
        super(levelClass.cast(level));
    }

    public boolean daylightRuleEnabled() {
        return ((ServerLevel)this.get()).m_46469_().m_46207_(GameRules.f_46140_);
    }

    public boolean weatherRuleEnabled() {
        return ((ServerLevel)this.get()).m_46469_().m_46207_(GameRules.f_46150_);
    }

    public void setRandomTickSpeed(int speed) {
        ((GameRules.IntegerValue)((ServerLevel)this.get()).m_46469_().m_46170_(GameRules.f_46143_)).m_151489_(speed, ((ServerLevel)this.get()).m_7654_());
    }

    public boolean weatherCycleEnabled() {
        return this.weatherRuleEnabled() && ((ServerLevel)this.get()).m_6042_().f_223549_();
    }

    public void stopWeather() {
        this.levelData.m_6399_(0);
        this.levelData.m_5565_(false);
        this.levelData.m_6398_(0);
        this.levelData.m_5557_(false);
    }

    public void setSleepStatus(SleepStatus newStatus) {
        try {
            Field sleepStatus = ObfuscationReflectionHelper.findField(levelClass, (String)"f_143245_");
            sleepStatus.setAccessible(true);
            sleepStatus.set(this.get(), (Object)newStatus);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | ObfuscationReflectionHelper.UnableToAccessFieldException e) {
            LOGGER.warn(Hourglass.MARKER, "Error setting sleep status.", e);
            return;
        }
    }

    public void wakeUpAllPlayers() {
        ((ServerLevel)this.get()).m_6907_().stream().map(player -> new ServerPlayerWrapper((Player)player)).filter(ServerPlayerWrapper::isSleeping).forEach(player -> ((ServerPlayer)player.get()).m_6145_(false, false));
    }

    public void tickBlockEntities() {
        try {
            Method tickBlockEntitiesMethod = ObfuscationReflectionHelper.findMethod(Level.class, (String)"m_46463_", (Class[])new Class[0]);
            tickBlockEntitiesMethod.setAccessible(true);
            tickBlockEntitiesMethod.invoke(this.get(), new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException | ObfuscationReflectionHelper.UnableToFindMethodException e) {
            LOGGER.warn(Hourglass.MARKER, "Error ticking block entities.", e);
            return;
        }
    }

    public static boolean isDerived(LevelAccessor level) {
        return level != null && level.m_6106_().getClass() == derivedLevelDataClass;
    }

    public static boolean isServerLevel(LevelAccessor level) {
        return level != null && level.getClass() == levelClass;
    }
}

