/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.core.tube;

import com.petrolpark.RequiresCreate;
import com.petrolpark.compat.create.CreateBlockEntityTypes;
import com.petrolpark.compat.create.CreateBlocks;
import com.petrolpark.compat.create.core.tube.ClientTubePlacementHandler;
import com.petrolpark.compat.create.core.tube.ITubeBlock;
import com.petrolpark.compat.create.core.tube.ITubeBlockEntity;
import com.petrolpark.compat.create.core.tube.TubeSpline;
import com.petrolpark.util.BigItemStack;
import com.petrolpark.util.BlockFace;
import com.petrolpark.util.ItemHelper;
import com.petrolpark.util.NBTHelper;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

@RequiresCreate
public class TubeBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<TubeBehaviour> TYPE = new BehaviourType();
    protected final ITubeBlockEntity tubeBlockEntity;
    protected boolean controller = false;
    protected int initializationTicks = 0;
    private List<Vec3> middleControlPoints = new ArrayList<Vec3>();
    protected TubeSpline spline = null;
    protected BlockPos otherEndPos = null;
    protected boolean disconnecting = false;

    public <BE extends SmartBlockEntity> TubeBehaviour(BE be) {
        super(be);
        this.tubeBlockEntity = (ITubeBlockEntity)be;
    }

    public boolean isController() {
        return this.controller;
    }

    public Optional<TubeSpline> getSplineOptional() {
        return this.isController() ? Optional.ofNullable(this.getSpline()) : TubeBehaviour.get(this.getWorld(), this.otherEndPos).map(TubeBehaviour::getSpline);
    }

    public TubeSpline getSpline() {
        if (this.spline == null && this.controller) {
            BlockState thisState = this.blockEntity.m_58900_();
            Block block = thisState.m_60734_();
            if (!(block instanceof ITubeBlock)) {
                return null;
            }
            ITubeBlock tubeBlock = (ITubeBlock)block;
            BlockState endState = this.getWorld().m_8055_(this.otherEndPos);
            if (endState.m_60734_() != tubeBlock) {
                return null;
            }
            this.spline = new TubeSpline(BlockFace.of(this.getPos(), tubeBlock.getTubeConnectingFace(this.getWorld(), this.getPos(), thisState)), BlockFace.of(this.otherEndPos, tubeBlock.getTubeConnectingFace(this.getWorld(), this.otherEndPos, endState)), this.middleControlPoints, tubeBlock.getTubeMaxAngle(), tubeBlock.getTubeSegmentLength(), tubeBlock.getTubeSegmentRadius());
            this.tubeBlockEntity.invalidateTubeRenderBoundingBox();
        }
        return this.spline;
    }

    public BlockPos getOtherEndPos() {
        return this.otherEndPos;
    }

    public void connect(TubeSpline spline) {
        if (!spline.start.getPos().equals((Object)this.getPos())) {
            throw new IllegalStateException("Mismatch in tube spline start and controller position.");
        }
        this.controller = true;
        this.disconnecting = false;
        this.otherEndPos = spline.end.getPos();
        this.spline = spline;
        this.middleControlPoints = this.getSpline().getMiddleControlPoints();
        for (BlockPos pos : this.getSpline().getBlockedPositions()) {
            this.getWorld().m_7731_(pos, CreateBlocks.TUBE_STRUCTURE.getDefaultState(), 3);
        }
        this.initializationTicks = 3;
        TubeBehaviour.get(this.getWorld(), this.otherEndPos).ifPresent(tube -> {
            tube.otherEndPos = this.getPos();
            tube.disconnecting = false;
        });
        this.playSound(false);
        this.tubeBlockEntity.afterTubeConnect();
        this.blockEntity.notifyUpdate();
    }

    public void disconnect() {
        this.disconnect(TubeBehaviour::dropItemsAlongSpline);
    }

    public void disconnect(BiConsumer<TubeBehaviour, BigItemStack> leftoverItemsConsumer) {
        if (this.disconnecting) {
            return;
        }
        this.disconnecting = true;
        if (this.controller) {
            this.tubeBlockEntity.beforeTubeDisconnect();
            leftoverItemsConsumer.accept(this, this.getRequiredStack());
            TubeBehaviour.get(this.getWorld(), this.otherEndPos).ifPresent(tube -> {
                tube.tubeBlockEntity.beforeTubeDisconnect();
                tube.otherEndPos = null;
                tube.blockEntity.notifyUpdate();
            });
            if (this.getSpline() != null) {
                for (BlockPos pos : this.getSpline().getBlockedPositions()) {
                    this.getWorld().m_46961_(pos, true);
                }
            }
            this.sendDestroyTubeParticles();
            this.playSound(true);
            this.controller = false;
            this.otherEndPos = null;
            this.spline = null;
            this.middleControlPoints = Collections.emptyList();
            this.blockEntity.notifyUpdate();
        } else {
            TubeBehaviour.get(this.getWorld(), this.otherEndPos).ifPresent(tube -> tube.disconnect(leftoverItemsConsumer));
        }
    }

    public void dropItemsAlongSpline(BigItemStack stack) {
        if (this.getWorld().m_5776_() || !this.getWorld().m_46469_().m_46207_(GameRules.f_46136_)) {
            return;
        }
        int points = this.getSpline().getPoints().size();
        int items = stack.getCount();
        if (items / points > 0) {
            for (Vec3 point : this.getSpline().getPoints()) {
                ItemHelper.pop(this.getWorld(), point, stack.copyStackWithCount(items / points));
            }
        }
        for (int i = 0; i < items % points; ++i) {
            ItemHelper.pop(this.getWorld(), this.getSpline().getPoints().get(i), stack.getSingleItemStack());
        }
    }

    public void sendDestroyTubeParticles() {
        Level level = this.getWorld();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        BlockParticleOption data = new BlockParticleOption(ParticleTypes.f_123794_, this.blockEntity.m_58900_());
        for (Vec3 point : this.spline.getPoints()) {
            level2.m_8767_((ParticleOptions)data, point.f_82479_, point.f_82480_, point.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void playSound(boolean destroy) {
        BlockState state = this.blockEntity.m_58900_();
        SoundType soundType = state.m_60827_();
        this.getWorld().m_5594_(null, this.getPos(), destroy ? soundType.m_56775_() : soundType.m_56777_(), SoundSource.BLOCKS, soundType.m_56773_(), soundType.m_56774_());
    }

    public boolean reconnect(Player player, boolean tryOtherIfNotController) {
        if (!this.controller) {
            if (tryOtherIfNotController) {
                return TubeBehaviour.get(this.getWorld(), this.otherEndPos).map(tube -> tube.reconnect(player, false)).orElse(false);
            }
            return false;
        }
        TubeSpline oldSpline = this.getSpline();
        if (oldSpline == null) {
            return false;
        }
        ItemStack stackForConstruction = this.getRequiredStack().getSingleItemStack();
        this.disconnect((controller, stack) -> {
            if (!player.m_150110_().f_35937_) {
                stack.getAsStacks().forEach(arg_0 -> ((Inventory)player.m_150109_()).m_150079_(arg_0));
            }
        });
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.reconnectClient(oldSpline, stackForConstruction));
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void reconnectClient(TubeSpline oldSpline, ItemStack stack) {
        ClientTubePlacementHandler.cancel();
        Block block = this.blockEntity.m_58900_().m_60734_();
        if (!(block instanceof ITubeBlock)) {
            return;
        }
        ITubeBlock tubeBlock = (ITubeBlock)block;
        Minecraft mc = Minecraft.m_91087_();
        ClientTubePlacementHandler.tryConnect(oldSpline.start, stack, tubeBlock, false);
        ClientTubePlacementHandler.tryConnect(oldSpline.end, stack, tubeBlock, false);
        if (ClientTubePlacementHandler.active()) {
            for (Vec3 controlPoint : oldSpline.getMiddleControlPoints()) {
                ClientTubePlacementHandler.addControlPointWithoutRevalidating(controlPoint);
            }
        }
        ClientTubePlacementHandler.revalidateSpline(mc);
    }

    public BigItemStack getRequiredStack() {
        Block block = this.blockEntity.m_58900_().m_60734_();
        if (this.getSpline() == null || !(block instanceof ITubeBlock)) {
            return BigItemStack.EMPTY;
        }
        ITubeBlock tubeBlock = (ITubeBlock)block;
        return new BigItemStack((ItemLike)block, tubeBlock.getItemsForTubeLength(this.getSpline().getLength()));
    }

    public static Optional<TubeBehaviour> get(Level level, BlockPos pos) {
        if (pos == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((TubeBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)pos, TYPE));
    }

    public void tick() {
        super.tick();
        if (this.initializationTicks > 0) {
            --this.initializationTicks;
            if (this.controller && this.initializationTicks == 1 && this.getSpline() != null) {
                for (BlockPos pos : this.getSpline().getBlockedPositions()) {
                    this.getWorld().m_141902_(pos, (BlockEntityType)CreateBlockEntityTypes.TUBE_STRUCTURE.get()).ifPresent(be -> be.setController(this.getPos()));
                }
            }
            this.tubeBlockEntity.invalidateTubeRenderBoundingBox();
        }
    }

    public void destroy() {
        super.destroy();
        this.disconnect();
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        boolean hadSpline = this.spline != null;
        this.controller = false;
        this.middleControlPoints = Collections.emptyList();
        this.spline = null;
        if (nbt.m_128425_("OtherEndPos", 10)) {
            this.otherEndPos = this.getPos().m_121955_((Vec3i)NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("OtherEndPos")));
        }
        if (nbt.m_128425_("Points", 9)) {
            this.controller = true;
            this.initializationTicks = nbt.m_128451_("InitializationTicks");
            this.middleControlPoints = nbt.m_128437_("Points", 9).stream().map(t -> NBTHelper.readVec3((ListTag)t, this.getPos())).toList();
        }
        if (this.blockEntity.m_58898_() && hadSpline == (this.getSpline() == null)) {
            this.tubeBlockEntity.invalidateTubeRenderBoundingBox();
        }
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        if (this.otherEndPos != null) {
            nbt.m_128365_("OtherEndPos", (Tag)NbtUtils.m_129224_((BlockPos)this.otherEndPos.m_121996_((Vec3i)this.getPos())));
        }
        if (!this.controller || this.getSpline() == null) {
            return;
        }
        if (this.initializationTicks > 0) {
            nbt.m_128405_("InitializationTicks", this.initializationTicks);
        }
        ListTag pointsTag = new ListTag();
        this.getSpline().getMiddleControlPoints().forEach(p -> pointsTag.add((Object)NBTHelper.writeVec3(p, this.getPos())));
        nbt.m_128365_("Points", (Tag)pointsTag);
    }

    public BehaviourType<TubeBehaviour> getType() {
        return TYPE;
    }
}

