/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.data.reward;

import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.petrolpark.Petrolpark;
import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.data.loot.PetrolparkLootContextParams;
import com.petrolpark.data.reward.IReward;
import com.petrolpark.data.reward.RewardType;
import com.petrolpark.shop.Shop;
import com.petrolpark.shop.TeamShopsData;
import com.petrolpark.team.ITeam;
import com.petrolpark.team.data.ITeamDataType;
import com.petrolpark.team.data.TeamDataTypes;
import java.util.Collections;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class GrantShopXPReward
implements IReward {
    public final ResourceLocation shopRL;
    public final NumberProvider amount;

    public GrantShopXPReward(ResourceLocation shopRL, NumberProvider amount) {
        this.shopRL = shopRL;
        this.amount = amount;
    }

    @Override
    public void reward(LootContext context, float multiplier) {
        ITeam team = (ITeam)context.m_165124_(PetrolparkLootContextParams.TEAM);
        if (team != null) {
            Shop shop = (Shop)context.m_78952_().m_9598_().m_175515_(PetrolparkRegistries.Keys.SHOP).m_7745_(this.shopRL);
            if (shop == null) {
                Petrolpark.LOGGER.warn("Unknown Shop: " + this.shopRL);
            }
            ((TeamShopsData)team.getTeamData((ITeamDataType)TeamDataTypes.SHOPS.get())).grantXP(shop, this.amount.m_142683_(context));
        }
    }

    @Override
    public void render(GuiGraphics graphics) {
        throw new UnsupportedOperationException("Unimplemented method 'render'");
    }

    @Override
    public Component getName() {
        throw new UnsupportedOperationException("Unimplemented method 'getName'");
    }

    @Override
    public RewardType getType() {
        throw new UnsupportedOperationException("Unimplemented method 'getType'");
    }

    public Set<LootContextParam<?>> m_6231_() {
        return Sets.union(Collections.singleton(PetrolparkLootContextParams.TEAM), (Set)this.amount.m_6231_());
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<GrantShopXPReward> {
        public void serialize(JsonObject json, GrantShopXPReward value, JsonSerializationContext serializationContext) {
            json.addProperty("shop", value.shopRL.toString());
            json.add("amount", serializationContext.serialize((Object)value.amount, NumberProvider.class));
        }

        public GrantShopXPReward deserialize(JsonObject json, JsonDeserializationContext deserializationContext) {
            return new GrantShopXPReward(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"shop")), (NumberProvider)GsonHelper.m_13836_((JsonObject)json, (String)"amount", (JsonDeserializationContext)deserializationContext, NumberProvider.class));
        }
    }
}

