/*
 * Decompiled with CFR 0.152.
 */
package nl.teamdiopside.separatedleaves;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import nl.teamdiopside.separatedleaves.SeparatedLeaves;

public class Reload {
    public static final List<LeavesRule> LEAVES_RULES = new CopyOnWriteArrayList<LeavesRule>();
    public static final Set<String> BIOME_NAMESPACES = new CopyOnWriteArraySet<String>();

    public static void reload(ResourceManager resourceManager) {
        Reload.apply(Reload.getJsons(resourceManager));
    }

    public static void apply(Map<ResourceLocation, JsonElement> jsons) {
        LEAVES_RULES.clear();
        ArrayList<LeavesRule> rules = new ArrayList<LeavesRule>();
        HashSet<String> biomeNamespaces = new HashSet<String>();
        ArrayList<JsonFile> files = new ArrayList<JsonFile>();
        jsons.forEach((key, json) -> files.add(new JsonFile((ResourceLocation)key, (JsonElement)json)));
        files.sort(Comparator.comparing(jsonFile -> jsonFile.key().toString()));
        for (JsonFile file : files) {
            ResourceLocation key2 = file.key();
            JsonElement json2 = file.json();
            if (!Platform.getModIds().contains(key2.m_135827_())) continue;
            biomeNamespaces.add(key2.m_135827_());
            try {
                Set<Block> leaves = Reload.getBlocks(key2, json2, "leaves");
                Set<Block> logs = Reload.getBlocks(key2, json2, "logs");
                if (leaves.isEmpty() || logs.isEmpty()) continue;
                rules.add(new LeavesRule(leaves, logs));
                SeparatedLeaves.LOGGER.info("Loaded Separated Leaves file {}", (Object)key2);
            }
            catch (Exception e) {
                SeparatedLeaves.LOGGER.error("Failed to parse JSON object for leaves rule {}.json, Error: {}", (Object)key2, (Object)e);
            }
        }
        LEAVES_RULES.addAll(rules);
        BIOME_NAMESPACES.addAll(biomeNamespaces);
    }

    public static Set<Block> getBlocks(ResourceLocation key, JsonElement json, String string) {
        HashSet<Block> blocks = new HashSet<Block>();
        for (JsonElement jsonElement : json.getAsJsonObject().get(string).getAsJsonArray()) {
            if (jsonElement.getAsString().startsWith("#")) {
                TagKey blockTagKey = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(jsonElement.getAsString().replace("#", "")));
                for (Holder blockHolder : BuiltInRegistries.f_256975_.m_203561_(blockTagKey)) {
                    blocks.add((Block)blockHolder.m_203334_());
                }
                continue;
            }
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(jsonElement.getAsString()));
            if (block == Blocks.f_50016_ && !jsonElement.getAsString().replace("minecraft:", "").equals("air")) {
                SeparatedLeaves.LOGGER.error("Block \"{}\" from {} does not exist!", (Object)jsonElement.getAsString(), (Object)key);
                continue;
            }
            blocks.add(block);
        }
        return blocks;
    }

    public static Map<ResourceLocation, JsonElement> getJsons(ResourceManager resourceManager) {
        String directory = "separated_leaves";
        Gson gson = new Gson();
        HashMap map = Maps.newHashMap();
        SimpleJsonResourceReloadListener.m_278771_((ResourceManager)resourceManager, (String)directory, (Gson)gson, (Map)map);
        return map;
    }

    public record JsonFile(ResourceLocation key, JsonElement json) {
    }

    public record LeavesRule(Set<Block> leaves, Set<Block> logs) {
    }
}

