/*
 * Decompiled with CFR 0.152.
 */
package fuffles.tactical_fishing.integration.jei;

import fuffles.tactical_fishing.common.item.crafting.FishingRecipe;
import fuffles.tactical_fishing.integration.jei.TacticalPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;

public class FishingRecipeCategory
implements IRecipeCategory<FishingRecipe> {
    private static final ResourceLocation FISHING_ATLAS = new ResourceLocation("tactical_fishing", "textures/gui/fishing_recipe_atlas.png");
    private final IDrawable icon;
    private final IDrawable bg;
    private final IDrawable bobber;

    public FishingRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)Items.f_42523_.m_7968_());
        this.bg = guiHelper.drawableBuilder(FISHING_ATLAS, 0, 0, 125, 41).setTextureSize(128, 64).build();
        this.bobber = guiHelper.drawableBuilder(FISHING_ATLAS, 0, 48, 8, 13).setTextureSize(128, 64).build();
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.recipe_category.tactical_fishing.fishing");
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.bg;
    }

    public RecipeType<FishingRecipe> getRecipeType() {
        return TacticalPlugin.FISHING;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FishingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients(recipe.getIngredient());
        builder.addSlot(RecipeIngredientRole.CATALYST, 50, 1).addIngredients(recipe.getRod());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 79, 24).addIngredients(recipe.getCatch())).setOverlay(this.bobber, 4, -9);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 1).addItemStack(recipe.m_8043_(null));
    }
}

