/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei;

import blusunrize.immersiveengineering.client.gui.FluidSorterScreen;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraftforge.fluids.FluidStack;

public class FluidSorterGhostHandler
implements IGhostIngredientHandler<FluidSorterScreen> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(FluidSorterScreen gui, ITypedIngredient<I> ingredient, boolean doStart) {
        Optional ingr = ingredient.getIngredient((IIngredientType)ForgeTypes.FLUID_STACK);
        if (ingr.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int side = 0; side < 6; ++side) {
            for (int slot = 0; slot < 8; ++slot) {
                builder.add((Object)new GhostFluidTarget(side, slot, gui));
            }
        }
        return builder.build();
    }

    public void onComplete() {
    }

    private static class GhostFluidTarget
    implements IGhostIngredientHandler.Target<FluidStack> {
        final int side;
        final int slot;
        final FluidSorterScreen gui;
        Rect2i area;
        int lastGuiLeft;
        int lastGuiTop;

        public GhostFluidTarget(int side, int slot, FluidSorterScreen gui) {
            this.side = side;
            this.slot = slot;
            this.gui = gui;
            this.initRectangle();
        }

        private void initRectangle() {
            int x = 4 + this.side / 2 * 58 + (this.slot < 3 ? this.slot * 18 : (this.slot > 4 ? (this.slot - 5) * 18 : (this.slot == 3 ? 0 : 36)));
            int y = 22 + this.side % 2 * 76 + (this.slot < 3 ? 0 : (this.slot > 4 ? 36 : 18));
            this.area = new Rect2i(this.gui.getGuiLeft() + x, this.gui.getGuiTop() + y, 16, 16);
            this.lastGuiLeft = this.gui.getGuiLeft();
            this.lastGuiTop = this.gui.getGuiTop();
        }

        public Rect2i getArea() {
            if (this.lastGuiLeft != this.gui.getGuiLeft() || this.lastGuiTop != this.gui.getGuiTop()) {
                this.initRectangle();
            }
            return this.area;
        }

        public void accept(FluidStack ingredient) {
            this.gui.setFluidInSlot(this.side, this.slot, ingredient);
        }
    }
}

