/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual.gui;

import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.Tree;
import blusunrize.lib.manual.gui.ClickableList;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Stack;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ManualScreen
extends Screen {
    private Minecraft mc = Minecraft.m_91087_();
    private float scaleFactor = 1.0f;
    private int xSize = 186;
    private int ySize = 198;
    private int guiLeft;
    private int guiTop;
    private List<Button> pageButtons = new ArrayList<Button>();
    @Nonnull
    public Tree.AbstractNode<ResourceLocation, ManualEntry> currentNode;
    public Stack<ManualInstance.ManualLink> previousSelectedEntry = new Stack();
    public int page;
    public static ManualScreen lastActiveManual;
    ManualInstance manual;
    ResourceLocation texture;
    private double[] lastClick;
    private double[] lastDrag;
    private EditBox searchField;
    private ClickableList entryList;
    private ClickableList suggestionList;
    private final boolean setLastActive;

    public ManualScreen(ManualInstance manual, ResourceLocation texture) {
        this(manual, texture, true);
    }

    public ManualScreen(ManualInstance manual, ResourceLocation texture, boolean setLastActive) {
        super((Component)Component.m_237113_((String)"manual"));
        this.manual = manual;
        this.currentNode = manual.getRoot();
        this.texture = texture;
        this.setLastActive = setLastActive;
    }

    public ManualEntry getCurrentPage() {
        return this.currentNode.getLeafData();
    }

    public void setCurrentNode(@Nonnull Tree.AbstractNode<ResourceLocation, ManualEntry> entry) {
        this.currentNode = entry;
        if (this.currentNode.isLeaf()) {
            this.manual.openEntry(this.currentNode.getLeafData());
        }
    }

    public ManualInstance getManual() {
        return this.manual;
    }

    public void m_7856_() {
        Window res = this.mc.m_91268_();
        double oldGuiScale = res.m_85385_(((Integer)this.mc.f_91066_.m_231928_().m_231551_()).intValue(), this.mc.m_91390_());
        int guiScaleInt = Math.min(this.manual.getGuiRescale(), this.getMinecraft().m_91268_().m_85385_(0, true));
        double newGuiScale = res.m_85385_(guiScaleInt, true);
        if (guiScaleInt > 0 && newGuiScale != oldGuiScale) {
            this.scaleFactor = (float)newGuiScale / (float)res.m_85449_();
            res.m_85378_(newGuiScale);
            this.f_96543_ = res.m_85445_();
            this.f_96544_ = res.m_85446_();
            res.m_85378_(oldGuiScale);
        } else {
            this.scaleFactor = 1.0f;
        }
        this.manual.openManual();
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        boolean textField = false;
        this.pageButtons.clear();
        if (this.currentNode.isLeaf()) {
            this.currentNode.getLeafData().addButtons(this, this.guiLeft + 32, this.guiTop + 28, this.page, this.pageButtons);
            for (Button b : this.pageButtons) {
                this.m_142416_((GuiEventListener)b);
            }
        } else {
            ArrayList<Tree.AbstractNode<ResourceLocation, ManualEntry>> children = new ArrayList<Tree.AbstractNode<ResourceLocation, ManualEntry>>();
            for (Tree.AbstractNode<ResourceLocation, ManualEntry> node : this.currentNode.getChildren()) {
                if (!this.manual.showNodeInList(node)) continue;
                children.add(node);
            }
            Consumer<Tree.AbstractNode<ResourceLocation, ManualEntry>> openEntry = sel -> {
                if (sel != null) {
                    this.previousSelectedEntry.clear();
                    this.setCurrentNode((Tree.AbstractNode<ResourceLocation, ManualEntry>)sel);
                    this.fullInit();
                }
            };
            this.entryList = new ClickableList(this, this.guiLeft + 40, this.guiTop + 20, 100, 168, 1.0f, children, openEntry);
            this.m_142416_((GuiEventListener)this.entryList);
            this.suggestionList = new ClickableList(this, this.guiLeft + 180, this.guiTop + 138, 100, 80, 1.0f, new ArrayList<Tree.AbstractNode<ResourceLocation, ManualEntry>>(), openEntry);
            this.suggestionList.f_93624_ = false;
            this.m_142416_((GuiEventListener)this.suggestionList);
            textField = true;
        }
        if (this.currentNode.getSuperNode() != null) {
            this.m_142416_((GuiEventListener)new GuiButtonManualNavigation(this, this.guiLeft + 24, this.guiTop + 10, 10, 10, 0, btn -> {
                if (this.currentNode.isLeaf() && !this.previousSelectedEntry.isEmpty()) {
                    this.previousSelectedEntry.pop().changePage(this, false);
                } else if (this.currentNode.getSuperNode() != null) {
                    this.setCurrentNode(this.currentNode.getSuperNode());
                }
                this.page = 0;
                this.fullInit();
            }));
        }
        if (textField) {
            this.searchField = new EditBox(this.f_96547_, this.guiLeft + 166, this.guiTop + 78, 120, 12, (Component)Component.m_237119_());
            this.searchField.m_94202_(-1);
            this.searchField.m_94205_(-1);
            this.searchField.m_94182_(false);
            this.searchField.m_94199_(17);
            this.searchField.m_93692_(true);
            this.searchField.m_94190_(false);
        } else if (this.searchField != null) {
            this.searchField = null;
        }
        if (this.setLastActive) {
            lastActiveManual = this;
        }
    }

    public void fullInit() {
        super.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float f) {
        PoseStack transform = graphics.m_280168_();
        transform.m_85836_();
        if (this.scaleFactor != 1.0f) {
            transform.m_85841_(this.scaleFactor, this.scaleFactor, this.scaleFactor);
            mouseX = (int)((float)mouseX / this.scaleFactor);
            mouseY = (int)((float)mouseY / this.scaleFactor);
        }
        this.manual.entryRenderPre();
        graphics.m_280218_(this.texture, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        if (this.searchField != null) {
            int l = this.searchField.m_94155_().length() * 6;
            if (l > 20) {
                graphics.m_280218_(this.texture, this.guiLeft + 166, this.guiTop + 74, 136 + (120 - l), 238, l, 18);
            }
            if (this.suggestionList.f_93624_) {
                graphics.m_280218_(this.texture, this.guiLeft + 174, this.guiTop + 100, 214, 212, 16, 26);
                int h = this.suggestionList.m_93694_();
                int w = 76;
                graphics.m_280218_(this.texture, this.guiLeft + 174, this.guiTop + 116, 230, 212, 16, 16);
                graphics.m_280218_(this.texture, this.guiLeft + 174, this.guiTop + 132 + h, 230, 228, 16, 10);
                graphics.m_280218_(this.texture, this.guiLeft + 190 + w, this.guiTop + 116, 246, 212, 10, 16);
                graphics.m_280218_(this.texture, this.guiLeft + 190 + w, this.guiTop + 132 + h, 246, 228, 10, 10);
                for (int hh = 0; hh < h; ++hh) {
                    graphics.m_280218_(this.texture, this.guiLeft + 174, this.guiTop + 132 + hh, 230, 228, 16, 1);
                    for (int ww = 0; ww < w; ++ww) {
                        graphics.m_280218_(this.texture, this.guiLeft + 190 + ww, this.guiTop + 132 + hh, 246, 228, 1, 1);
                    }
                    graphics.m_280218_(this.texture, this.guiLeft + 190 + w, this.guiTop + 132 + hh, 246, 228, 10, 1);
                }
                for (int ww = 0; ww < w; ++ww) {
                    graphics.m_280218_(this.texture, this.guiLeft + 190 + ww, this.guiTop + 116, 246, 212, 1, 16);
                    graphics.m_280218_(this.texture, this.guiLeft + 190 + ww, this.guiTop + 132 + h, 246, 228, 1, 10);
                }
            }
        }
        if (this.currentNode.isLeaf()) {
            ManualEntry selectedEntry = this.currentNode.getLeafData();
            boolean b0 = (mouseX -= this.guiLeft) > 32 && mouseX < 49 && (mouseY -= this.guiTop) > 179 && mouseY < 189;
            boolean b1 = mouseX > 135 && mouseX < 152 && mouseY > 179 && mouseY < 189;
            RenderSystem.enableBlend();
            if (this.page > 0) {
                graphics.m_280218_(this.texture, this.guiLeft + 32, this.guiTop + 179, 0, 216 + (b0 ? 20 : 0), 16, 10);
            }
            if (this.page < selectedEntry.getPageCount() - 1) {
                graphics.m_280218_(this.texture, this.guiLeft + 136, this.guiTop + 179, 0, 226 + (b1 ? 20 : 0), 16, 10);
            }
            this.manual.titleRenderPre();
            this.drawCenteredStringScaled(graphics, this.manual.fontRenderer(), ChatFormatting.BOLD + selectedEntry.getTitle(), this.guiLeft + this.xSize / 2, this.guiTop + 14, this.manual.getTitleColour(), true);
            this.drawCenteredStringScaled(graphics, this.manual.fontRenderer(), this.manual.formatEntrySubtext(selectedEntry.getSubtext()), this.guiLeft + this.xSize / 2, this.guiTop + 22, this.manual.getSubTitleColour(), true);
            this.drawCenteredStringScaled(graphics, this.manual.fontRenderer(), ChatFormatting.BOLD.toString() + (this.page + 1), this.guiLeft + this.xSize / 2, this.guiTop + 183, this.manual.getPagenumberColour(), false);
            this.manual.titleRenderPost();
            selectedEntry.renderPage(graphics, this, this.guiLeft + 32, this.guiTop + 28, mouseX - 32, mouseY - 28);
            mouseX += this.guiLeft;
            mouseY += this.guiTop;
        } else {
            String title = ManualUtils.getTitleForNode(this.currentNode, this.manual);
            this.manual.titleRenderPre();
            this.drawCenteredStringScaled(graphics, this.manual.fontRenderer(), ChatFormatting.BOLD + title, this.guiLeft + this.xSize / 2, this.guiTop + 12, this.manual.getTitleColour(), true);
            this.manual.titleRenderPost();
        }
        if (this.searchField != null) {
            this.searchField.m_88315_(graphics, mouseX, mouseY, f);
            if (this.suggestionList.f_93624_) {
                graphics.m_280488_(this.manual.fontRenderer(), "It looks like you meant:", this.guiLeft + 180, this.guiTop + 128, this.manual.getTextColour());
            }
        }
        for (Button btn : this.pageButtons) {
            btn.m_88315_(graphics, mouseX, mouseY, f);
        }
        super.m_88315_(graphics, mouseX, mouseY, f);
        RenderSystem.enableBlend();
        this.manual.entryRenderPost();
        transform.m_85849_();
    }

    public void m_7861_() {
        this.manual.closeManual();
        super.m_7861_();
    }

    private void drawCenteredStringScaled(GuiGraphics graphics, Font fr, String s, int x, int y, int colour, boolean shadow) {
        int xx = (int)Math.floor((double)x - (double)fr.m_92895_(s) / 2.0);
        double d = y;
        Objects.requireNonNull(fr);
        int yy = (int)Math.floor(d - 9.0 / 2.0);
        graphics.m_280056_(fr, s, xx, yy, colour, shadow);
    }

    @SubscribeEvent
    public static void appendLinkToTooltip(ItemTooltipEvent ev) {
        ManualInstance.ManualLink link;
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (!(screen instanceof ManualScreen)) {
            return;
        }
        ManualScreen manualScreen = (ManualScreen)screen;
        if (!manualScreen.currentNode.isLeaf()) {
            return;
        }
        ItemStack stack = ev.getItemStack();
        if (manualScreen.currentNode.getLeafData().getHighlightedStack(manualScreen.page) == stack && (link = manualScreen.manual.getManualLink(stack)) != null) {
            ev.getToolTip().add(Component.m_237113_((String)manualScreen.manual.formatLink(link)));
        }
    }

    public boolean m_6050_(double x, double y, double wheel) {
        super.m_6050_(x, y, wheel);
        if (wheel != 0.0 && this.currentNode.isLeaf()) {
            if (wheel > 0.0 && this.page > 0) {
                --this.page;
                this.fullInit();
                return true;
            }
            if (wheel < 0.0 && this.page < this.currentNode.getLeafData().getPageCount() - 1) {
                ++this.page;
                this.fullInit();
                return true;
            }
        }
        return false;
    }

    public boolean m_6375_(double mx, double my, int button) {
        mx /= (double)this.scaleFactor;
        my /= (double)this.scaleFactor;
        if (button == 0 && this.currentNode.isLeaf()) {
            ManualEntry selectedEntry = this.currentNode.getLeafData();
            double mxRelative = mx - (double)this.guiLeft;
            double myRelative = my - (double)this.guiTop;
            if (this.page > 0 && mxRelative > 32.0 && mxRelative < 49.0 && myRelative > 179.0 && myRelative < 189.0) {
                --this.page;
                this.fullInit();
                return true;
            }
            if (this.page < selectedEntry.getPageCount() - 1 && mxRelative > 135.0 && mxRelative < 152.0 && myRelative > 179.0 && myRelative < 189.0) {
                ++this.page;
                this.fullInit();
                return true;
            }
            ItemStack highlighted = selectedEntry.getHighlightedStack(this.page);
            if (!highlighted.m_41619_()) {
                ManualInstance.ManualLink link = this.getManual().getManualLink(highlighted);
                if (link != null) {
                    link.changePage(this, true);
                }
                return true;
            }
        } else if (button == 1) {
            if (this.searchField != null && !this.searchField.m_94155_().isEmpty()) {
                this.searchField.m_94144_("");
            } else if (this.currentNode.isLeaf() && !this.previousSelectedEntry.isEmpty()) {
                this.previousSelectedEntry.pop().changePage(this, false);
            } else if (this.currentNode.getSuperNode() != null) {
                this.setCurrentNode(this.currentNode.getSuperNode());
                this.page = 0;
            }
            this.fullInit();
            return true;
        }
        this.lastClick = new double[]{mx - (double)this.guiLeft, my - (double)this.guiTop};
        if (super.m_6375_(mx, my, button)) {
            return true;
        }
        if (this.searchField != null) {
            this.searchField.m_6375_(mx, my, button);
        }
        return false;
    }

    public boolean m_6348_(double mx, double my, int action) {
        this.lastClick = null;
        this.lastDrag = null;
        return super.m_6348_(mx, my, action);
    }

    public boolean m_7979_(double mx, double my, int button, double deltaX, double deltaY) {
        mx /= (double)this.scaleFactor;
        my /= (double)this.scaleFactor;
        if (this.lastClick != null && this.currentNode.isLeaf()) {
            if (this.lastDrag == null) {
                this.lastDrag = new double[]{mx - (double)this.guiLeft, my - (double)this.guiTop};
            }
            this.currentNode.getLeafData().mouseDragged(this, this.guiLeft + 32, this.guiTop + 28, this.lastClick[0], this.lastClick[1], mx - (double)this.guiLeft, my - (double)this.guiTop, this.lastDrag[0], this.lastDrag[1], button);
            this.lastDrag = new double[]{mx - (double)this.guiLeft, my - (double)this.guiTop};
            return true;
        }
        return false;
    }

    public boolean m_5534_(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.searchField != null && this.searchField.m_5534_(p_charTyped_1_, p_charTyped_2_)) {
            this.updateSearch();
            return true;
        }
        return super.m_5534_(p_charTyped_1_, p_charTyped_2_);
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.searchField != null && this.searchField.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            this.updateSearch();
            return true;
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    private void updateSearch() {
        String search = this.searchField.m_94155_();
        if (search.trim().isEmpty()) {
            this.suggestionList.f_93624_ = false;
            this.fullInit();
        } else {
            search = search.toLowerCase(Locale.ENGLISH);
            ArrayList<Tree.AbstractNode<ResourceLocation, ManualEntry>> lHeaders = new ArrayList<Tree.AbstractNode<ResourceLocation, ManualEntry>>();
            HashSet lSpellcheck = new HashSet();
            String searchFinal = search;
            this.manual.getAllEntriesAndCategories().forEach(node -> {
                if (this.manual.showNodeInList((Tree.AbstractNode<ResourceLocation, ManualEntry>)node)) {
                    String title = ManualUtils.getTitleForNode(node, this.manual).toLowerCase(Locale.ENGLISH);
                    if (title.contains(searchFinal)) {
                        lHeaders.add((Tree.AbstractNode<ResourceLocation, ManualEntry>)node);
                    } else {
                        lSpellcheck.add(node);
                    }
                }
            });
            List<Tree.AbstractNode<ResourceLocation, ManualEntry>> lCorrections = ManualUtils.getPrimitiveSpellingCorrections(search, lSpellcheck, 4, e -> ManualUtils.getTitleForNode(e, this.manual));
            for (Tree.AbstractNode node2 : lSpellcheck) {
                if (lCorrections.contains(node2) || !node2.isLeaf() || !((ManualEntry)node2.getLeafData()).listForSearch(search)) continue;
                lHeaders.add(node2);
                lCorrections.add(node2);
                break;
            }
            this.entryList.setEntries(lHeaders);
            if (!lCorrections.isEmpty()) {
                this.suggestionList.setEntries(lCorrections);
            }
            this.suggestionList.f_93624_ = !lCorrections.isEmpty();
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

