/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.client.DefaultAccessoryRenderer;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AccessoriesRendererRegistry {
    private static final Map<Item, Supplier<AccessoryRenderer>> RENDERERS = new HashMap<Item, Supplier<AccessoryRenderer>>();
    private static final Map<Item, AccessoryRenderer> CACHED_RENDERERS = new HashMap<Item, AccessoryRenderer>();

    public static void registerRenderer(Item item, Supplier<AccessoryRenderer> renderer) {
        RENDERERS.put(item, renderer);
    }

    public static void registerNoRenderer(Item item) {
        RENDERERS.put(item, () -> null);
    }

    @Nullable
    public static AccessoryRenderer getRender(ItemStack stack) {
        TriState shouldOverride = AccessoriesDataComponents.readOrDefault(AccessoriesDataComponents.RENDER_OVERRIDE, stack).defaultRenderOverride();
        if (shouldOverride != TriState.DEFAULT) {
            if (shouldOverride.get()) {
                return DefaultAccessoryRenderer.INSTANCE;
            }
            if (AccessoriesAPI.getOrDefaultAccessory(stack.m_41720_()) == AccessoriesAPI.defaultAccessory()) {
                return null;
            }
        }
        return AccessoriesRendererRegistry.getRender(stack.m_41720_());
    }

    @Nullable
    public static AccessoryRenderer getRender(Item item) {
        AccessoryRenderer renderer = CACHED_RENDERERS.getOrDefault(item, DefaultAccessoryRenderer.INSTANCE);
        if (renderer == null && Accessories.getConfig().clientData.forceNullRenderReplacement) {
            renderer = DefaultAccessoryRenderer.INSTANCE;
        }
        return renderer;
    }

    public static void onReload() {
        CACHED_RENDERERS.clear();
        RENDERERS.forEach((item, supplier) -> CACHED_RENDERERS.put((Item)item, (AccessoryRenderer)supplier.get()));
    }
}

