/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.AccessoryNest;
import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.EquipAction;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.events.AccessoryChangeCallback;
import io.wispforest.accessories.api.events.AllowEntityModificationCallback;
import io.wispforest.accessories.api.events.ContainersChangeCallback;
import io.wispforest.accessories.api.events.OnDeathCallback;
import io.wispforest.accessories.api.events.OnDropCallback;
import io.wispforest.accessories.api.events.SlotStateChange;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.client.AccessoriesMenu;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.impl.AccessoriesCapabilityImpl;
import io.wispforest.accessories.impl.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.AccessoryNestUtils;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import io.wispforest.accessories.impl.PlayerEquipControl;
import io.wispforest.accessories.networking.base.BaseNetworkHandler;
import io.wispforest.accessories.networking.client.SyncContainerData;
import io.wispforest.accessories.networking.client.SyncData;
import io.wispforest.accessories.networking.client.SyncEntireContainer;
import io.wispforest.accessories.utils.AttributeUtils;
import io.wispforest.endec.SerializationContext;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class AccessoriesEventHandler {
    public static boolean dataReloadOccurred = false;
    public static final TagKey<EntityType<?>> EQUIPMENT_MANAGEABLE = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)Accessories.of("equipment_manageable"));

    public static void onWorldTick(Level level) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        AccessoriesEventHandler.revalidatePlayersOnReload(serverLevel.m_7654_().m_6846_());
    }

    public static void revalidatePlayersOnReload(PlayerList playerList) {
        if (!dataReloadOccurred) {
            return;
        }
        for (ServerPlayer player : playerList.m_11314_()) {
            AccessoriesEventHandler.revalidatePlayer(player);
        }
        dataReloadOccurred = false;
    }

    public static void revalidatePlayer(ServerPlayer player) {
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)player);
        if (capability == null) {
            return;
        }
        Collection<SlotType> validSlotTypes = EntitySlotLoader.getEntitySlots((LivingEntity)player).values();
        for (AccessoriesContainer container : capability.getContainers().values()) {
            SlotType slotType = container.slotType();
            if (slotType != null && validSlotTypes.contains(slotType)) {
                Integer baseSize = ((AccessoriesContainerImpl)container).getBaseSize();
                if (baseSize == null || baseSize.intValue() != slotType.amount()) {
                    container.markChanged();
                    container.update();
                }
                ExpandedSimpleContainer stacks = container.getAccessories();
                ExpandedSimpleContainer cosmeticStacks = container.getCosmeticAccessories();
                for (int i = 0; i < container.getSize(); ++i) {
                    SlotReference reference = container.createReference(i);
                    AccessoriesEventHandler.handleInvalidStacks((Container)stacks, reference, player);
                    AccessoriesEventHandler.handleInvalidStacks((Container)cosmeticStacks, reference, player);
                }
                continue;
            }
            ExpandedSimpleContainer stacks = container.getAccessories();
            ExpandedSimpleContainer cosmeticStacks = container.getCosmeticAccessories();
            for (int i = 0; i < container.getSize(); ++i) {
                SlotReference reference = container.createReference(i);
                AccessoriesEventHandler.dropAndRemoveStack((Container)stacks, reference, player);
                AccessoriesEventHandler.dropAndRemoveStack((Container)cosmeticStacks, reference, player);
            }
        }
    }

    private static void handleInvalidStacks(Container container, SlotReference reference, ServerPlayer player) {
        boolean bl;
        boolean bl2 = bl = !AccessoriesAPI.canInsertIntoSlot(container.m_8020_(reference.slot()), reference);
        if (bl) {
            AccessoriesEventHandler.dropAndRemoveStack(container, reference, player);
        }
    }

    private static void dropAndRemoveStack(Container container, SlotReference reference, ServerPlayer player) {
        ItemStack stack = container.m_8020_(reference.slot());
        container.m_6836_(reference.slot(), ItemStack.f_41583_);
        AccessoriesInternals.giveItemToPlayer(player, stack);
    }

    public static void entityLoad(LivingEntity entity, Level level) {
        if (!level.m_5776_() || !(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)entity;
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)serverPlayer);
        if (capability == null) {
            return;
        }
        NbtMapCarrier carrier = NbtMapCarrier.of();
        ((AccessoriesHolderImpl)capability.getHolder()).write(carrier, SerializationContext.empty());
        AccessoriesInternals.getNetworkHandler().sendToTrackingAndSelf((Entity)serverPlayer, new SyncEntireContainer(capability.entity().m_19879_(), carrier));
    }

    public static void onTracking(LivingEntity entity, ServerPlayer serverPlayer) {
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability == null) {
            return;
        }
        NbtMapCarrier carrier = NbtMapCarrier.of();
        ((AccessoriesHolderImpl)capability.getHolder()).write(carrier, SerializationContext.empty());
        AccessoriesInternals.getNetworkHandler().sendToPlayer(serverPlayer, new SyncEntireContainer(capability.entity().m_19879_(), carrier));
    }

    public static void dataSync(@Nullable PlayerList list, @Nullable ServerPlayer player) {
        BaseNetworkHandler networkHandler = AccessoriesInternals.getNetworkHandler();
        SyncData syncPacket = SyncData.create();
        if (list != null && !list.m_11314_().isEmpty()) {
            AccessoriesEventHandler.revalidatePlayersOnReload(list);
            for (ServerPlayer playerEntry : list.m_11314_()) {
                networkHandler.sendToPlayer(playerEntry, syncPacket);
                AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)playerEntry);
                if (capability == null) {
                    return;
                }
                NbtMapCarrier carrier = NbtMapCarrier.of();
                ((AccessoriesHolderImpl)capability.getHolder()).write(carrier, SerializationContext.empty());
                networkHandler.sendToTrackingAndSelf((Entity)playerEntry, new SyncEntireContainer(capability.entity().m_19879_(), carrier));
                AbstractContainerMenu abstractContainerMenu = playerEntry.f_36096_;
                if (!(abstractContainerMenu instanceof AccessoriesMenu)) continue;
                AccessoriesMenu accessoriesMenu = (AccessoriesMenu)abstractContainerMenu;
                Accessories.openAccessoriesMenu((Player)playerEntry, accessoriesMenu.targetEntity());
            }
        } else if (player != null) {
            networkHandler.sendToPlayer(player, syncPacket);
            AccessoriesEventHandler.revalidatePlayer(player);
            AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)player);
            if (capability == null) {
                return;
            }
            NbtMapCarrier carrier = NbtMapCarrier.of();
            ((AccessoriesHolderImpl)capability.getHolder()).write(carrier, SerializationContext.empty());
            networkHandler.sendToPlayer(player, new SyncEntireContainer(capability.entity().m_19879_(), carrier));
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof AccessoriesMenu) {
                AccessoriesMenu accessoriesMenu = (AccessoriesMenu)abstractContainerMenu;
                Accessories.openAccessoriesMenu((Player)player, accessoriesMenu.targetEntity());
            }
        }
    }

    public static void onLivingEntityTick(LivingEntity entity) {
        List<ItemStack> invalidStacks;
        Object dirtyCosmeticStacks;
        if (entity.m_213877_()) {
            return;
        }
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability != null) {
            HashMap<String, ItemStack> dirtyStacks = new HashMap<String, ItemStack>();
            dirtyCosmeticStacks = new HashMap();
            AccessoryAttributeBuilder removedAttributesBuilder = new AccessoryAttributeBuilder();
            AccessoryAttributeBuilder addedAttributesBuilder = new AccessoryAttributeBuilder();
            for (Map.Entry<String, AccessoriesContainer> containerEntry : capability.getContainers().entrySet()) {
                AccessoriesContainer container = containerEntry.getValue();
                SlotType slotType = container.slotType();
                ExpandedSimpleContainer accessories = container.getAccessories();
                ExpandedSimpleContainer cosmetics = container.getCosmeticAccessories();
                for (int i = 0; i < accessories.m_6643_(); ++i) {
                    ItemStack lastCosmeticStack;
                    ItemStack currentCosmeticStack;
                    SlotReference slotReference = container.createReference(i);
                    String slotId = slotType.name() + "/" + i;
                    ItemStack currentStack = accessories.m_8020_(i);
                    if (!currentStack.m_41619_()) {
                        currentStack.m_41666_(entity.m_9236_(), (Entity)entity, -1, false);
                        Accessory accessory = AccessoriesAPI.getAccessory(currentStack);
                        if (accessory != null) {
                            accessory.tick(currentStack, slotReference);
                        }
                    }
                    ItemStack lastStack = accessories.getPreviousItem(i);
                    if (entity.m_9236_().m_5776_() || entity.m_21224_()) continue;
                    if (!ItemStack.m_41728_((ItemStack)currentStack, (ItemStack)lastStack)) {
                        container.getAccessories().setPreviousItem(i, currentStack.m_41777_());
                        dirtyStacks.put(slotId, currentStack.m_41777_());
                        if (!lastStack.m_41619_()) {
                            removedAttributesBuilder.addFrom(AccessoriesAPI.getAttributeModifiers(lastStack, slotReference));
                        }
                        if (!currentStack.m_41619_()) {
                            addedAttributesBuilder.addFrom(AccessoriesAPI.getAttributeModifiers(currentStack, slotReference));
                        }
                        boolean equipmentChange = false;
                        if (!ItemStack.m_41656_((ItemStack)currentStack, (ItemStack)lastStack) || accessories.isSlotFlagged(i)) {
                            AccessoriesAPI.getOrDefaultAccessory(lastStack.m_41720_()).onUnequip(lastStack, slotReference);
                            AccessoriesAPI.getOrDefaultAccessory(currentStack.m_41720_()).onEquip(currentStack, slotReference);
                            if (entity instanceof ServerPlayer) {
                                ServerPlayer serverPlayer = (ServerPlayer)entity;
                                if (!currentStack.m_41619_()) {
                                    Accessories.ACCESSORY_EQUIPPED.trigger(serverPlayer, currentStack, slotReference, false);
                                }
                                if (!lastStack.m_41619_()) {
                                    Accessories.ACCESSORY_UNEQUIPPED.trigger(serverPlayer, lastStack, slotReference, false);
                                }
                            }
                            equipmentChange = true;
                        }
                        ((AccessoryChangeCallback)AccessoryChangeCallback.EVENT.invoker()).onChange(lastStack, currentStack, slotReference, equipmentChange ? SlotStateChange.REPLACEMENT : SlotStateChange.MUTATION);
                        AccessoriesEventHandler.recursiveStackChange(slotReference, AccessoryNestUtils.getData(lastStack), AccessoryNestUtils.getData(currentStack));
                    }
                    if (ItemStack.m_41728_((ItemStack)(currentCosmeticStack = cosmetics.m_8020_(i)), (ItemStack)(lastCosmeticStack = container.getCosmeticAccessories().getPreviousItem(i)))) continue;
                    cosmetics.setPreviousItem(i, currentCosmeticStack.m_41777_());
                    ((HashMap)dirtyCosmeticStacks).put(slotId, currentCosmeticStack.m_41777_());
                    if (!(entity instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    if (!currentStack.m_41619_()) {
                        Accessories.ACCESSORY_EQUIPPED.trigger(serverPlayer, currentStack, slotReference, true);
                    }
                    if (lastStack.m_41619_()) continue;
                    Accessories.ACCESSORY_UNEQUIPPED.trigger(serverPlayer, lastStack, slotReference, true);
                }
            }
            if (entity.m_9236_().m_5776_()) {
                return;
            }
            AttributeUtils.removeTransientAttributeModifiers(entity, removedAttributesBuilder);
            AttributeUtils.addTransientAttributeModifiers(entity, addedAttributesBuilder);
            Map<AccessoriesContainer, Boolean> updatedContainers = ((AccessoriesCapabilityImpl)capability).getUpdatingInventories();
            capability.updateContainers();
            ((ContainersChangeCallback)ContainersChangeCallback.EVENT.invoker()).onChange(entity, capability, (Map<AccessoriesContainer, Boolean>)ImmutableMap.copyOf(updatedContainers));
            if (!(dirtyStacks.isEmpty() && ((HashMap)dirtyCosmeticStacks).isEmpty() && updatedContainers.isEmpty())) {
                SyncContainerData packet = SyncContainerData.of(entity, updatedContainers.keySet(), dirtyStacks, (Map<String, ItemStack>)dirtyCosmeticStacks);
                BaseNetworkHandler networkHandler = AccessoriesInternals.getNetworkHandler();
                networkHandler.sendToTrackingAndSelf((Entity)entity, packet);
            }
            updatedContainers.clear();
        }
        AccessoriesHolderImpl holder = (AccessoriesHolderImpl)AccessoriesInternals.getHolder(entity);
        if (holder.loadedFromTag && capability == null) {
            dirtyCosmeticStacks = new AccessoriesCapabilityImpl(entity);
        }
        if (!(invalidStacks = holder.invalidStacks).isEmpty()) {
            for (ItemStack invalidStack : invalidStacks) {
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    AccessoriesInternals.giveItemToPlayer(serverPlayer, invalidStack);
                    continue;
                }
                entity.m_19983_(invalidStack);
            }
            invalidStacks.clear();
        }
    }

    private static void recursiveStackChange(SlotReference slotReference, @Nullable AccessoryNestContainerContents lastNestData, @Nullable AccessoryNestContainerContents currentNestData) {
        List lastInnerStacks = lastNestData != null ? List.copyOf(lastNestData.getMap(slotReference).entrySet()) : List.of();
        List currentInnerStacks = currentNestData != null ? List.copyOf(currentNestData.getMap(slotReference).entrySet()) : List.of();
        int maxIterationLength = Math.max(lastInnerStacks.size(), currentInnerStacks.size());
        for (int i = 0; i < maxIterationLength; ++i) {
            SlotEntryReference currentRef;
            Map.Entry currentInnerEntry;
            Map.Entry lastInnerEntry = i < lastInnerStacks.size() ? (Map.Entry)lastInnerStacks.get(i) : null;
            Map.Entry entry = currentInnerEntry = i < currentInnerStacks.size() ? (Map.Entry)currentInnerStacks.get(i) : null;
            if (lastInnerEntry == null && currentInnerEntry != null) {
                currentRef = (SlotEntryReference)currentInnerEntry.getKey();
                ((AccessoryChangeCallback)AccessoryChangeCallback.EVENT.invoker()).onChange(ItemStack.f_41583_, currentRef.stack(), currentRef.reference(), SlotStateChange.REPLACEMENT);
                continue;
            }
            if (currentInnerEntry == null && lastInnerEntry != null) {
                SlotEntryReference lastRef = (SlotEntryReference)lastInnerEntry.getKey();
                ((AccessoryChangeCallback)AccessoryChangeCallback.EVENT.invoker()).onChange(lastRef.stack(), ItemStack.f_41583_, lastRef.reference(), SlotStateChange.REPLACEMENT);
                continue;
            }
            if (lastInnerEntry == null || currentInnerEntry == null) continue;
            currentRef = (SlotEntryReference)currentInnerEntry.getKey();
            SlotEntryReference lastRef = (SlotEntryReference)lastInnerEntry.getKey();
            SlotReference innerRef = lastRef.reference();
            ItemStack currentInnerStack = currentRef.stack();
            ItemStack lastInnerStack = lastRef.stack();
            ((AccessoryChangeCallback)AccessoryChangeCallback.EVENT.invoker()).onChange(lastInnerStack, currentInnerStack, innerRef, SlotStateChange.REPLACEMENT);
            AccessoriesEventHandler.recursiveStackChange(slotReference, AccessoryNestUtils.getData(lastInnerStack), AccessoryNestUtils.getData(currentInnerStack));
        }
    }

    public static void getTooltipData(@Nullable LivingEntity entity, ItemStack stack, List<Component> tooltip, TooltipFlag tooltipType) {
        Accessory accessory = AccessoriesAPI.getOrDefaultAccessory(stack);
        if (accessory != null) {
            if (entity != null && AccessoriesCapability.get(entity) != null) {
                AccessoriesEventHandler.addEntityBasedTooltipData(entity, accessory, stack, tooltip, tooltipType);
            }
            accessory.getExtraTooltip(stack, tooltip, tooltipType);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void addEntityBasedTooltipData(LivingEntity entity, Accessory accessory, ItemStack stack, List<Component> tooltip, TooltipFlag tooltipType) {
        void var17_22;
        HashSet<SlotType> validSlotTypes = new HashSet<SlotType>(AccessoriesAPI.getValidSlotTypes(entity, stack));
        Set validUniqueSlots = validSlotTypes.stream().filter(slotType -> UniqueSlotHandling.isUniqueSlot(slotType.name())).collect(Collectors.toSet());
        if (validSlotTypes.isEmpty()) {
            return;
        }
        validSlotTypes.removeAll(validUniqueSlots);
        Set sharedSlotTypes = SlotTypeLoader.getSlotTypes(entity.m_9236_()).values().stream().filter(slotType -> !UniqueSlotHandling.isUniqueSlot(slotType.name())).collect(Collectors.toSet());
        MutableComponent slotInfoComponent = Component.m_237113_((String)"");
        MutableComponent slotsComponent = Component.m_237113_((String)"");
        boolean allSlots = false;
        if (validSlotTypes.containsAll(sharedSlotTypes)) {
            slotsComponent.m_7220_((Component)Component.m_237115_((String)Accessories.translation("slot.any")));
            allSlots = true;
        } else {
            Set<SlotType> entitySlotTypes = Set.copyOf(EntitySlotLoader.getEntitySlots(entity).values());
            Sets.SetView differenceSlotTypes = Sets.difference(entitySlotTypes, validSlotTypes);
            if (differenceSlotTypes.size() < validSlotTypes.size()) {
                slotsComponent.m_7220_((Component)Component.m_237115_((String)Accessories.translation("slot.any")));
                slotsComponent.m_7220_((Component)Component.m_237113_((String)" except ").m_130940_(ChatFormatting.GRAY));
                slotTypesList = List.copyOf(differenceSlotTypes);
                for (i = 0; i < slotTypesList.size(); ++i) {
                    type = slotTypesList.get(i);
                    slotsComponent.m_7220_((Component)Component.m_237115_((String)type.translation()).m_130940_(ChatFormatting.RED));
                    if (i + 1 == slotTypesList.size()) continue;
                    slotsComponent.m_7220_((Component)Component.m_237113_((String)", ").m_130940_(ChatFormatting.GRAY));
                }
            } else {
                slotTypesList = List.copyOf(validSlotTypes);
                for (i = 0; i < slotTypesList.size(); ++i) {
                    type = slotTypesList.get(i);
                    slotsComponent.m_7220_((Component)Component.m_237115_((String)type.translation()));
                    if (i + 1 == slotTypesList.size()) continue;
                    slotsComponent.m_7220_((Component)Component.m_237113_((String)", ").m_130940_(ChatFormatting.GRAY));
                }
            }
        }
        if (!validUniqueSlots.isEmpty()) {
            List uniqueSlotTypes = List.copyOf(validUniqueSlots);
            for (int i = 0; i < uniqueSlotTypes.size(); ++i) {
                SlotType type = (SlotType)uniqueSlotTypes.get(i);
                slotsComponent.m_7220_((Component)Component.m_237115_((String)type.translation()));
                if (i + 1 == uniqueSlotTypes.size()) continue;
                slotsComponent.m_7220_((Component)Component.m_237113_((String)", ").m_130940_(ChatFormatting.GRAY));
            }
            validSlotTypes.addAll(validUniqueSlots);
        }
        String slotTranslationKey = "slot.tooltip." + (validSlotTypes.size() > 1 && !allSlots ? "plural" : "singular");
        slotInfoComponent.m_7220_((Component)Component.m_237115_((String)Accessories.translation(slotTranslationKey)).m_130940_(ChatFormatting.GRAY).m_7220_((Component)slotsComponent.m_130940_(ChatFormatting.BLUE)));
        tooltip.add((Component)slotInfoComponent);
        HashMap<SlotType, AccessoryAttributeBuilder> slotSpecificModifiers = new HashMap<SlotType, AccessoryAttributeBuilder>();
        AccessoryAttributeBuilder defaultModifiers = null;
        boolean allDuplicates = true;
        for (SlotType slotType2 : validSlotTypes) {
            SlotReference slotReference = SlotReference.of(entity, slotType2.name(), 0);
            AccessoryAttributeBuilder builder = AccessoriesAPI.getAttributeModifiers(stack, slotReference, true);
            slotSpecificModifiers.put(slotType2, builder);
            if (defaultModifiers == null) {
                defaultModifiers = builder;
                continue;
            }
            if (!allDuplicates) continue;
            allDuplicates = defaultModifiers.equals(builder);
        }
        HashMap<SlotType, Object> slotTypeToTooltipInfo = new HashMap<SlotType, Object>();
        if (allDuplicates) {
            if (!defaultModifiers.isEmpty()) {
                ArrayList attributeTooltip = new ArrayList();
                AccessoriesEventHandler.addAttributeTooltip(defaultModifiers.getAttributeModifiers(false), attributeTooltip);
                slotTypeToTooltipInfo.put(null, attributeTooltip);
            }
        } else {
            for (Map.Entry entry : slotSpecificModifiers.entrySet()) {
                SlotType slotType3 = (SlotType)entry.getKey();
                AccessoryAttributeBuilder modifiers = (AccessoryAttributeBuilder)entry.getValue();
                if (modifiers.isEmpty()) continue;
                ArrayList<Component> attributeTooltip = new ArrayList<Component>();
                AccessoriesEventHandler.addAttributeTooltip(modifiers.getAttributeModifiers(false), attributeTooltip);
                slotTypeToTooltipInfo.put(slotType3, attributeTooltip);
            }
        }
        HashMap<SlotType, List> extraAttributeTooltips = new HashMap<SlotType, List>();
        Object var17_21 = null;
        boolean allDuplicatesExtras = true;
        for (SlotType slotType4 : validSlotTypes) {
            ArrayList<Component> extraAttributeTooltip = new ArrayList<Component>();
            accessory.getAttributesTooltip(stack, slotType4, extraAttributeTooltip, tooltipType);
            extraAttributeTooltips.put(slotType4, extraAttributeTooltip);
            if (var17_22 == null) {
                ArrayList<Component> arrayList = extraAttributeTooltip;
                continue;
            }
            if (!allDuplicatesExtras) continue;
            allDuplicatesExtras = extraAttributeTooltip.equals(var17_22);
        }
        if (allDuplicatesExtras) {
            slotTypeToTooltipInfo.computeIfAbsent(null, s -> new ArrayList()).addAll(var17_22);
        } else {
            extraAttributeTooltips.forEach((slotType, components) -> slotTypeToTooltipInfo.computeIfAbsent((SlotType)slotType, s -> new ArrayList()).addAll(components));
        }
        if (slotTypeToTooltipInfo.containsKey(null)) {
            List anyTooltipInfo = (List)slotTypeToTooltipInfo.get(null);
            if (anyTooltipInfo.size() > 0) {
                tooltip.add(CommonComponents.f_237098_);
                tooltip.add((Component)Component.m_237115_((String)Accessories.translation("tooltip.attributes.any")).m_130940_(ChatFormatting.GRAY));
                tooltip.addAll(anyTooltipInfo);
            }
            slotTypeToTooltipInfo.remove(null);
        }
        if (!slotTypeToTooltipInfo.isEmpty()) {
            for (Map.Entry entry : slotTypeToTooltipInfo.entrySet()) {
                List tooltipData = (List)entry.getValue();
                if (tooltipData.size() == 0) continue;
                tooltip.add(CommonComponents.f_237098_);
                tooltip.add((Component)Component.m_237110_((String)Accessories.translation("tooltip.attributes.slot"), (Object[])new Object[]{Component.m_237115_((String)((SlotType)entry.getKey()).translation()).m_130940_(ChatFormatting.BLUE)}).m_130940_(ChatFormatting.GRAY));
                tooltip.addAll((Collection)entry.getValue());
            }
        }
    }

    private static void addAttributeTooltip(Multimap<Attribute, AttributeModifier> multimap, List<Component> tooltip) {
        if (multimap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : multimap.entries()) {
            AttributeModifier attributeModifier = (AttributeModifier)entry.getValue();
            double d = attributeModifier.m_22218_();
            if (attributeModifier.m_22217_() == AttributeModifier.Operation.MULTIPLY_BASE || attributeModifier.m_22217_() == AttributeModifier.Operation.MULTIPLY_TOTAL) {
                d *= 100.0;
            } else if (((Attribute)entry.getKey()).equals(Attributes.f_22278_)) {
                d *= 10.0;
            }
            Attribute key = (Attribute)entry.getKey();
            if (d > 0.0) {
                tooltip.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + attributeModifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d), Component.m_237115_((String)key.m_22087_())}).m_130940_(ChatFormatting.BLUE));
                continue;
            }
            if (!(d < 0.0)) continue;
            tooltip.add((Component)Component.m_237110_((String)("attribute.modifier.take." + attributeModifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d *= -1.0), Component.m_237115_((String)key.m_22087_())}).m_130940_(ChatFormatting.RED));
        }
    }

    public static List<ItemStack> onDeath(LivingEntity entity, DamageSource source) {
        boolean keepInv;
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        ArrayList<ItemStack> droppedStacks = new ArrayList<ItemStack>();
        GameRules gamerules = entity.m_9236_().m_46469_();
        boolean bl = keepInv = ((GameRules.BooleanValue)gamerules.m_46170_(GameRules.f_46133_)).m_46223_() || ((GameRules.BooleanValue)gamerules.m_46170_(Accessories.RULE_KEEP_ACCESSORY_INVENTORY)).m_46223_();
        if (capability != null) {
            for (Map.Entry<String, AccessoriesContainer> containerEntry : capability.getContainers().entrySet()) {
                SlotType slotType = containerEntry.getValue().slotType();
                DropRule slotDropRule = slotType != null ? slotType.dropRule() : DropRule.DEFAULT;
                AccessoriesContainer container = containerEntry.getValue();
                ExpandedSimpleContainer stacks = container.getAccessories();
                ExpandedSimpleContainer cosmeticStacks = container.getCosmeticAccessories();
                for (int i = 0; i < container.getSize(); ++i) {
                    ItemStack cosmeticStack;
                    SlotReference reference = SlotReference.of(entity, container.getSlotName(), i);
                    ItemStack stack = AccessoriesEventHandler.dropStack(slotDropRule, entity, stacks, reference, source, keepInv);
                    if (stack != null) {
                        droppedStacks.add(stack);
                    }
                    if ((cosmeticStack = AccessoriesEventHandler.dropStack(slotDropRule, entity, cosmeticStacks, reference, source, keepInv)) == null) continue;
                    droppedStacks.add(cosmeticStack);
                }
            }
            TriState result = ((OnDeathCallback)OnDeathCallback.EVENT.invoker()).shouldDrop(TriState.DEFAULT, entity, capability, source, droppedStacks);
            if (!result.orElse(true)) {
                return List.of();
            }
        }
        return droppedStacks;
    }

    @Nullable
    private static ItemStack dropStack(DropRule dropRule, LivingEntity entity, ExpandedSimpleContainer container, SlotReference reference, DamageSource source, boolean keepInvEnabled) {
        ItemStack stack = container.m_8020_(reference.slot());
        Accessory accessory = AccessoriesAPI.getAccessory(stack);
        if (accessory != null && dropRule == DropRule.DEFAULT) {
            dropRule = accessory.getDropRule(stack, reference, source);
        }
        if (accessory instanceof AccessoryNest) {
            AccessoryNest holdable = (AccessoryNest)accessory;
            List<Pair<DropRule, ItemStack>> dropRuleToStacks = holdable.getDropRules(stack, reference, source);
            for (int i = 0; i < dropRuleToStacks.size(); ++i) {
                boolean breakInnerStack;
                Pair<DropRule, ItemStack> rulePair = dropRuleToStacks.get(i);
                ItemStack innerStack = (ItemStack)rulePair.right();
                DropRule result = OnDropCallback.getAlternativeRule((DropRule)((Object)rulePair.left()), innerStack, reference, source);
                boolean bl = breakInnerStack = result == DropRule.DEFAULT && EnchantmentHelper.m_44924_((ItemStack)innerStack) || result == DropRule.DESTROY;
                if (!breakInnerStack) continue;
                holdable.setInnerStack(stack, i, ItemStack.f_41583_);
                container.m_6836_(reference.slot(), stack);
            }
        }
        DropRule result = OnDropCallback.getAlternativeRule(dropRule, stack, reference, source);
        boolean dropStack = true;
        if (result == DropRule.DESTROY) {
            container.m_6836_(reference.slot(), ItemStack.f_41583_);
            dropStack = false;
        } else if (result == DropRule.KEEP) {
            dropStack = false;
        } else if (result == DropRule.DEFAULT) {
            if (keepInvEnabled) {
                dropStack = false;
            } else if (EnchantmentHelper.m_44924_((ItemStack)stack)) {
                container.m_6836_(reference.slot(), ItemStack.f_41583_);
                dropStack = false;
            }
        }
        container.setPreviousItem(reference.slot(), ItemStack.f_41583_);
        if (!dropStack) {
            return null;
        }
        container.m_6836_(reference.slot(), ItemStack.f_41583_);
        return stack;
    }

    public static InteractionResultHolder<ItemStack> attemptEquipFromUse(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)player);
        if (capability != null && !player.m_5833_() && !stack.m_41619_()) {
            PlayerEquipControl equipControl = capability.getHolder().equipControl();
            boolean shouldAttemptEquip = false;
            if (equipControl == PlayerEquipControl.MUST_CROUCH && player.m_6144_()) {
                shouldAttemptEquip = true;
            } else if (equipControl == PlayerEquipControl.MUST_NOT_CROUCH && !player.m_6144_()) {
                shouldAttemptEquip = true;
            }
            if (shouldAttemptEquip) {
                Accessory accessory = AccessoriesAPI.getOrDefaultAccessory(stack);
                Pair<SlotReference, EquipAction> equipReference = capability.canEquipAccessory(stack, true);
                if (equipReference != null && accessory.canEquipFromUse(stack)) {
                    accessory.onEquipFromUse(stack, (SlotReference)equipReference.left());
                    ItemStack newHandStack = stack.m_41777_();
                    Optional<ItemStack> possibleSwappedStack = ((EquipAction)equipReference.second()).equipStack(newHandStack);
                    if (possibleSwappedStack.isPresent()) {
                        ItemStack swappedStack = possibleSwappedStack.get();
                        if (newHandStack.m_41619_()) {
                            newHandStack = swappedStack;
                        } else if (ItemStack.m_150942_((ItemStack)newHandStack, (ItemStack)swappedStack) && newHandStack.m_41613_() + swappedStack.m_41613_() <= newHandStack.m_41741_()) {
                            newHandStack.m_41769_(swappedStack.m_41613_());
                        } else {
                            player.m_36356_(swappedStack);
                        }
                    }
                    return InteractionResultHolder.m_19090_((Object)newHandStack);
                }
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public static InteractionResult attemptEquipOnEntity(Player player, InteractionHand hand, Entity entity) {
        LivingEntity targetEntity;
        ItemStack stack;
        block12: {
            block11: {
                stack = player.m_21120_(hand);
                if (!(entity instanceof LivingEntity)) break block11;
                targetEntity = (LivingEntity)entity;
                if (entity.m_6095_().m_204039_(EQUIPMENT_MANAGEABLE)) break block12;
            }
            return InteractionResult.PASS;
        }
        AccessoriesCapability targetCapability = AccessoriesCapability.get(targetEntity);
        boolean canModify = ((AllowEntityModificationCallback)AllowEntityModificationCallback.EVENT.invoker()).allowModifications(targetEntity, player, null).orElse(false);
        if (canModify && targetCapability != null && !player.m_5833_() && player.m_6144_()) {
            Accessory accessory = AccessoriesAPI.getOrDefaultAccessory(stack);
            Pair<SlotReference, EquipAction> equipReference = targetCapability.canEquipAccessory(stack, true);
            if (equipReference != null && accessory.canEquipFromUse(stack)) {
                if (!stack.m_41619_()) {
                    accessory.onEquipFromUse(stack, (SlotReference)equipReference.left());
                }
                ItemStack newHandStack = stack.m_41777_();
                Optional<ItemStack> possibleSwappedStack = ((EquipAction)equipReference.second()).equipStack(newHandStack);
                if (possibleSwappedStack.isPresent()) {
                    ItemStack swappedStack = possibleSwappedStack.get();
                    if (newHandStack.m_41619_()) {
                        newHandStack = swappedStack;
                    } else if (ItemStack.m_150942_((ItemStack)newHandStack, (ItemStack)swappedStack) && newHandStack.m_41613_() + swappedStack.m_41613_() <= newHandStack.m_41741_()) {
                        newHandStack.m_41769_(swappedStack.m_41613_());
                    } else {
                        player.m_36356_(swappedStack);
                    }
                }
                player.m_21008_(hand, newHandStack);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }
}

