/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.neoforge.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.client.AccessoriesClient;
import io.wispforest.accessories.client.AccessoriesRenderLayer;
import io.wispforest.accessories.compat.AccessoriesConfig;
import io.wispforest.accessories.impl.AccessoriesEventHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="accessories", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class AccessoriesClientForge {
    public static KeyMapping OPEN_SCREEN;

    @SubscribeEvent
    public static void onInitializeClient(FMLClientSetupEvent event) {
        AccessoriesClient.init();
        MinecraftForge.EVENT_BUS.addListener(AccessoriesClientForge::clientTick);
        MinecraftForge.EVENT_BUS.addListener(AccessoriesClientForge::itemTooltipCallback);
        MinecraftForge.EVENT_BUS.addListener(AccessoriesClientForge::onJoin);
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, parent) -> (Screen)AutoConfig.getConfigScreen(AccessoriesConfig.class, (Screen)parent).get()));
    }

    public static void onJoin(ClientPlayerNetworkEvent.LoggingIn loggingInEvent) {
        AccessoriesClient.handleConfigChangesSync(Accessories.getConfig());
    }

    @SubscribeEvent
    public static void initKeybindings(RegisterKeyMappingsEvent event) {
        OPEN_SCREEN = new KeyMapping("accessories.key.open_accessories_screen", 72, "accessories.key.category.accessories");
        event.register(OPEN_SCREEN);
    }

    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (!event.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        if (OPEN_SCREEN.m_90859_()) {
            AccessoriesClient.attemptToOpenScreen(Minecraft.m_91087_().f_91074_.m_6144_());
        }
    }

    public static void itemTooltipCallback(ItemTooltipEvent event) {
        Player player = event.getEntity();
        List stackTooltip = event.getToolTip();
        ArrayList<Component> tooltipData = new ArrayList<Component>();
        AccessoriesEventHandler.getTooltipData((LivingEntity)player, event.getItemStack(), tooltipData, event.getFlags());
        if (!tooltipData.isEmpty()) {
            stackTooltip.addAll(1, tooltipData);
        }
    }

    @SubscribeEvent
    public static void addRenderLayer(EntityRenderersEvent.AddLayers event) {
        for (EntityType entityType : ForgeRegistries.ENTITY_TYPES) {
            try {
                LivingEntityRenderer livingEntityRenderer = event.getRenderer(entityType);
                if (livingEntityRenderer == null || !(livingEntityRenderer.m_7200_() instanceof HumanoidModel)) continue;
                livingEntityRenderer.m_115326_(new AccessoriesRenderLayer(livingEntityRenderer));
            }
            catch (ClassCastException classCastException) {}
        }
        event.getSkins().forEach(model -> {
            LivingEntityRenderer livingEntityRenderer = event.getSkin(model);
            if (livingEntityRenderer != null && livingEntityRenderer.m_7200_() instanceof HumanoidModel) {
                livingEntityRenderer.m_115326_(new AccessoriesRenderLayer(livingEntityRenderer));
            }
        });
    }

    @SubscribeEvent
    public static void registerShader(RegisterShadersEvent event) {
        try {
            event.registerShader(new ShaderInstance(event.getResourceProvider(), AccessoriesClient.BLIT_SHADER_ID, DefaultVertexFormat.f_166850_), shaderInstance -> {
                AccessoriesClient.BLIT_SHADER = shaderInstance;
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

