/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementTextField
extends Element<Fragment<?>> {
    public static final Predicate<String> INTEGERS = s -> {
        if (s.isEmpty() || s.equals("-")) {
            return true;
        }
        try {
            if (s.contains(".")) {
                return false;
            }
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    public static final Predicate<String> NUMBERS = s -> {
        if (s.isEmpty() || s.equals("-")) {
            return true;
        }
        try {
            if (s.contains("f") || s.contains("d") || s.contains("F") || s.contains("D")) {
                return false;
            }
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    public static final Predicate<String> FILE_SAFE = s -> {
        String[] invalidChars;
        if (s.isEmpty()) {
            return true;
        }
        for (String c : invalidChars = new String[]{"\\", "/", ":", "*", "?", "\"", "<", ">", "|"}) {
            if (!s.contains(c)) continue;
            return false;
        }
        return !s.startsWith(".");
    };
    protected EditBox widget;
    private String defaultText = "";
    private int maxStringLength = Short.MAX_VALUE;
    private Predicate<String> validator = s -> true;
    private BiFunction<String, Integer, FormattedCharSequence> textFormatter = (s, cursorPos) -> FormattedCharSequence.m_13714_((String)s, (Style)Style.f_131099_);
    @Nullable
    private Consumer<String> responder;
    @Nullable
    private Consumer<String> enterResponder;
    private int lastLeft;
    private int lastTop;

    public ElementTextField(@NotNull Fragment parent) {
        super(parent);
    }

    public <T extends ElementTextField> T setDefaultText(String s) {
        this.defaultText = s;
        return (T)this;
    }

    public <T extends ElementTextField> T setValidator(Predicate<String> validator) {
        this.validator = validator;
        return (T)this;
    }

    public Predicate<String> getValidator() {
        return this.validator;
    }

    public <T extends ElementTextField> T setResponder(Consumer<String> responder) {
        this.responder = responder;
        return (T)this;
    }

    public Consumer<String> getResponder() {
        return this.responder;
    }

    public <T extends ElementTextField> T setEnterResponder(Consumer<String> responder) {
        this.enterResponder = responder;
        return (T)this;
    }

    public <T extends ElementTextField> T setMaxStringLength(int i) {
        this.maxStringLength = i;
        return (T)this;
    }

    public <T extends ElementTextField> T setTextFormatter(BiFunction<String, Integer, FormattedCharSequence> textFormatter) {
        this.textFormatter = textFormatter;
        return (T)this;
    }

    @Override
    public void init() {
        super.init();
        this.widget = new EditBox(this.getFontRenderer(), this.getLeft(), this.getTop(), this.width, this.height, (Component)Component.m_237113_((String)"Text Field"));
        this.widget.m_94199_(this.maxStringLength);
        this.widget.m_94144_(this.defaultText);
        this.widget.m_94153_(this.validator);
        this.widget.m_94151_(this.responder);
        this.widget.m_94149_(this.textFormatter);
        this.adjustWidget();
        this.lastLeft = this.getLeft();
        this.lastTop = this.getTop();
    }

    @Override
    public void tick() {
        super.tick();
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.m_5953_(mouseX, mouseY)) {
            ((Workspace)this.getWorkspace()).cursorState = Workspace.CURSOR_IBEAM;
        }
        if (this.lastLeft != this.getLeft() || this.lastTop != this.getTop()) {
            this.adjustWidget();
            this.lastLeft = this.getLeft();
            this.lastTop = this.getTop();
        }
        this.drawTextBox(graphics, mouseX, mouseY, partialTick);
    }

    public void drawTextBox(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.renderMinecraftStyle() > 0) {
            this.widget.m_94182_(true);
            this.widget.m_88315_(graphics, mouseX, mouseY, partialTick);
        } else {
            PoseStack stack = graphics.m_280168_();
            int[] colour = this.m_5953_(mouseX, mouseY) ? this.getTheme().elementInputBackgroundHover : this.getTheme().elementInputBackgroundInactive;
            this.fill(graphics, this.getTheme().elementInputBorder, 0);
            this.fill(graphics, colour, 1);
            this.widget.m_94182_(false);
            this.widget.m_88315_(graphics, mouseX, mouseY, partialTick);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void resize(Minecraft mc, int width, int height) {
        super.resize(mc, width, height);
        this.adjustWidget();
    }

    public void adjustWidget() {
        if (this.widget != null) {
            if (this.renderMinecraftStyle() > 0) {
                this.widget.m_252865_(this.getLeft() + 1);
                this.widget.m_253211_(this.getTop() + 1);
                this.widget.m_93674_(this.width - 2);
                this.widget.f_93619_ = this.height - 2;
            } else {
                this.widget.m_252865_(this.getLeft() + 5);
                int n = this.getTop() + 1;
                Objects.requireNonNull(this.getFontRenderer());
                this.widget.m_253211_(n + (this.height - 9) / 2);
                this.widget.m_93674_(this.width - 6);
                this.widget.f_93619_ = this.height - 2;
            }
        }
    }

    public boolean m_7933_(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        boolean flag = super.m_7933_(keyCode, p_keyPressed_2_, p_keyPressed_3_);
        if ((keyCode == 257 || keyCode == 335) && this.enterResponder != null) {
            this.enterResponder.accept(this.getText());
        }
        return flag;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_5953_(mouseX, mouseY)) {
            this.focus();
            if (button == 1) {
                this.widget.m_94144_("");
            } else if (button == 2) {
                this.widget.m_94164_(Minecraft.m_91087_().f_91068_.m_90876_());
            }
            this.widget.m_6375_(mouseX, mouseY, button);
            return true;
        }
        return false;
    }

    public void focus() {
        this.m_7522_((GuiEventListener)this.widget);
        this.widget.m_93692_(true);
    }

    @Override
    public void unfocus(@Nullable GuiEventListener guiReplacing) {
        super.unfocus(guiReplacing);
        this.widget.m_93692_(false);
        this.m_7522_(null);
    }

    @Override
    public ComponentPath m_264064_(FocusNavigationEvent event) {
        if (((Fragment)this.parent).m_7222_() != this) {
            this.m_7522_((GuiEventListener)this.widget);
            this.widget.m_93692_(true);
            return super.m_264064_(event);
        }
        return null;
    }

    public void setText(@NotNull String s) {
        if (this.widget == null) {
            iChunUtil.LOGGER.error("You're trying to set a text field widget whilst it is still null. Use setDefaultText instead");
            return;
        }
        this.widget.m_94144_(s);
    }

    public String getText() {
        return this.widget.m_94155_();
    }

    public EditBox getTextField() {
        return this.widget;
    }

    @Override
    public int getMinHeight() {
        return 12;
    }
}

