/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.blahaj.item;

import java.util.Optional;
import mc.recraftors.blahaj.Blahaj;
import mc.recraftors.blahaj.item.CuddlyContainerTooltipData;
import mc.recraftors.blahaj.item.CuddlyItem;
import mc.recraftors.blahaj.item.ItemStackProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemContainerCuddlyItem
extends CuddlyItem {
    public static final String STORED_ITEM_KEY = "Item";

    public ItemContainerCuddlyItem(Item.Properties settings, String subtitle) {
        super(settings, subtitle);
    }

    public boolean m_142207_(ItemStack itemStack, Slot slot, ClickAction clickType, Player playerEntity) {
        if (clickType != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack target = slot.m_7993_();
        CompoundTag nbt = itemStack.m_41737_(STORED_ITEM_KEY);
        if (target.m_41619_()) {
            if (nbt == null) {
                return super.m_142207_(itemStack, slot, clickType, playerEntity);
            }
            ItemStack stored = ItemContainerCuddlyItem.getStoredStack(itemStack);
            if (stored == ItemStack.f_41583_ || !slot.m_5857_(stored)) {
                return super.m_142207_(itemStack, slot, clickType, playerEntity);
            }
            ItemStack e = slot.m_150659_(stored);
            ItemContainerCuddlyItem.storeItemStack(itemStack, e, e.m_41613_());
            this.playRemoveOneSound((Entity)playerEntity);
            return true;
        }
        if (nbt == null) {
            if (!this.canHold(target)) {
                return super.m_142207_(itemStack, slot, clickType, playerEntity);
            }
            ItemContainerCuddlyItem.storeItemStack(itemStack, target, target.m_41613_());
            this.playInsertSound((Entity)playerEntity);
            return true;
        }
        ItemStack stored = ItemStack.m_41712_((CompoundTag)nbt);
        if (ItemStack.m_150942_((ItemStack)stored, (ItemStack)target)) {
            this.mergeStored(itemStack, playerEntity, target, stored);
            return true;
        }
        return super.m_142207_(itemStack, slot, clickType, playerEntity);
    }

    public boolean m_142305_(ItemStack itemStack, ItemStack target, Slot slot, ClickAction type, Player player, SlotAccess reference) {
        if (type != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return super.m_142305_(itemStack, target, slot, type, player, reference);
        }
        CompoundTag nbt = itemStack.m_41737_(STORED_ITEM_KEY);
        if (target.m_41619_()) {
            ItemStack stored = ItemContainerCuddlyItem.getStoredStack(itemStack);
            if (nbt == null) {
                return super.m_142305_(itemStack, target, slot, type, player, reference);
            }
            if (reference.m_142104_(stored)) {
                ItemContainerCuddlyItem.storeItemStack(itemStack, null, 0);
                this.playRemoveOneSound((Entity)player);
                return true;
            }
            return super.m_142305_(itemStack, target, slot, type, player, reference);
        }
        if (nbt == null) {
            if (!this.canHold(target)) {
                return super.m_142305_(itemStack, target, slot, type, player, reference);
            }
            int amount = Math.min(target.m_41613_(), target.m_41720_().m_41459_());
            ItemContainerCuddlyItem.storeItemStack(itemStack, target, amount);
            this.playInsertSound((Entity)player);
            return true;
        }
        ItemStack stored = ItemStack.m_41712_((CompoundTag)nbt);
        if (!ItemStack.m_150942_((ItemStack)stored, (ItemStack)target)) {
            return super.m_142305_(itemStack, target, slot, type, player, reference);
        }
        this.mergeStored(itemStack, player, target, stored);
        return true;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack itemStack) {
        ItemStack stored = ItemContainerCuddlyItem.getStoredStack(itemStack);
        if (stored == ItemStack.f_41583_) {
            return Optional.empty();
        }
        return Optional.of(new CuddlyContainerTooltipData(stored));
    }

    public boolean m_142095_() {
        return false;
    }

    public boolean m_5812_(ItemStack itemStack) {
        return super.m_5812_(((ItemStackProvider)itemStack).blahaj$getStack());
    }

    public ItemStack getContainedStack(ItemStack stack) {
        return ItemContainerCuddlyItem.getStoredStack(stack);
    }

    public TagKey<Item> usableContainedItemTag() {
        return Blahaj.BLAVINGAD_USABLE_ITEMS;
    }

    public Optional<ItemStack> extract(ItemStack stack) {
        CompoundTag nbt = (stack = ((ItemStackProvider)stack).blahaj$getStack()).m_41783_();
        if (nbt == null) {
            return Optional.empty();
        }
        nbt = stack.m_41737_(STORED_ITEM_KEY);
        if (nbt == null) {
            return Optional.empty();
        }
        stack.m_41749_(STORED_ITEM_KEY);
        return Optional.ofNullable(ItemStack.m_41712_((CompoundTag)nbt));
    }

    public boolean setContent(ItemStack itemStack, ItemStack target) {
        ItemContainerCuddlyItem.storeItemStack(itemStack, target, target.m_41613_());
        return true;
    }

    protected void mergeStored(ItemStack itemStack, Player playerEntity, ItemStack target, ItemStack stored) {
        int m;
        int in;
        int acc = target.m_41613_();
        int t = acc + (in = stored.m_41613_());
        if (t >= (m = stored.m_41741_())) {
            ItemContainerCuddlyItem.storeItemStack(itemStack, stored, m);
            target.m_41764_(acc - (m - in));
        } else {
            ItemContainerCuddlyItem.storeItemStack(itemStack, stored, t);
            target.m_41764_(0);
        }
        this.playInsertSound((Entity)playerEntity);
    }

    public static ItemStack getStoredStack(ItemStack stack) {
        CompoundTag nbt = (stack = ((ItemStackProvider)stack).blahaj$getStack()).m_41737_(STORED_ITEM_KEY);
        if (nbt == null) {
            return ItemStack.f_41583_;
        }
        return ItemStack.m_41712_((CompoundTag)nbt);
    }

    public boolean canHold(ItemStack stack) {
        return !(stack = ((ItemStackProvider)stack).blahaj$getStack()).m_41619_() && stack.m_41720_().m_142095_() && !stack.m_204117_(Blahaj.NON_CONTAINABLE_ITEMS);
    }

    public static void storeItemStack(ItemStack container, ItemStack target, int q) {
        container = ((ItemStackProvider)container).blahaj$getStack();
        CompoundTag nbt = container.m_41784_();
        if (target == null || target.m_41619_() || q <= 0) {
            nbt.m_128473_(STORED_ITEM_KEY);
        } else {
            ItemStack e = target.m_41777_();
            e.m_41764_(q);
            nbt.m_128365_(STORED_ITEM_KEY, (Tag)e.m_41739_(new CompoundTag()));
            target.m_41764_(target.m_41613_() - q);
        }
    }

    protected void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    protected void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }
}

