/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.blahaj.item.nbt;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import mc.recraftors.blahaj.item.nbt.ContainedNbtElement;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagVisitor;
import org.jetbrains.annotations.NotNull;

public class ContainedNbtLongArray
extends LongArrayTag
implements ContainedNbtElement<LongArrayTag> {
    @NotNull
    private final LongArrayTag containedArray;
    @NotNull
    private final Set<Consumer<ContainedNbtElement<?>>> dirtyListeners;
    private boolean modified;
    private boolean busy;

    public ContainedNbtLongArray(LongArrayTag nbtLongArray, Consumer<ContainedNbtElement<?>> ... listeners) {
        super(new long[0]);
        this.containedArray = nbtLongArray;
        this.dirtyListeners = new HashSet();
        this.modified = false;
        this.busy = false;
        Arrays.stream(listeners).forEach(this.dirtyListeners::add);
    }

    @Override
    public void dirty() {
        this.modified = true;
        if (this.busy) {
            return;
        }
        this.busy = true;
        this.dirtyListeners.forEach(listener -> listener.accept(this));
        this.busy = false;
    }

    @Override
    public void clean() {
        this.modified = false;
    }

    @Override
    public LongArrayTag getContained() {
        return this.containedArray;
    }

    @Override
    public boolean isDirty() {
        return this.modified;
    }

    @Override
    public Consumer<ContainedNbtElement<?>>[] getListeners() {
        return (Consumer[])this.dirtyListeners.toArray(Consumer[]::new);
    }

    public String toString() {
        return this.containedArray.toString();
    }

    public LongArrayTag m_6426_() {
        return this.containedArray.m_6426_();
    }

    public boolean equals(Object object) {
        return this.containedArray.equals(object);
    }

    public int hashCode() {
        return this.containedArray.hashCode();
    }

    public void m_142327_(TagVisitor nbtElementVisitor) {
        this.containedArray.m_142327_(nbtElementVisitor);
    }

    public long[] m_128851_() {
        return this.containedArray.m_128851_();
    }

    public int size() {
        return this.containedArray.size();
    }

    public LongTag get(int i) {
        return this.containedArray.get(i);
    }

    public void add(int i, LongTag nbtLong) {
        this.containedArray.add(i, nbtLong);
        this.dirty();
    }

    public boolean m_7615_(int i, Tag nbtElement) {
        boolean result = this.containedArray.m_7615_(i, nbtElement);
        if (result) {
            this.dirty();
        }
        return result;
    }

    public boolean m_7614_(int i, Tag nbtElement) {
        boolean result = this.containedArray.m_7614_(i, nbtElement);
        if (result) {
            this.dirty();
        }
        return result;
    }

    public LongTag remove(int i) {
        LongTag result = this.containedArray.remove(i);
        this.dirty();
        return result;
    }

    public boolean add(LongTag nbtLong) {
        boolean result = this.containedArray.add((Object)nbtLong);
        if (result) {
            this.dirty();
        }
        return result;
    }

    public void clear() {
        this.containedArray.clear();
        this.dirty();
    }

    public StreamTagVisitor.ValueResult m_196533_(StreamTagVisitor nbtScanner) {
        StreamTagVisitor.ValueResult result = this.containedArray.m_196533_(nbtScanner);
        this.dirty();
        return result;
    }

    public LongTag set(int i, LongTag nbtElement) {
        LongTag result = (LongTag)this.containedArray.set(i, (Tag)nbtElement);
        this.dirty();
        return result;
    }
}

