/*
 * Decompiled with CFR 0.152.
 */
package mc.recraftors.blahaj.mixin;

import mc.recraftors.blahaj.Blahaj;
import mc.recraftors.blahaj.item.ContainedItemStack;
import mc.recraftors.blahaj.item.HandItemStackProvider;
import mc.recraftors.blahaj.item.ItemContainerCuddlyItem;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements HandItemStackProvider {
    LivingEntityMixin(EntityType<?> entityType, Level world) {
        super(entityType, world);
    }

    @Shadow
    public abstract void m_21153_(float var1);

    @Shadow
    public abstract boolean m_21219_();

    @Shadow
    public abstract boolean m_7292_(MobEffectInstance var1);

    @Shadow
    public abstract ItemStack m_6844_(EquipmentSlot var1);

    @Shadow
    public abstract ItemStack m_21120_(InteractionHand var1);

    @Override
    public ItemStack blahaj$stackInHandFailSafe(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return this.m_6844_(EquipmentSlot.MAINHAND);
        }
        if (hand == InteractionHand.OFF_HAND) {
            return this.m_6844_(EquipmentSlot.OFFHAND);
        }
        throw new IllegalArgumentException("Invalid hand " + hand);
    }

    @Inject(method={"getStackInHand"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetStackInHandReturnInjector(InteractionHand hand, CallbackInfoReturnable<ItemStack> cir) {
        ItemContainerCuddlyItem cuddly;
        ItemStack content;
        if (!this.m_9236_().m_46469_().m_46207_(Blahaj.ENABLE_CONTAINER_USE)) {
            return;
        }
        ItemStack stack = (ItemStack)cir.getReturnValue();
        Item item = stack.m_41720_();
        if (item instanceof ItemContainerCuddlyItem && (content = (cuddly = (ItemContainerCuddlyItem)item).getContainedStack(stack)).m_204117_(cuddly.usableContainedItemTag())) {
            cir.setReturnValue((Object)new ContainedItemStack(stack, content));
        }
    }

    @Inject(method={"setStackInHand"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetStackInHandHeadInjector(InteractionHand hand, ItemStack itemStack, CallbackInfo ci) {
        ItemStack stack = this.m_21120_(hand);
        if (stack instanceof ContainedItemStack) {
            ContainedItemStack containedStack = (ContainedItemStack)stack;
            ci.cancel();
            LivingEntityMixin.blahaj$idkSetStackInHand(this, containedStack, itemStack);
        }
    }

    @Unique
    private static void blahaj$idkSetStackInHand(Entity entity, ContainedItemStack stack1, ItemStack stack2) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_7500_()) {
            return;
        }
        stack1.tryInsertOrDrop((LivingEntity)player, stack2);
    }

    @Redirect(method={"swapHandStacks"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getEquippedStack(Lnet/minecraft/entity/EquipmentSlot;)Lnet/minecraft/item/ItemStack;"))
    private ItemStack handSwapStackGetRedirector(LivingEntity instance, EquipmentSlot equipmentSlot) {
        return switch (equipmentSlot) {
            case EquipmentSlot.MAINHAND -> this.blahaj$stackInHandFailSafe(InteractionHand.MAIN_HAND);
            case EquipmentSlot.OFFHAND -> this.blahaj$stackInHandFailSafe(InteractionHand.OFF_HAND);
            default -> ItemStack.f_41583_;
        };
    }

    @Inject(method={"tryUseTotem"}, at={@At(value="TAIL")}, cancellable=true)
    private void tryUseTotemTryUseContainedTotemInjector(DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        if (cir.getReturnValueZ()) {
            return;
        }
        ItemStack stack = null;
        ItemStack stack2 = null;
        for (InteractionHand hand : InteractionHand.values()) {
            Player player;
            ItemContainerCuddlyItem cuddly;
            ItemStack contained;
            ItemStack handStack = this.blahaj$stackInHandFailSafe(hand);
            Item item = handStack.m_41720_();
            if (!(item instanceof ItemContainerCuddlyItem) || !(contained = (cuddly = (ItemContainerCuddlyItem)item).getContainedStack(handStack)).m_150930_(Items.f_42747_)) continue;
            stack = handStack;
            stack2 = contained;
            LivingEntityMixin livingEntityMixin = this;
            if (livingEntityMixin instanceof Player && (player = (Player)livingEntityMixin).m_7500_()) break;
            cuddly.extract(handStack);
            break;
        }
        if (stack == null) {
            return;
        }
        LivingEntityMixin o = this;
        if (o instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)o;
            player.m_36246_(Stats.f_12982_.m_12902_((Object)Items.f_42747_));
            CriteriaTriggers.f_10551_.m_74431_(player, stack2);
        }
        this.m_21153_(1.0f);
        this.m_21219_();
        this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 700, 0));
        this.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 0));
        this.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 500, 0));
        this.m_9236_().m_7605_((Entity)this, (byte)35);
        cir.setReturnValue((Object)true);
    }
}

