/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.coaxial_gear;

import com.petrolpark.petrolsparts.content.coaxial_gear.CoaxialGearBlock;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.CogwheelBlockItem;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.function.Predicate;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class CoaxialGearBlockItem
extends CogwheelBlockItem {
    public CoaxialGearBlockItem(CoaxialGearBlock block, Item.Properties properties) {
        super((CogWheelBlock)block, properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (ShaftBlock.isShaft((BlockState)state)) {
            if (CoaxialGearBlock.tryMakeLongShaft(state, this.m_40614_(), level, pos, context.m_43723_(), Direction.m_175357_((Entity)player, (Direction.Axis)((Direction.Axis)state.m_61143_((Property)RotatedPillarKineticBlock.AXIS))))) {
                SoundType soundType = this.m_40614_().m_49966_().getSoundType((LevelReader)level, pos, (Entity)player);
                level.m_5594_(null, pos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
                if (!level.m_5776_() && !player.m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            player.m_5661_((Component)Component.m_237115_((String)"petrolsparts.tooltip.coaxial_gear.shaft_too_short").m_130940_(ChatFormatting.RED), true);
            return InteractionResult.SUCCESS;
        }
        return super.onItemUseFirst(stack, context);
    }

    public static class ShaftOnGearPlacementHelper
    implements IPlacementHelper {
        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> ((BlockEntry)AllBlocks.SHAFT).isIn(arg_0);
        }

        public Predicate<BlockState> getStatePredicate() {
            return CoaxialGearBlock::isCoaxialGear;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            return PlacementOffset.success((Vec3i)pos, s -> (BlockState)s.m_61124_((Property)RotatedPillarKineticBlock.AXIS, (Comparable)((Direction.Axis)state.m_61143_((Property)RotatedPillarKineticBlock.AXIS))));
        }
    }

    public static class GearOnShaftPlacementHelper
    implements IPlacementHelper {
        public Predicate<ItemStack> getItemPredicate() {
            return stack -> {
                BlockItem blockItem;
                Item patt3071$temp = stack.m_41720_();
                return patt3071$temp instanceof BlockItem && CoaxialGearBlock.isCoaxialGear((blockItem = (BlockItem)patt3071$temp).m_40614_());
            };
        }

        public Predicate<BlockState> getStatePredicate() {
            return ShaftBlock::isShaft;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            if (ShaftBlock.isShaft((BlockState)state)) {
                for (int i : Iterate.positiveAndNegative) {
                    if (!ShaftBlock.isShaft((BlockState)world.m_8055_(pos.m_121955_(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)state.m_61143_((Property)ShaftBlock.AXIS))).m_122436_().m_142393_(i))))) continue;
                    return PlacementOffset.success((Vec3i)pos, s -> (BlockState)s.m_61124_((Property)RotatedPillarKineticBlock.AXIS, (Comparable)((Direction.Axis)state.m_61143_((Property)RotatedPillarKineticBlock.AXIS))));
                }
            }
            return PlacementOffset.fail();
        }
    }
}

