/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.colossal_cogwheel;

import com.petrolpark.petrolsparts.content.colossal_cogwheel.ColossalCogwheelBlock;
import com.simibubi.create.Create;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class ColossalCogwheelBlockItem
extends BlockItem {
    public final Couple<Integer> onOtherPlacementHelpers = Couple.create((Object)-1, (Object)-1);
    public final Couple<Integer> onColossalPlacementHelpers = Couple.create((Object)-1, (Object)-1);

    public ColossalCogwheelBlockItem(ColossalCogwheelBlock block, Item.Properties properties) {
        super((Block)block, properties);
        for (boolean large : Iterate.trueAndFalse) {
            this.onOtherPlacementHelpers.set(large, (Object)PlacementHelpers.register((IPlacementHelper)new ColossalOnOtherPlacementHelper(large)));
            this.onColossalPlacementHelpers.set(large, (Object)PlacementHelpers.register((IPlacementHelper)new OtherOnColossalPlacementHelper(large)));
        }
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockPos pos;
        Level world = context.m_43725_();
        BlockState state = world.m_8055_(pos = context.m_8083_());
        if (ICogWheel.isLargeCog((Block)state.m_60734_()) || ICogWheel.isSmallCog((Block)state.m_60734_())) {
            IPlacementHelper helper = PlacementHelpers.get((int)((Integer)this.onOtherPlacementHelpers.get(ICogWheel.isLargeCog((Block)state.m_60734_()))));
            Player player = context.m_43723_();
            BlockHitResult ray = new BlockHitResult(context.m_43720_(), context.m_43719_(), pos, true);
            if (helper.matchesState(state) && player != null && !player.m_6144_()) {
                PlacementOffset offset = helper.getOffset(player, world, state, pos, ray);
                Direction.Axis axis = (Direction.Axis)((BlockState)offset.getTransform().apply(this.m_40614_().m_49966_())).m_61143_((Property)RotatedPillarKineticBlock.AXIS);
                return offset.at(offset.getPos().m_121955_((Vec3i)ColossalCogwheelBlock.Position.getRelativeControllerPosition(axis))).placeInWorld(world, (BlockItem)this, player, context.m_43724_(), ray);
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    public InteractionResult m_40576_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Direction.Axis axis = context.m_7820_().m_122434_();
        BlockPos controllerPos = pos.m_121955_((Vec3i)ColossalCogwheelBlock.Position.getRelativeControllerPosition(axis));
        InteractionResult result = !ColossalCogwheelBlockItem.isValidCenterPosition(context.m_43725_(), pos, axis) ? InteractionResult.FAIL : super.m_40576_(BlockPlaceContext.m_43644_((BlockPlaceContext)context, (BlockPos)controllerPos, (Direction)context.m_7820_()));
        if (result == InteractionResult.FAIL) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.showBounds(pos, axis, context.m_43723_()));
        }
        return result;
    }

    public static boolean isValidCenterPosition(Level level, BlockPos pos, Direction.Axis axis) {
        for (ColossalCogwheelBlock.Position.Clock posClock : ColossalCogwheelBlock.Position.Clock.values()) {
            for (ColossalCogwheelBlock.Position.Type posType : ColossalCogwheelBlock.Position.Type.values()) {
                BlockPos targetPos = pos.m_121996_((Vec3i)posType.relativeCenterPos.apply(axis, posClock.getDirection(axis)));
                if (level.m_8055_(targetPos).m_247087_()) continue;
                return false;
            }
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void showBounds(BlockPos centerPos, Direction.Axis axis, Player player) {
        if (!(player instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer localPlayer = (LocalPlayer)player;
        Outliner.getInstance().showCluster((Object)Pair.of((Object)"colossal_cogwheel", (Object)centerPos), (Iterable)Stream.of(ColossalCogwheelBlock.Position.Clock.values()).map(c -> Stream.of(ColossalCogwheelBlock.Position.Type.values()).map(t -> centerPos.m_121955_((Vec3i)t.relativeCenterPos.apply(axis, c.getDirection(axis)))).toList()).collect(ArrayList::new, List::addAll, List::addAll)).colored(-41620);
        Create.lang().translate("large_water_wheel.not_enough_space", new Object[0]).color(-41620).sendStatus((Player)localPlayer);
    }

    public class ColossalOnOtherPlacementHelper
    implements IPlacementHelper {
        public final boolean large;

        public ColossalOnOtherPlacementHelper(boolean large) {
            this.large = large;
        }

        public Predicate<ItemStack> getItemPredicate() {
            return stack -> stack.m_41720_().equals((Object)ColossalCogwheelBlockItem.this);
        }

        public Predicate<BlockState> getStatePredicate() {
            return state -> ICogWheel.isLargeCog((BlockState)state) == this.large && ICogWheel.isSmallCog((BlockState)state) != this.large;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction.Axis axis = ((IRotate)state.m_60734_()).getRotationAxis(state);
            return ColossalCogwheelBlock.Connection.getAll(BlockPos.f_121853_, axis).stream().filter(pair -> ((ColossalCogwheelBlock.Connection)pair.getSecond()).toLargeCog() == this.large).map(pair -> Pair.of((Object)pos.m_121996_((Vec3i)pair.getFirst()), (Object)((ColossalCogwheelBlock.Connection)pair.getSecond()))).filter(pair -> ColossalCogwheelBlockItem.isValidCenterPosition(world, (BlockPos)pair.getFirst(), axis)).map(pair -> Pair.of((Object)((BlockPos)pair.getFirst()), (Object)Vec3.m_82512_((Vec3i)((Vec3i)pair.getFirst())).m_82554_(ray.m_82450_()))).sorted(Comparator.comparingDouble(Pair::getSecond)).map(pair -> PlacementOffset.success((Vec3i)((Vec3i)pair.getFirst()), s -> (BlockState)s.m_61124_((Property)RotatedPillarKineticBlock.AXIS, (Comparable)axis))).findFirst().orElse(PlacementOffset.fail());
        }
    }

    public class OtherOnColossalPlacementHelper
    implements IPlacementHelper {
        public final boolean large;

        public OtherOnColossalPlacementHelper(boolean large) {
            this.large = large;
        }

        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isDedicatedCogItem).and(stack -> ICogWheel.isLargeCogItem((ItemStack)stack) == this.large);
        }

        public Predicate<BlockState> getStatePredicate() {
            return state -> state.m_60713_(ColossalCogwheelBlockItem.this.m_40614_());
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)RotatedPillarKineticBlock.AXIS);
            BlockPos center = pos.m_121955_((Vec3i)ColossalCogwheelBlock.getRelativeCenterPosition(state));
            return ColossalCogwheelBlock.Connection.getAll(center, axis).stream().filter(pair -> ((ColossalCogwheelBlock.Connection)pair.getSecond()).toLargeCog() == this.large).filter(pair -> world.m_8055_((BlockPos)pair.getFirst()).m_247087_()).map(pair -> Pair.of((Object)((BlockPos)pair.getFirst()), (Object)Vec3.m_82512_((Vec3i)((Vec3i)pair.getFirst())).m_82554_(ray.m_82450_()))).sorted(Comparator.comparingDouble(Pair::getSecond)).map(pair -> PlacementOffset.success((Vec3i)((Vec3i)pair.getFirst()), s -> (BlockState)s.m_61124_((Property)CogWheelBlock.AXIS, (Comparable)axis))).findFirst().orElse(PlacementOffset.fail());
        }
    }
}

