/*
 * Decompiled with CFR 0.152.
 */
package guideme.extensions;

import guideme.extensions.Extension;
import guideme.extensions.ExtensionPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class ExtensionCollection {
    private static final ExtensionCollection EMPTY = new ExtensionCollection(Map.of());
    private final List<ExtensionPoint<?>> extensionPoints;
    private final Map<ExtensionPoint<?>, List<Object>> extensions;

    public static ExtensionCollection empty() {
        return EMPTY;
    }

    private ExtensionCollection(Map<ExtensionPoint<?>, List<Object>> extensions) {
        this.extensionPoints = List.copyOf(extensions.keySet());
        IdentityHashMap checkedCollection = new IdentityHashMap(extensions);
        for (Map.Entry<ExtensionPoint<?>, List<Object>> entry : checkedCollection.entrySet()) {
            ExtensionPoint<?> extensionPoint = entry.getKey();
            entry.setValue(List.copyOf((Collection)entry.getValue()));
            for (Object o : entry.getValue()) {
                if (extensionPoint.extensionPointClass().isInstance(o)) continue;
                throw new IllegalArgumentException("Extension point " + extensionPoint + " has incompatible extension registered: " + o);
            }
        }
        this.extensions = checkedCollection;
    }

    public <T extends Extension> List<T> get(ExtensionPoint<T> extensionPoint) {
        List<Object> extensions = this.extensions.get(extensionPoint);
        if (extensions == null) {
            return List.of();
        }
        return extensions;
    }

    public List<ExtensionPoint<?>> getExtensionPoints() {
        return this.extensionPoints;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<ExtensionPoint<?>, List<Object>> extensions = new IdentityHashMap();

        public <T extends Extension> Builder add(ExtensionPoint<T> extensionPoint, T extension) {
            List extensions = this.extensions.computeIfAbsent(extensionPoint, guidebookExtensionPoint -> new ArrayList());
            for (Object o : extensions) {
                if (o != extension) continue;
                throw new IllegalStateException("Extension " + extension + " is already registered for " + extensionPoint);
            }
            extensions.add(extension);
            return this;
        }

        public Builder addAll(ExtensionCollection collection) {
            for (ExtensionPoint<?> extensionPoint : collection.getExtensionPoints()) {
                this.addAll(collection, extensionPoint);
            }
            return this;
        }

        public Builder addAll(Builder builder) {
            for (Map.Entry<ExtensionPoint<?>, List<Object>> entry : builder.extensions.entrySet()) {
                for (Object o : entry.getValue()) {
                    this.addUntyped(entry.getKey(), o);
                }
            }
            return this;
        }

        private <T extends Extension> void addUntyped(ExtensionPoint<T> extensionPoint, Object extension) {
            Extension castExtension = (Extension)extensionPoint.extensionPointClass().cast(extension);
            this.add(extensionPoint, castExtension);
        }

        private <T extends Extension> void addAll(ExtensionCollection collection, ExtensionPoint<T> extensionPoint) {
            for (Extension extension : collection.get(extensionPoint)) {
                this.add(extensionPoint, extension);
            }
        }

        public ExtensionCollection build() {
            ExtensionCollection collection = new ExtensionCollection(this.extensions);
            for (ExtensionPoint<?> extensionPoint : collection.extensionPoints) {
                this.callInitializationCallback(collection, extensionPoint);
            }
            return collection;
        }

        private <T extends Extension> void callInitializationCallback(ExtensionCollection collection, ExtensionPoint<T> extensionPoint) {
            for (Extension extension : collection.get(extensionPoint)) {
                extension.onExtensionsBuilt(collection);
            }
        }
    }
}

