/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.document;

import guideme.internal.shaded.lucene.document.DocValuesLongHashSet;
import guideme.internal.shaded.lucene.index.DocValues;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.NumericDocValues;
import guideme.internal.shaded.lucene.index.SortedNumericDocValues;
import guideme.internal.shaded.lucene.search.ConstantScoreScorer;
import guideme.internal.shaded.lucene.search.ConstantScoreWeight;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.MatchNoDocsQuery;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.TwoPhaseIterator;
import guideme.internal.shaded.lucene.search.Weight;
import guideme.internal.shaded.lucene.util.Accountable;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

final class SortedNumericDocValuesSetQuery
extends Query
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(SortedNumericDocValuesSetQuery.class);
    private final String field;
    private final DocValuesLongHashSet numbers;

    SortedNumericDocValuesSetQuery(String field, long[] numbers) {
        this.field = Objects.requireNonNull(field);
        Arrays.sort(numbers);
        this.numbers = new DocValuesLongHashSet(numbers);
    }

    @Override
    public boolean equals(Object other) {
        if (!this.sameClassAs(other)) {
            return false;
        }
        SortedNumericDocValuesSetQuery that = (SortedNumericDocValuesSetQuery)other;
        return this.field.equals(that.field) && this.numbers.equals(that.numbers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), this.field, this.numbers);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public String toString(String defaultField) {
        return this.field + ": " + this.numbers.toString();
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject(this.field) + RamUsageEstimator.sizeOfObject(this.numbers);
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.numbers.size() == 0) {
            return new MatchNoDocsQuery();
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, SortedNumericDocValuesSetQuery.this.field);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                if (context.reader().getFieldInfos().fieldInfo(SortedNumericDocValuesSetQuery.this.field) == null) {
                    return null;
                }
                final SortedNumericDocValues values = DocValues.getSortedNumeric(context.reader(), SortedNumericDocValuesSetQuery.this.field);
                final NumericDocValues singleton = DocValues.unwrapSingleton(values);
                TwoPhaseIterator iterator = singleton != null ? new TwoPhaseIterator(singleton){

                    @Override
                    public boolean matches() throws IOException {
                        long value = singleton.longValue();
                        return value >= SortedNumericDocValuesSetQuery.this.numbers.minValue && value <= SortedNumericDocValuesSetQuery.this.numbers.maxValue && SortedNumericDocValuesSetQuery.this.numbers.contains(value);
                    }

                    @Override
                    public float matchCost() {
                        return 5.0f;
                    }
                } : new TwoPhaseIterator(values){

                    @Override
                    public boolean matches() throws IOException {
                        int count = values.docValueCount();
                        for (int i = 0; i < count; ++i) {
                            long value = values.nextValue();
                            if (value < SortedNumericDocValuesSetQuery.this.numbers.minValue) continue;
                            if (value > SortedNumericDocValuesSetQuery.this.numbers.maxValue) {
                                return false;
                            }
                            if (!SortedNumericDocValuesSetQuery.this.numbers.contains(value)) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public float matchCost() {
                        return 5.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, iterator);
            }
        };
    }
}

