/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queries.spans;

import guideme.internal.shaded.lucene.queries.spans.SpanDisiPriorityQueue;
import guideme.internal.shaded.lucene.queries.spans.SpanDisiWrapper;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import java.io.IOException;

class SpanDisjunctionDISIApproximation
extends DocIdSetIterator {
    final SpanDisiPriorityQueue subIterators;
    final long cost;

    public SpanDisjunctionDISIApproximation(SpanDisiPriorityQueue subIterators) {
        this.subIterators = subIterators;
        long cost = 0L;
        for (SpanDisiWrapper w : subIterators) {
            cost += w.cost;
        }
        this.cost = cost;
    }

    @Override
    public long cost() {
        return this.cost;
    }

    @Override
    public int docID() {
        return this.subIterators.top().doc;
    }

    @Override
    public int nextDoc() throws IOException {
        SpanDisiWrapper top = this.subIterators.top();
        int doc = top.doc;
        do {
            top.doc = top.approximation.nextDoc();
            top = this.subIterators.updateTop();
        } while (top.doc == doc);
        return top.doc;
    }

    @Override
    public int advance(int target) throws IOException {
        SpanDisiWrapper top = this.subIterators.top();
        do {
            top.doc = top.approximation.advance(target);
            top = this.subIterators.updateTop();
        } while (top.doc < target);
        return top.doc;
    }
}

